/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class EffectConjureWater
extends AbstractEffect {
    public static EffectConjureWater INSTANCE = new EffectConjureWater();

    private EffectConjureWater() {
        super("conjure_water", "Conjure Water");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        Entity entity = rayTraceResult.m_82443_();
        if (entity.m_6060_()) {
            entity.m_20095_();
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        int aoeBuff = spellStats.getBuffCount(AugmentAOE.INSTANCE);
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, rayTraceResult.m_82425_(), rayTraceResult, aoeBuff, spellStats.getBuffCount(AugmentPierce.INSTANCE));
        if (world.m_6042_().m_63951_()) {
            return;
        }
        for (BlockPos pos1 : posList) {
            Block block = world.m_8055_(pos1).m_60734_();
            if (block instanceof SimpleWaterloggedBlock && ((SimpleWaterloggedBlock)block).m_6044_((BlockGetter)world, pos1, world.m_8055_(pos1), (Fluid)Fluids.f_76193_)) {
                ((SimpleWaterloggedBlock)block).m_7361_((LevelAccessor)world, pos1, world.m_8055_(pos1), Fluids.f_76193_.m_76068_(true));
                continue;
            }
            BlockPos hitPos = pos1.m_142300_(rayTraceResult.m_82434_());
            if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), world, pos1) || !world.m_8055_(hitPos).m_60722_((Fluid)Fluids.f_76193_)) continue;
            world.m_46597_(hitPos, Blocks.f_49990_.m_49966_());
        }
    }

    @Override
    public int getDefaultManaCost() {
        return 80;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentPierce.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Places water at a location or extinguishes entities on fire.";
    }

    @Override
    public Item getCraftingReagent() {
        return Items.f_42447_;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_WATER);
    }
}

