/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.curios;

import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.spell.method.MethodOrbit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class SummoningFocus
extends ModItem
implements ISpellModifierItem {
    public static List<AbstractCastMethod> sympatheticMethods = new ArrayList<AbstractCastMethod>();

    public SummoningFocus(Item.Properties properties) {
        super(properties);
    }

    public SummoningFocus(Item.Properties properties, String registryName) {
        super(properties, registryName);
    }

    public SummoningFocus(String registryName) {
        super(registryName);
    }

    @Override
    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        builder.addDamageModifier(1.0);
        return builder;
    }

    public SpellStats.Builder getSimpleStats(SpellStats.Builder builder) {
        builder.addDamageModifier(1.0);
        return builder;
    }

    public static boolean containsThis(Level world, Entity entity) {
        IItemHandlerModifiable items;
        if (!world.f_46443_ && entity instanceof Player && (items = (IItemHandlerModifiable)CuriosUtil.getAllWornItems((LivingEntity)entity).orElse(null)) != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).m_41720_();
                if (!(item instanceof SummoningFocus)) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void summonedEvent(SummonEvent event) {
        if (!event.world.f_46443_ && SummoningFocus.containsThis(event.world, event.summon.getOwner((ServerLevel)event.world))) {
            event.summon.setTicksLeft(event.summon.getTicksLeft() * 2);
            if (event.summon.getLivingEntity() != null) {
                event.summon.getLivingEntity().m_7292_(new MobEffectInstance(MobEffects.f_19600_, 500, 2));
                event.summon.getLivingEntity().m_7292_(new MobEffectInstance(MobEffects.f_19596_, 500, 1));
            }
        }
    }

    @SubscribeEvent
    public static void castSpell(SpellCastEvent event) {
        if (!event.getWorld().f_46443_ && event.getEntity() instanceof Player && SummoningFocus.containsThis(event.getWorld(), (Entity)event.getEntityLiving()) && event.spell.getCastMethod() != null && sympatheticMethods.contains(event.spell.getCastMethod())) {
            for (LivingEntity i : event.getWorld().m_6443_(LivingEntity.class, new AABB(event.getEntityLiving().m_142538_()).m_82400_(30.0), l -> l instanceof ISummon)) {
                if (!event.getEntityLiving().equals((Object)((ISummon)i).getOwner((ServerLevel)event.getWorld()))) continue;
                EntitySpellResolver spellResolver = new EntitySpellResolver(new SpellContext(event.spell, i).withColors(event.context.colors));
                spellResolver.onCast(ItemStack.f_41583_, i, i.f_19853_);
            }
        }
    }

    @SubscribeEvent
    public static void summonDeathEvent(SummonEvent.Death event) {
        DamageSource source;
        if (!event.world.f_46443_ && SummoningFocus.containsThis(event.world, event.summon.getOwner((ServerLevel)event.world)) && (source = event.source) != null && source.m_7639_() != null) {
            source.m_7639_().m_6469_(DamageSource.m_19335_((Entity)source.m_7639_()).m_19380_(), 5.0f);
        }
    }

    static {
        sympatheticMethods.add(MethodSelf.INSTANCE);
        sympatheticMethods.add(MethodOrbit.INSTANCE);
    }
}

