/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.renderer.item.SpellBowRenderer;
import com.hollingsworth.arsnouveau.common.entity.EntitySpellArrow;
import com.hollingsworth.arsnouveau.common.items.SpellArrow;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SpellBow
extends BowItem
implements IAnimatable,
ICasterTool {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public SpellBow(Item.Properties p_40660_) {
        super(p_40660_);
    }

    public SpellBow() {
        super(ItemsRegistry.defaultItemProperties().m_41487_(1));
    }

    public boolean canPlayerCastSpell(ItemStack bow, Player playerentity) {
        ISpellCaster caster = this.getSpellCaster(bow);
        return new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).withSilent(true).canCast((LivingEntity)playerentity);
    }

    public ItemStack findAmmo(Player playerEntity, ItemStack shootable) {
        if (!(shootable.m_41720_() instanceof ProjectileWeaponItem)) {
            return ItemStack.f_41583_;
        }
        Predicate<ItemStack> predicate = ((ProjectileWeaponItem)shootable.m_41720_()).m_6442_().and(i -> !(i.m_41720_() instanceof SpellArrow) || i.m_41720_() instanceof SpellArrow && this.canPlayerCastSpell(shootable, playerEntity));
        ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)playerEntity, predicate);
        if (!itemstack.m_41619_()) {
            return itemstack;
        }
        predicate = ((ProjectileWeaponItem)shootable.m_41720_()).m_6437_().and(i -> !(i.m_41720_() instanceof SpellArrow) || i.m_41720_() instanceof SpellArrow && this.canPlayerCastSpell(shootable, playerEntity));
        for (int i2 = 0; i2 < playerEntity.m_150109_().m_6643_(); ++i2) {
            ItemStack itemstack1 = playerEntity.f_36093_.m_8020_(i2);
            if (!predicate.test(itemstack1)) continue;
            return itemstack1;
        }
        return playerEntity.f_36077_.f_35937_ ? new ItemStack((ItemLike)Items.f_42412_) : ItemStack.f_41583_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        ISpellCaster caster = this.getSpellCaster(playerIn.m_21120_(handIn));
        boolean hasAmmo = !this.findAmmo(playerIn, itemstack).m_41619_();
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)worldIn, (Player)playerIn, (InteractionHand)handIn, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (hasAmmo || caster.getSpell().isValid() && new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerIn)).withSilent(true).canCast((LivingEntity)playerIn)) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!playerIn.f_36077_.f_35937_ && !hasAmmo) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public EntitySpellArrow buildSpellArrow(Level worldIn, Player playerentity, ISpellCaster caster, boolean isSpellArrow) {
        EntitySpellArrow spellArrow = new EntitySpellArrow(worldIn, (LivingEntity)playerentity);
        spellArrow.spellResolver = new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity).withColors(caster.getColor())).withSilent(true);
        spellArrow.setColors(caster.getColor().r, caster.getColor().g, caster.getColor().b);
        if (isSpellArrow) {
            spellArrow.m_36781_(0.0);
        }
        return spellArrow;
    }

    /*
     * WARNING - void declaration
     */
    public void m_5551_(ItemStack bowStack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player playerentity = (Player)entityLiving;
        boolean isInfinity = playerentity.f_36077_.f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)bowStack) > 0;
        ItemStack arrowStack = this.findAmmo(playerentity, bowStack);
        int useTime = this.m_8105_(bowStack) - timeLeft;
        useTime = ForgeEventFactory.onArrowLoose((ItemStack)bowStack, (Level)worldIn, (Player)playerentity, (int)useTime, (!arrowStack.m_41619_() || isInfinity ? 1 : 0) != 0);
        if (useTime < 0) {
            return;
        }
        boolean canFire = false;
        if (!arrowStack.m_41619_() || isInfinity) {
            if (arrowStack.m_41619_()) {
                arrowStack = new ItemStack((ItemLike)Items.f_42412_);
            }
            canFire = true;
        }
        ISpellCaster caster = this.getSpellCaster(bowStack);
        boolean isSpellArrow = false;
        if (arrowStack.m_41619_() && caster.getSpell() != null && new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).canCast((LivingEntity)playerentity)) {
            canFire = true;
            isSpellArrow = true;
        }
        if (!canFire) {
            return;
        }
        float f = SpellBow.m_40661_((int)useTime);
        if ((double)f >= 0.1) {
            boolean isArrowInfinite;
            boolean bl = isArrowInfinite = playerentity.f_36077_.f_35937_ || arrowStack.m_41720_() instanceof ArrowItem && ((ArrowItem)arrowStack.m_41720_()).isInfinite(arrowStack, bowStack, playerentity);
            if (!worldIn.f_46443_) {
                ArrowItem arrowitem = (ArrowItem)(arrowStack.m_41720_() instanceof ArrowItem ? arrowStack.m_41720_() : Items.f_42412_);
                Object abstractarrowentity = arrowitem.m_6394_(worldIn, arrowStack, (LivingEntity)playerentity);
                abstractarrowentity = this.customArrow((AbstractArrow)abstractarrowentity);
                ArrayList<Object> arrows = new ArrayList<Object>();
                boolean didCastSpell = false;
                if (arrowitem == Items.f_42412_ && new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).withSilent(true).canCast((LivingEntity)playerentity)) {
                    abstractarrowentity = this.buildSpellArrow(worldIn, playerentity, caster, isSpellArrow);
                    new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).expendMana((LivingEntity)playerentity);
                    didCastSpell = true;
                } else if (arrowitem instanceof SpellArrow) {
                    if (!new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).canCast((LivingEntity)playerentity)) {
                        return;
                    }
                    if (new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).canCast((LivingEntity)playerentity)) {
                        new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).expendMana((LivingEntity)playerentity);
                        didCastSpell = true;
                    }
                }
                arrows.add(abstractarrowentity);
                if (caster.getSpell().isValid() && didCastSpell) {
                    void var19_21;
                    int numSplits = caster.getSpell().getBuffsAtIndex(0, (LivingEntity)playerentity, AugmentSplit.INSTANCE);
                    if (abstractarrowentity instanceof EntitySpellArrow) {
                        numSplits = ((EntitySpellArrow)((Object)abstractarrowentity)).spellResolver.spell.getBuffsAtIndex(0, (LivingEntity)playerentity, AugmentSplit.INSTANCE);
                    }
                    boolean bl2 = true;
                    while (var19_21 < numSplits + 1) {
                        Direction offset = playerentity.m_6350_().m_122427_();
                        if (var19_21 % 2 == false) {
                            offset = offset.m_122424_();
                        }
                        BlockPos projPos = playerentity.m_142538_().m_5484_(offset, (int)var19_21);
                        projPos = projPos.m_142022_(0.0, 1.5, 0.0);
                        EntitySpellArrow spellArrow = this.buildSpellArrow(worldIn, playerentity, caster, isSpellArrow);
                        spellArrow.m_6034_(projPos.m_123341_(), spellArrow.m_142538_().m_123342_(), projPos.m_123343_());
                        arrows.add((Object)spellArrow);
                        ++var19_21;
                    }
                }
                for (AbstractArrow abstractArrow : arrows) {
                    abstractArrow.m_37251_((Entity)playerentity, playerentity.f_19858_, playerentity.f_19857_, 0.0f, f * 3.0f, 1.0f);
                    if (f >= 1.0f) {
                        abstractArrow.m_36762_(true);
                    }
                    this.addArrow(abstractArrow, bowStack, arrowStack, isArrowInfinite, playerentity);
                }
            }
            worldIn.m_6263_(null, playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.f_46441_.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (!isArrowInfinite && !playerentity.f_36077_.f_35937_) {
                arrowStack.m_41774_(1);
            }
        }
    }

    public void addArrow(AbstractArrow abstractarrowentity, ItemStack bowStack, ItemStack arrowStack, boolean isArrowInfinite, Player playerentity) {
        int punch;
        int power = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bowStack);
        if (power > 0) {
            abstractarrowentity.m_36781_(abstractarrowentity.m_36789_() + (double)power * 0.5 + 0.5);
        }
        if ((punch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bowStack)) > 0) {
            abstractarrowentity.m_36735_(punch);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)bowStack) > 0) {
            abstractarrowentity.m_20254_(100);
        }
        if (isArrowInfinite || playerentity.f_36077_.f_35937_ && (arrowStack.m_41720_() == Items.f_42737_ || arrowStack.m_41720_() == Items.f_42738_)) {
            abstractarrowentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        playerentity.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    public Predicate<ItemStack> m_6437_() {
        return f_43005_.or(i -> i.m_41720_() instanceof SpellArrow);
    }

    public void registerControllers(AnimationData data) {
    }

    public AbstractArrow customArrow(AbstractArrow arrow) {
        return super.customArrow(arrow);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        this.getInformation(stack, worldIn, tooltip2, flagIn);
        super.m_7373_(stack, worldIn, tooltip2, flagIn);
    }

    @Override
    public boolean isScribedSpellValid(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return spell.recipe.stream().noneMatch(s -> s instanceof AbstractCastMethod);
    }

    @Override
    public void sendInvalidMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)new TranslatableComponent("ars_nouveau.bow.invalid"));
    }

    @Override
    public boolean setSpell(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        recipe.add(MethodProjectile.INSTANCE);
        recipe.addAll(spell.recipe);
        spell.recipe = recipe;
        return ICasterTool.super.setSpell(caster, player, hand, stack, spell);
    }

    public int m_6473_() {
        return super.m_6473_();
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer renderer = new SpellBowRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }
}

