/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.event.FlightRefreshEvent;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.LavaLily;
import com.hollingsworth.arsnouveau.common.command.DataDumpCommand;
import com.hollingsworth.arsnouveau.common.command.PathCommand;
import com.hollingsworth.arsnouveau.common.command.ResetCommand;
import com.hollingsworth.arsnouveau.common.compat.CaelusHandler;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.ritual.RitualFlight;
import com.hollingsworth.arsnouveau.setup.Config;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void itemPickupEvent(EntityItemPickupEvent event) {
        ItemStack pickingUp;
        Player player = event.getPlayer();
        boolean voided = VoidJar.tryVoiding(player, pickingUp = event.getItem().m_32055_());
        if (voided) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void livingHurtEvent(LivingHurtEvent e) {
        if (!e.getEntityLiving().f_19853_.f_46443_ && e.getEntityLiving() instanceof Player && e.getEntityLiving().m_21254_() && e.getEntityLiving().m_21055_((Item)ItemsRegistry.ENCHANTERS_SHIELD)) {
            e.getEntityLiving().m_7292_(new MobEffectInstance((MobEffect)ModPotions.MANA_REGEN_EFFECT, 200, 1));
            e.getEntityLiving().m_7292_(new MobEffectInstance(ModPotions.SPELL_DAMAGE_EFFECT, 200, 1));
        }
    }

    @SubscribeEvent
    public static void livingAttackEvent(LivingAttackEvent e) {
        Level world;
        if (e.getSource() == DamageSource.f_19309_ && e.getEntityLiving() != null && !e.getEntity().m_20193_().f_46443_ && (world = e.getEntity().f_19853_).m_8055_(e.getEntityLiving().m_142538_()).m_60734_() instanceof LavaLily) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent e) {
        if (e.getEntityLiving() == null || e.getEntityLiving().m_21124_((MobEffect)ModPotions.SNARE_EFFECT) == null) {
            return;
        }
        e.getEntityLiving().m_20334_(0.0, 0.0, 0.0);
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        String book_tag;
        if (e.getEntityLiving().m_20193_().f_46443_ || !((Boolean)Config.SPAWN_BOOK.get()).booleanValue()) {
            return;
        }
        CompoundTag tag = e.getPlayer().getPersistentData().m_128469_("PlayerPersisted");
        if (tag.m_128471_(book_tag = "an_book_")) {
            return;
        }
        LivingEntity entity = e.getEntityLiving();
        e.getEntityLiving().m_20193_().m_7967_((Entity)new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)ItemsRegistry.WORN_NOTEBOOK)));
        tag.m_128379_(book_tag, true);
        e.getPlayer().getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
    }

    @SubscribeEvent
    public static void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ClientInfo.ticksInGame;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGlideTick(TickEvent.PlayerTickEvent event) {
        if (ArsNouveau.caelusLoaded && event.player.m_21023_((MobEffect)ModPotions.GLIDE_EFFECT)) {
            CaelusHandler.setFlying(event.player);
        }
        if (event.player.m_21023_((MobEffect)ModPotions.FLIGHT_EFFECT) && event.player.f_19853_.m_46467_() % 20L == 0L && event.player.m_21124_((MobEffect)ModPotions.FLIGHT_EFFECT).m_19557_() <= 600) {
            FlightRefreshEvent flightRefreshEvent = new FlightRefreshEvent(event.player);
            MinecraftForge.EVENT_BUS.post((Event)flightRefreshEvent);
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        Player entity;
        if (!event.getEntityLiving().f_19853_.f_46443_ && event.getEntityLiving() instanceof Player && (entity = (Player)event.getEntityLiving()).m_21124_((MobEffect)ModPotions.FLIGHT_EFFECT) == null && RitualFlight.RitualFlightHandler.canPlayerStillFly((LivingEntity)entity) != null) {
            RitualFlight.RitualFlightHandler.grantFlight((LivingEntity)entity);
        }
    }

    @SubscribeEvent
    public static void playerDamaged(LivingHurtEvent e) {
        if (e.getEntityLiving() != null && e.getEntityLiving().m_21221_().containsKey((Object)ModPotions.SHIELD_POTION) && (e.getSource() == DamageSource.f_19319_ || e.getSource() == DamageSource.f_19318_ || e.getSource() instanceof EntityDamageSource)) {
            float damage = e.getAmount() - (1.0f + 0.5f * (float)((MobEffectInstance)e.getEntityLiving().m_21221_().get((Object)ModPotions.SHIELD_POTION)).m_19564_());
            e.setAmount(Math.max(0.0f, damage));
        }
    }

    @SubscribeEvent
    public static void entityHurt(LivingHurtEvent e) {
        LivingEntity entity;
        if (e.getEntityLiving() != null && e.getSource() == DamageSource.f_19306_ && e.getEntityLiving().m_21124_((MobEffect)ModPotions.SHOCKED_EFFECT) != null) {
            float damage = e.getAmount() + 3.0f + 3.0f * (float)e.getEntityLiving().m_21124_((MobEffect)ModPotions.SHOCKED_EFFECT).m_19564_();
            e.setAmount(Math.max(0.0f, damage));
        }
        if ((entity = e.getEntityLiving()) != null && entity.m_21124_((MobEffect)ModPotions.HEX_EFFECT) != null && (entity.m_21124_(MobEffects.f_19614_) != null || entity.m_21124_(MobEffects.f_19615_) != null || entity.m_6060_() || entity.m_21124_((MobEffect)ModPotions.SHOCKED_EFFECT) != null)) {
            e.setAmount(e.getAmount() + 0.5f + 0.33f * (float)entity.m_21124_((MobEffect)ModPotions.HEX_EFFECT).m_19564_());
        }
    }

    @SubscribeEvent
    public static void entityHeal(LivingHealEvent e) {
        LivingEntity entity = e.getEntityLiving();
        if (entity != null && entity.m_21124_((MobEffect)ModPotions.HEX_EFFECT) != null) {
            e.setAmount(e.getAmount() / 2.0f);
        }
    }

    @SubscribeEvent
    public static void dispelEvent(DispelEvent event) {
        LivingEntity entity;
        if (event.rayTraceResult instanceof EntityHitResult && ((EntityHitResult)event.rayTraceResult).m_82443_() instanceof LivingEntity && (entity = (LivingEntity)((EntityHitResult)event.rayTraceResult).m_82443_()) instanceof Witch && entity.m_21223_() <= entity.m_21233_() / 2.0f) {
            entity.m_142687_(Entity.RemovalReason.KILLED);
            ParticleUtil.spawnPoof((ServerLevel)event.world, entity.m_142538_());
            event.world.m_7967_((Entity)new ItemEntity(event.world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)ItemsRegistry.WIXIE_SHARD)));
        }
    }

    @SubscribeEvent
    public static void commandRegister(RegisterCommandsEvent event) {
        ResetCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        DataDumpCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PathCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private EventHandler() {
    }
}

