/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs;

import com.hollingsworth.arsnouveau.common.entity.pathfinding.ChunkCache;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.ModNode;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathPointExtended;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathResult;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingConstants;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingOptions;
import com.hollingsworth.arsnouveau.common.util.Log;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractPathJob
implements Callable<Path> {
    public static boolean DEBUG_DRAW = false;
    public static Set<ModNode> lastDebugNodesVisited;
    public static Set<ModNode> lastDebugNodesNotVisited;
    public static Set<ModNode> lastDebugNodesPath;
    protected final BlockPos start;
    protected final LevelReader world;
    protected final PathResult result;
    protected final int maxRange;
    public Queue<ModNode> nodesOpen = new PriorityQueue<ModNode>(500);
    public Map<Integer, ModNode> nodesVisited = new HashMap<Integer, ModNode>();
    protected boolean debugDrawEnabled = false;
    protected Set<ModNode> debugNodesVisited = null;
    protected Set<ModNode> debugNodesNotVisited = null;
    protected Set<ModNode> debugNodesPath = null;
    private final boolean allowJumpPointSearchTypeWalk;
    private int totalNodesAdded = 0;
    public int totalNodesVisited = 0;
    private final boolean xzRestricted;
    private final boolean hardXzRestriction;
    private PathingOptions pathingOptions = new PathingOptions();
    private int maxX;
    private int minX;
    private int maxZ;
    private int minZ;
    protected WeakReference<LivingEntity> entity;

    public AbstractPathJob(Level world, BlockPos start, BlockPos end, int range, LivingEntity entity) {
        this(world, start, end, range, new PathResult(), entity);
    }

    public AbstractPathJob(Level world, BlockPos start, BlockPos end, int range, PathResult result, LivingEntity entity) {
        int minX = Math.min(start.m_123341_(), end.m_123341_()) - range / 2;
        int minZ = Math.min(start.m_123343_(), end.m_123343_()) - range / 2;
        int maxX = Math.max(start.m_123341_(), end.m_123341_()) + range / 2;
        int maxZ = Math.max(start.m_123343_(), end.m_123343_()) + range / 2;
        this.xzRestricted = false;
        this.hardXzRestriction = false;
        this.world = new ChunkCache(world, new BlockPos(minX, world.m_141937_(), minZ), new BlockPos(maxX, world.m_151558_(), maxZ), range, world.m_6042_());
        this.start = new BlockPos((Vec3i)start);
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (DEBUG_DRAW) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<ModNode>();
            this.debugNodesNotVisited = new HashSet<ModNode>();
            this.debugNodesPath = new HashSet<ModNode>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    public AbstractPathJob(Level world, BlockPos start, BlockPos startRestriction, BlockPos endRestriction, int range, boolean hardRestriction, PathResult<AbstractPathJob> result, LivingEntity entity) {
        this(world, start, startRestriction, endRestriction, range, Vec3i.f_123288_, hardRestriction, result, entity);
    }

    public AbstractPathJob(Level world, BlockPos start, BlockPos startRestriction, BlockPos endRestriction, int range, Vec3i grow, boolean hardRestriction, PathResult<AbstractPathJob> result, LivingEntity entity) {
        this.minX = Math.min(startRestriction.m_123341_(), endRestriction.m_123341_()) - grow.m_123341_();
        this.minZ = Math.min(startRestriction.m_123343_(), endRestriction.m_123343_()) - grow.m_123343_();
        this.maxX = Math.max(startRestriction.m_123341_(), endRestriction.m_123341_()) + grow.m_123341_();
        this.maxZ = Math.max(startRestriction.m_123343_(), endRestriction.m_123343_()) + grow.m_123343_();
        this.xzRestricted = true;
        this.hardXzRestriction = hardRestriction;
        this.world = new ChunkCache(world, new BlockPos(this.minX, world.m_141937_(), this.minZ), new BlockPos(this.maxX, world.m_151558_(), this.maxZ), range, world.m_6042_());
        this.start = start;
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (DEBUG_DRAW) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<ModNode>();
            this.debugNodesNotVisited = new HashSet<ModNode>();
            this.debugNodesPath = new HashSet<ModNode>();
        }
        this.entity = new WeakReference<LivingEntity>(entity);
    }

    protected boolean onLadderGoingUp(ModNode currentNode, BlockPos dPos) {
        return currentNode.isLadder() && (dPos.m_123342_() >= 0 || dPos.m_123341_() != 0 || dPos.m_123343_() != 0);
    }

    public static BlockPos prepareStart(LivingEntity entity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Mth.m_14107_((double)entity.m_20185_()), Mth.m_14107_((double)entity.m_20186_()), Mth.m_14107_((double)entity.m_20189_()));
        BlockState bs = entity.f_19853_.m_8055_((BlockPos)pos);
        VoxelShape collisionShape = bs.m_60812_((BlockGetter)entity.f_19853_, (BlockPos)pos);
        if (bs.m_60767_().m_76334_() && collisionShape.m_83297_(Direction.Axis.Y) > 0.0) {
            double relPosX = Math.abs(entity.m_20185_() % 1.0);
            double relPosZ = Math.abs(entity.m_20189_() % 1.0);
            for (AABB box : collisionShape.m_83299_()) {
                if (!(relPosX >= box.f_82288_) || !(relPosX <= box.f_82291_) || !(relPosZ >= box.f_82290_) || !(relPosZ <= box.f_82293_) || !(box.f_82292_ > 0.0)) continue;
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                bs = entity.f_19853_.m_8055_((BlockPos)pos);
                break;
            }
        }
        BlockState down = entity.f_19853_.m_8055_(pos.m_7495_());
        while (!bs.m_60767_().m_76334_() && !down.m_60767_().m_76334_() && !down.m_60734_().isLadder(down, (LevelReader)entity.m_20193_(), pos.m_7495_(), entity) && bs.m_60819_().m_76178_()) {
            pos.m_122175_(Direction.DOWN, 1);
            bs = down;
            down = entity.f_19853_.m_8055_(pos.m_7495_());
            if (pos.m_123342_() >= 0) continue;
            return entity.m_142538_();
        }
        Block b = bs.m_60734_();
        if (entity.m_20069_()) {
            while (!bs.m_60819_().m_76178_()) {
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                bs = entity.f_19853_.m_8055_((BlockPos)pos);
            }
        } else if (b instanceof FenceBlock || b instanceof WallBlock || bs.m_60767_().m_76333_()) {
            double dX = entity.m_20185_() - Math.floor(entity.m_20185_());
            double dZ = entity.m_20189_() - Math.floor(entity.m_20189_());
            if (dX < 0.25) {
                pos.m_122178_(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
            } else if (dX > 0.75) {
                pos.m_122178_(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            }
            if (dZ < 0.25) {
                pos.m_122178_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
            } else if (dZ > 0.75) {
                pos.m_122178_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
            }
        }
        return pos.m_7949_();
    }

    private static void setLadderFacing(LevelReader world, BlockPos pos, PathPointExtended p) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof VineBlock) {
            if (((Boolean)state.m_61143_((Property)VineBlock.f_57836_)).booleanValue()) {
                p.setLadderFacing(Direction.NORTH);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57837_)).booleanValue()) {
                p.setLadderFacing(Direction.EAST);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57834_)).booleanValue()) {
                p.setLadderFacing(Direction.SOUTH);
            } else if (((Boolean)state.m_61143_((Property)VineBlock.f_57835_)).booleanValue()) {
                p.setLadderFacing(Direction.WEST);
            }
        } else if (block instanceof LadderBlock) {
            p.setLadderFacing((Direction)state.m_61143_((Property)LadderBlock.f_54337_));
        } else {
            p.setLadderFacing(Direction.UP);
        }
    }

    private static boolean onALadder(ModNode node, ModNode nextInPath, BlockPos pos) {
        return nextInPath != null && node.isLadder() && nextInPath.pos.m_123341_() == pos.m_123341_() && nextInPath.pos.m_123343_() == pos.m_123343_();
    }

    private static int computeNodeKey(BlockPos pos) {
        return (pos.m_123341_() & 0xFFF) << 20 | (pos.m_123342_() & 0xFF) << 12 | pos.m_123343_() & 0xFFF;
    }

    protected double computeCost(BlockPos dPos, boolean isSwimming, boolean onPath, boolean onRails, boolean railsExit, boolean swimStart, boolean corner, BlockPos blockPos) {
        double cost = Math.sqrt(dPos.m_123341_() * dPos.m_123341_() + dPos.m_123342_() * dPos.m_123342_() + dPos.m_123343_() * dPos.m_123343_());
        if (!(dPos.m_123342_() == 0 || Math.abs(dPos.m_123342_()) <= 1 && this.world.m_8055_(blockPos).m_60734_() instanceof StairBlock)) {
            cost = dPos.m_123342_() > 0 ? (cost *= this.pathingOptions.jumpCost * (double)Math.abs(dPos.m_123342_())) : (cost *= this.pathingOptions.dropCost * (double)Math.abs(dPos.m_123342_()));
        }
        if (this.world.m_8055_(blockPos).m_61138_((Property)BlockStateProperties.f_61446_)) {
            cost *= this.pathingOptions.traverseToggleAbleCost;
        }
        if (onPath) {
            cost *= this.pathingOptions.onPathCost;
        }
        if (onRails) {
            cost *= this.pathingOptions.onRailCost;
        }
        if (railsExit) {
            cost *= this.pathingOptions.railsExitCost;
        }
        if (isSwimming) {
            cost = swimStart ? (cost *= this.pathingOptions.swimCostEnter) : (cost *= this.pathingOptions.swimCost);
        }
        return cost;
    }

    private static boolean nodeClosed(ModNode node) {
        return node != null && node.isClosed();
    }

    private static boolean calculateSwimming(LevelReader world, BlockPos pos, ModNode node) {
        return node == null ? AbstractPathJob.isWater(world, pos.m_7495_()) : node.isSwimming();
    }

    private static boolean isWater(LevelReader world, BlockPos pos) {
        return AbstractPathJob.isWater(world, pos, null, null);
    }

    private static boolean isWater(LevelReader world, BlockPos pos, BlockState pState, FluidState pFluidState) {
        BlockState state = pState;
        if (state == null) {
            state = world.m_8055_(pos);
        }
        if (state.m_60815_()) {
            return false;
        }
        if (state.m_60734_() == Blocks.f_49990_) {
            return true;
        }
        FluidState fluidState = pFluidState;
        if (fluidState == null) {
            fluidState = world.m_6425_(pos);
        }
        if (fluidState == null || fluidState.m_76178_()) {
            return false;
        }
        Fluid fluid = fluidState.m_76152_();
        return fluid == Fluids.f_76193_ || fluid == Fluids.f_76192_;
    }

    public PathResult getResult() {
        return this.result;
    }

    @Override
    public final Path call() {
        try {
            return this.search();
        }
        catch (Exception e) {
            Log.getLogger().warn("Pathfinding Exception", (Throwable)e);
            return null;
        }
    }

    protected Path search() {
        ModNode bestNode = this.getAndSetupStartNode();
        double bestNodeResultScore = Double.MAX_VALUE;
        while (!this.nodesOpen.isEmpty()) {
            boolean isViablePosition;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            ModNode currentNode = this.nodesOpen.poll();
            ++this.totalNodesVisited;
            if (this.totalNodesVisited > this.maxRange * this.maxRange) break;
            currentNode.setCounterVisited(this.totalNodesVisited);
            this.handleDebugOptions(currentNode);
            currentNode.setClosed();
            boolean bl = isViablePosition = this.isInRestrictedArea(currentNode.pos) && this.isWalkableSurface(this.world.m_8055_(currentNode.pos.m_7495_()), currentNode.pos.m_7495_()) == SurfaceType.WALKABLE;
            if (isViablePosition && this.isAtDestination(currentNode)) {
                bestNode = currentNode;
                this.result.setPathReachesDestination(true);
                break;
            }
            double nodeResultScore = this.getNodeResultScore(currentNode);
            if (isViablePosition && nodeResultScore < bestNodeResultScore && !currentNode.isCornerNode()) {
                bestNode = currentNode;
                bestNodeResultScore = nodeResultScore;
            }
            if (this.hardXzRestriction && !isViablePosition) continue;
            this.walkCurrentNode(currentNode);
        }
        Path path = this.finalizePath(bestNode);
        this.handleDebugDraw();
        return path;
    }

    private void handleDebugOptions(ModNode currentNode) {
        if (this.debugDrawEnabled && this.debugNodesNotVisited != null && this.debugNodesVisited != null && currentNode != null) {
            this.addNodeToDebug(currentNode);
        }
    }

    private void addNodeToDebug(ModNode currentNode) {
        this.debugNodesNotVisited.remove(currentNode);
        this.debugNodesVisited.add(currentNode);
    }

    private void addPathNodeToDebug(ModNode node) {
        this.debugNodesVisited.remove(node);
        this.debugNodesPath.add(node);
    }

    private void walkCurrentNode(ModNode currentNode) {
        BlockPos dPos = PathingConstants.BLOCKPOS_IDENTITY;
        if (currentNode.parent != null) {
            dPos = currentNode.pos.m_141950_((Vec3i)currentNode.parent.pos);
        }
        if (this.onLadderGoingUp(currentNode, dPos)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_UP);
        }
        if (this.onLadderGoingDown(currentNode, dPos)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
        }
        if ((currentNode.parent == null || !currentNode.parent.pos.equals((Object)currentNode.pos.m_7495_())) && currentNode.isCornerNode()) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
            return;
        }
        if (this.isPassable(currentNode.pos.m_7495_(), false, currentNode.parent)) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_DOWN);
        }
        if (dPos.m_123343_() <= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_NORTH);
        }
        if (dPos.m_123341_() >= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_EAST);
        }
        if (dPos.m_123343_() >= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_SOUTH);
        }
        if (dPos.m_123341_() <= 0) {
            this.walk(currentNode, PathingConstants.BLOCKPOS_WEST);
        }
    }

    protected boolean onLadderGoingDown(ModNode currentNode, BlockPos dPos) {
        return (dPos.m_123342_() <= 0 || dPos.m_123341_() != 0 || dPos.m_123343_() != 0) && this.isLadder(currentNode.pos.m_7495_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDebugDraw() {
        if (this.debugDrawEnabled) {
            Object object = PathingConstants.debugNodeMonitor;
            synchronized (object) {
                lastDebugNodesNotVisited = this.debugNodesNotVisited;
                lastDebugNodesVisited = this.debugNodesVisited;
                lastDebugNodesPath = this.debugNodesPath;
            }
        }
    }

    private ModNode getAndSetupStartNode() {
        ModNode startNode = new ModNode(this.start, this.computeHeuristic(this.start));
        if (this.isLadder(this.start)) {
            startNode.setLadder();
        } else if (this.isLiquid(this.world.m_8055_(this.start.m_7495_()))) {
            startNode.setSwimming();
        }
        startNode.setOnRails(this.pathingOptions.canUseRails() && this.world.m_8055_(this.start).m_60734_() instanceof BaseRailBlock);
        this.nodesOpen.offer(startNode);
        this.nodesVisited.put(AbstractPathJob.computeNodeKey(this.start), startNode);
        ++this.totalNodesAdded;
        return startNode;
    }

    public boolean isLiquid(BlockState state) {
        return state.m_60767_().m_76332_() || !state.m_60767_().m_76334_() && !state.m_60819_().m_76178_();
    }

    private Path finalizePath(ModNode targetNode) {
        int pathLength = 1;
        int railsLength = 0;
        ModNode node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            if (node.isOnRails()) {
                ++railsLength;
            }
            node = node.parent;
        }
        Node[] points = new Node[pathLength];
        points[0] = new PathPointExtended(node.pos);
        if (this.debugDrawEnabled) {
            this.addPathNodeToDebug(node);
        }
        ModNode nextInPath = null;
        PathPointExtended next = null;
        node = targetNode;
        while (node.parent != null) {
            if (this.debugDrawEnabled) {
                this.addPathNodeToDebug(node);
            }
            --pathLength;
            BlockPos pos = node.pos;
            if (node.isSwimming()) {
                pos.m_141952_((Vec3i)PathingConstants.BLOCKPOS_DOWN);
            }
            PathPointExtended p = new PathPointExtended(pos);
            if (railsLength >= 8) {
                PathPointExtended point;
                p.setOnRails(node.isOnRails());
                if (p.isOnRails() && (!node.parent.isOnRails() || node.parent.parent == null)) {
                    p.setRailsEntry();
                } else if (p.isOnRails() && points.length > pathLength + 1 && !(point = (PathPointExtended)points[pathLength + 1]).isOnRails()) {
                    point.setRailsExit();
                }
            }
            if (nextInPath != null && AbstractPathJob.onALadder(node, nextInPath, pos)) {
                p.setOnLadder(true);
                if (nextInPath.pos.m_123342_() > pos.m_123342_()) {
                    AbstractPathJob.setLadderFacing(this.world, pos, p);
                }
            } else if (AbstractPathJob.onALadder(node.parent, node.parent, pos)) {
                p.setOnLadder(true);
            }
            if (next != null) {
                next.f_77278_ = p;
            }
            next = p;
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        return new Path(Arrays.asList(points), this.getPathTargetPos(targetNode), this.isAtDestination(targetNode));
    }

    protected BlockPos getPathTargetPos(ModNode finalNode) {
        return finalNode.pos;
    }

    protected abstract double computeHeuristic(BlockPos var1);

    protected abstract boolean isAtDestination(ModNode var1);

    protected abstract double getNodeResultScore(ModNode var1);

    protected final boolean walk(ModNode parent, BlockPos dPos) {
        int nodeKey;
        ModNode node;
        BlockPos pos = parent.pos.m_141952_((Vec3i)dPos);
        int newY = this.getGroundHeight(parent, pos);
        if (newY < 0) {
            return false;
        }
        boolean corner = false;
        if (pos.m_123342_() != newY) {
            if (parent.isCornerNode() && (dPos.m_123341_() != 0 || dPos.m_123343_() != 0)) {
                return false;
            }
            if (!(parent.isCornerNode() || newY - parent.pos.m_123342_() <= 0 || parent.parent != null && parent.parent.pos.equals((Object)parent.pos.m_141952_((Vec3i)new BlockPos(0, newY - pos.m_123342_(), 0))))) {
                dPos = new BlockPos(0, newY - pos.m_123342_(), 0);
                pos = parent.pos.m_141952_((Vec3i)dPos);
                corner = true;
            } else if (!(parent.isCornerNode() || newY - parent.pos.m_123342_() >= 0 || dPos.m_123341_() == 0 && dPos.m_123343_() == 0 || parent.parent != null && parent.pos.m_7495_().equals((Object)parent.parent.pos))) {
                dPos = new BlockPos(dPos.m_123341_(), 0, dPos.m_123343_());
                pos = parent.pos.m_141952_((Vec3i)dPos);
                corner = true;
            } else {
                dPos = dPos.m_142082_(0, newY - pos.m_123342_(), 0);
                pos = new BlockPos(pos.m_123341_(), newY, pos.m_123343_());
            }
        }
        if (AbstractPathJob.nodeClosed(node = this.nodesVisited.get(nodeKey = AbstractPathJob.computeNodeKey(pos)))) {
            return false;
        }
        boolean isSwimming = AbstractPathJob.calculateSwimming(this.world, pos, node);
        if (isSwimming && !this.pathingOptions.canSwim()) {
            return false;
        }
        boolean swimStart = isSwimming && !parent.isSwimming();
        boolean onRoad = this.pathingOptions.getIsRoad().apply(this.world.m_8055_(pos.m_7495_()));
        boolean onRails = this.pathingOptions.canUseRails() && this.world.m_8055_(corner ? pos.m_7495_() : pos).m_60734_() instanceof BaseRailBlock;
        boolean railsExit = !onRails && parent != null && parent.isOnRails();
        double stepCost = this.computeCost(dPos, isSwimming, onRoad, onRails, railsExit, swimStart, corner, pos);
        double heuristic = this.computeHeuristic(pos);
        double cost = parent.getCost() + stepCost;
        double score = cost + heuristic;
        if (node == null) {
            node = this.createNode(parent, pos, nodeKey, isSwimming, heuristic, cost, score);
            node.setOnRails(onRails);
            node.setCornerNode(corner);
        } else if (this.updateCurrentNode(parent, node, heuristic, cost, score)) {
            return false;
        }
        this.nodesOpen.offer(node);
        this.performJumpPointSearch(parent, dPos, node);
        return true;
    }

    private void performJumpPointSearch(ModNode parent, BlockPos dPos, ModNode node) {
        if (this.allowJumpPointSearchTypeWalk && node.getHeuristic() <= parent.getHeuristic()) {
            this.walk(node, dPos);
        }
    }

    private ModNode createNode(ModNode parent, BlockPos pos, int nodeKey, boolean isSwimming, double heuristic, double cost, double score) {
        ModNode node = new ModNode(parent, pos, cost, heuristic, score);
        this.nodesVisited.put(nodeKey, node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        if (this.isLadder(pos)) {
            node.setLadder();
        } else if (isSwimming) {
            node.setSwimming();
        }
        ++this.totalNodesAdded;
        node.setCounterAdded(this.totalNodesAdded);
        return node;
    }

    private boolean updateCurrentNode(ModNode parent, ModNode node, double heuristic, double cost, double score) {
        if (score >= node.getScore()) {
            return true;
        }
        if (!this.nodesOpen.remove(node)) {
            return true;
        }
        node.parent = parent;
        node.setSteps(parent.getSteps() + 1);
        node.setCost(cost);
        node.setHeuristic(heuristic);
        node.setScore(score);
        return false;
    }

    protected int getGroundHeight(ModNode parent, BlockPos pos) {
        if (this.checkHeadBlock(parent, pos)) {
            return this.handleTargetNotPassable(parent, pos.m_7494_(), this.world.m_8055_(pos.m_7494_()));
        }
        BlockState target = this.world.m_8055_(pos);
        if (!this.isPassable(target, pos, parent)) {
            return this.handleTargetNotPassable(parent, pos, target);
        }
        BlockState below = this.world.m_8055_(pos.m_7495_());
        SurfaceType walkability = this.isWalkableSurface(below, pos);
        if (walkability == SurfaceType.WALKABLE) {
            return pos.m_123342_();
        }
        if (walkability == SurfaceType.NOT_PASSABLE) {
            return -1;
        }
        return this.handleNotStanding(parent, pos, below);
    }

    private int handleNotStanding(ModNode parent, BlockPos pos, BlockState below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming();
        if (this.isLiquid(below)) {
            return this.handleInLiquid(pos, below, isSwimming);
        }
        if (this.isLadder(below.m_60734_(), pos.m_7495_())) {
            return pos.m_123342_();
        }
        return this.checkDrop(parent, pos, isSwimming);
    }

    private int checkDrop(ModNode parent, BlockPos pos, boolean isSwimming) {
        boolean canDrop;
        boolean bl = canDrop = parent != null && !parent.isLadder();
        if (!canDrop || isSwimming || (parent.pos.m_123341_() != pos.m_123341_() || parent.pos.m_123343_() != pos.m_123343_()) && this.isPassable(parent.pos.m_7495_(), false, parent) && this.isWalkableSurface(this.world.m_8055_(parent.pos.m_7495_()), parent.pos.m_7495_()) == SurfaceType.DROPABLE) {
            return -1;
        }
        for (int i = 2; i <= 10; ++i) {
            BlockState below = this.world.m_8055_(pos.m_6625_(i));
            if (this.isWalkableSurface(below, pos) == SurfaceType.WALKABLE && i <= 3 || this.isLiquid(below)) {
                return pos.m_123342_() - i + 1;
            }
            if (below.m_60767_() == Material.f_76296_) continue;
            return -1;
        }
        return -1;
    }

    private int handleInLiquid(BlockPos pos, BlockState below, boolean isSwimming) {
        if (isSwimming) {
            return pos.m_123342_();
        }
        if (this.pathingOptions.canSwim() && below.m_60767_() == Material.f_76305_) {
            return pos.m_123342_();
        }
        return -1;
    }

    private int handleTargetNotPassable(ModNode parent, BlockPos pos, BlockState target) {
        VoxelShape bb2;
        VoxelShape bb1;
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder() && !parent.isSwimming();
        if (!canJump || this.isWalkableSurface(target, pos) != SurfaceType.WALKABLE) {
            return -1;
        }
        if (!this.isPassable(pos.m_6630_(2), false, parent)) {
            bb1 = this.world.m_8055_(pos).m_60812_((BlockGetter)this.world, pos);
            bb2 = this.world.m_8055_(pos.m_6630_(2)).m_60812_((BlockGetter)this.world, pos.m_6630_(2));
            if ((double)pos.m_6630_(2).m_123342_() + this.getStartY(bb2, 1) - ((double)pos.m_123342_() + this.getEndY(bb1, 0)) < 2.0) {
                return -1;
            }
        }
        if (!this.isPassable(parent.pos.m_6630_(2), false, parent)) {
            bb1 = this.world.m_8055_(pos).m_60812_((BlockGetter)this.world, pos);
            bb2 = this.world.m_8055_(parent.pos.m_6630_(2)).m_60812_((BlockGetter)this.world, parent.pos.m_6630_(2));
            if ((double)parent.pos.m_6630_(2).m_123342_() + this.getStartY(bb2, 1) - ((double)pos.m_123342_() + this.getEndY(bb1, 0)) < 2.0) {
                return -1;
            }
        }
        BlockState parentBelow = this.world.m_8055_(parent.pos.m_7495_());
        VoxelShape parentBB = parentBelow.m_60812_((BlockGetter)this.world, parent.pos.m_7495_());
        double parentY = parentBB.m_83297_(Direction.Axis.Y);
        double parentMaxY = parentY + (double)parent.pos.m_7495_().m_123342_();
        double targetMaxY = target.m_60812_((BlockGetter)this.world, pos).m_83297_(Direction.Axis.Y) + (double)pos.m_123342_();
        if (targetMaxY - parentMaxY < 1.3) {
            return pos.m_123342_() + 1;
        }
        if (target.m_60734_() instanceof StairBlock && parentY - 0.5 < 1.3 && target.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM && AbstractPathJob.getXZFacing(parent.pos, pos) == target.m_61143_((Property)StairBlock.f_56841_)) {
            return pos.m_123342_() + 1;
        }
        return -1;
    }

    public static Direction getXZFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.m_141950_((Vec3i)pos);
        return Direction.m_122372_((float)vector.m_123341_(), (float)0.0f, (float)vector.m_123343_());
    }

    private boolean checkHeadBlock(ModNode parent, BlockPos pos) {
        boolean isSmall;
        BlockPos localPos = pos;
        VoxelShape bb = this.world.m_8055_(localPos).m_60812_((BlockGetter)this.world, localPos);
        if (bb.m_83297_(Direction.Axis.Y) < 1.0) {
            localPos = pos.m_7494_();
        }
        if ((isSmall = this.pathingOptions.canFitInOneCube()) ? !this.isPassable(pos, true, parent) : !this.isPassable(pos.m_7494_(), true, parent)) {
            VoxelShape bb1 = this.world.m_8055_(pos.m_7495_()).m_60812_((BlockGetter)this.world, pos.m_7495_());
            VoxelShape bb2 = this.world.m_8055_(pos.m_7494_()).m_60812_((BlockGetter)this.world, pos.m_7494_());
            if ((double)pos.m_7494_().m_123342_() + this.getStartY(bb2, 1) - ((double)pos.m_7495_().m_123342_() + this.getEndY(bb1, 0)) < 2.0) {
                return true;
            }
            if (parent != null) {
                VoxelShape bb3 = this.world.m_8055_(parent.pos.m_7495_()).m_60812_((BlockGetter)this.world, pos.m_7495_());
                if ((double)pos.m_7494_().m_123342_() + this.getStartY(bb2, 1) - ((double)parent.pos.m_7495_().m_123342_() + this.getEndY(bb3, 0)) < 1.75) {
                    return true;
                }
            }
        }
        if (parent != null) {
            BlockState hereState = this.world.m_8055_(localPos.m_7495_());
            VoxelShape bb1 = this.world.m_8055_(pos).m_60812_((BlockGetter)this.world, pos);
            VoxelShape bb2 = this.world.m_8055_(localPos.m_7494_()).m_60812_((BlockGetter)this.world, localPos.m_7494_());
            if ((double)localPos.m_7494_().m_123342_() + this.getStartY(bb2, 1) - ((double)pos.m_123342_() + this.getEndY(bb1, 0)) >= 2.0) {
                return false;
            }
            return this.isLiquid(hereState) && !this.isPassable(pos, false, parent);
        }
        return false;
    }

    private double getStartY(VoxelShape bb, int def) {
        return bb.m_83281_() ? (double)def : bb.m_83288_(Direction.Axis.Y);
    }

    private double getEndY(VoxelShape bb, int def) {
        return bb.m_83281_() ? (double)def : bb.m_83297_(Direction.Axis.Y);
    }

    protected boolean isPassable(BlockState block, BlockPos pos, ModNode parent) {
        if (block.m_60767_() != Material.f_76296_) {
            if (block.m_60767_().m_76334_() && !this.canPassShape(block.m_60812_((BlockGetter)this.world, pos))) {
                if (block.m_60734_() instanceof TrapDoorBlock) {
                    BlockPos parentPos = parent == null ? this.start : parent.pos;
                    BlockPos dir = pos.m_141950_((Vec3i)parentPos);
                    if (dir.m_123342_() != 0 && dir.m_123341_() == 0 && dir.m_123343_() == 0) {
                        return true;
                    }
                    Direction facing = (Direction)block.m_61143_((Property)TrapDoorBlock.f_54117_);
                    if (dir.m_123341_() != 0) {
                        return facing == Direction.NORTH || facing == Direction.SOUTH;
                    }
                    return facing == Direction.EAST || facing == Direction.WEST;
                }
                return this.pathingOptions.canEnterDoors() && (block.m_60734_() instanceof DoorBlock || block.m_60734_() instanceof FenceGateBlock) || block.m_60734_() instanceof PressurePlateBlock || block.m_60734_() instanceof SignBlock || block.m_60734_() instanceof AbstractBannerBlock;
            }
            if (block.m_60734_() instanceof FireBlock) {
                return false;
            }
            VoxelShape shape = block.m_60812_((BlockGetter)this.world, pos);
            return this.isLadder(block.m_60734_(), pos) || (shape.m_83281_() || shape.m_83297_(Direction.Axis.Y) <= 0.1) && !this.isLiquid(block) && (block.m_60734_() != Blocks.f_50125_ || (Integer)block.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) && block.m_60734_() != Blocks.f_50685_;
        }
        return true;
    }

    public boolean canPassShape(VoxelShape shape) {
        return shape.m_83281_() || shape.m_83297_(Direction.Axis.Y) <= 0.1;
    }

    protected boolean isPassable(BlockPos pos, boolean head, ModNode parent) {
        BlockState state = this.world.m_8055_(pos);
        VoxelShape shape = state.m_60812_((BlockGetter)this.world, pos);
        if (shape.m_83281_() || shape.m_83297_(Direction.Axis.Y) <= 0.1) {
            return !head || !(state.m_60734_() instanceof WoolCarpetBlock) || this.isLadder(state.m_60734_(), pos);
        }
        return this.isPassable(state, pos, parent);
    }

    protected SurfaceType isWalkableSurface(BlockState blockState, BlockPos pos) {
        Block block = blockState.m_60734_();
        if (block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof FireBlock || block instanceof CampfireBlock || block instanceof BambooBlock || block instanceof DoorBlock || block instanceof MagmaBlock || blockState.m_60808_((BlockGetter)this.world, pos).m_83297_(Direction.Axis.Y) > 1.0) {
            return SurfaceType.NOT_PASSABLE;
        }
        FluidState fluid = this.world.m_6425_(pos);
        if (blockState.m_60734_() == Blocks.f_49991_ || fluid != null && !fluid.m_76178_() && (fluid.m_76152_() == Fluids.f_76195_ || fluid.m_76152_() == Fluids.f_76194_)) {
            return SurfaceType.NOT_PASSABLE;
        }
        if (AbstractPathJob.isWater(this.world, pos, blockState, fluid)) {
            return SurfaceType.WALKABLE;
        }
        if (block instanceof SignBlock) {
            return SurfaceType.DROPABLE;
        }
        if (blockState.m_60767_().m_76333_() || blockState.m_60734_() == Blocks.f_50125_ && (Integer)blockState.m_61143_((Property)SnowLayerBlock.f_56581_) > 1 || block instanceof WoolCarpetBlock) {
            return SurfaceType.WALKABLE;
        }
        return SurfaceType.DROPABLE;
    }

    protected boolean isLadder(Block block, BlockPos pos) {
        return block.isLadder(this.world.m_8055_(pos), this.world, pos, (LivingEntity)this.entity.get());
    }

    protected boolean isLadder(BlockPos pos) {
        return this.isLadder(this.world.m_8055_(pos).m_60734_(), pos);
    }

    public void setPathingOptions(PathingOptions pathingOptions) {
        this.pathingOptions = pathingOptions;
    }

    public boolean isInRestrictedArea(BlockPos pos) {
        if (!this.xzRestricted) {
            return true;
        }
        return pos.m_123341_() <= this.maxX && pos.m_123343_() <= this.maxZ && pos.m_123343_() >= this.minZ && pos.m_123341_() >= this.minX;
    }

    protected static enum SurfaceType {
        WALKABLE,
        DROPABLE,
        NOT_PASSABLE;

    }
}

