/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class InteractTrapdoorGoal
extends Goal {
    protected Mob mob;
    protected BlockPos doorPos = BlockPos.f_121853_;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;

    public InteractTrapdoorGoal(Mob p_i1621_1_) {
        this.mob = p_i1621_1_;
        if (!GoalUtils.m_26894_((Mob)p_i1621_1_)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        BlockState blockstate = this.mob.f_19853_.m_8055_(this.doorPos);
        if (!(blockstate.m_60734_() instanceof TrapDoorBlock)) {
            this.hasDoor = false;
            return false;
        }
        return (Boolean)blockstate.m_61143_((Property)TrapDoorBlock.f_57514_);
    }

    protected void setOpen(boolean p_195921_1_) {
        BlockState blockstate;
        if (this.hasDoor && (blockstate = this.mob.f_19853_.m_8055_(this.doorPos)).m_60734_() instanceof TrapDoorBlock) {
            blockstate = (BlockState)blockstate.m_61122_((Property)TrapDoorBlock.f_57514_);
            this.mob.f_19853_.m_7731_(this.doorPos, blockstate, 2);
        }
    }

    public boolean m_8036_() {
        if (!GoalUtils.m_26894_((Mob)this.mob)) {
            return false;
        }
        if (!this.mob.f_19862_) {
            return false;
        }
        GroundPathNavigation groundpathnavigator = (GroundPathNavigation)this.mob.m_21573_();
        Path path = groundpathnavigator.m_26570_();
        if (path != null && !path.m_77392_() && groundpathnavigator.m_26492_()) {
            for (int i = 0; i < Math.min(path.m_77399_() + 2, path.m_77398_()); ++i) {
                Node pathpoint = path.m_77375_(i);
                this.doorPos = new BlockPos(pathpoint.f_77271_, pathpoint.f_77272_, pathpoint.f_77273_);
                if (this.mob.m_20275_((double)this.doorPos.m_123341_(), this.mob.m_20186_(), (double)this.doorPos.m_123343_()) > 2.25) continue;
                this.hasDoor = this.isWoodenTrapdoor();
                if (!this.hasDoor) continue;
                return true;
            }
            this.doorPos = this.mob.m_142538_().m_7494_();
            this.hasDoor = this.isWoodenTrapdoor();
            return this.hasDoor;
        }
        return false;
    }

    public boolean isWoodenTrapdoor() {
        return this.mob.f_19853_.m_8055_(this.doorPos).m_60734_() instanceof TrapDoorBlock && this.mob.f_19853_.m_8055_(this.doorPos).m_60767_() == Material.f_76320_;
    }

    public boolean m_8045_() {
        return !this.passed;
    }

    public void m_8056_() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.doorPos.m_123341_() + 0.5 - this.mob.m_20185_());
        this.doorOpenDirZ = (float)((double)this.doorPos.m_123343_() + 0.5 - this.mob.m_20189_());
    }

    public void m_8037_() {
        float f1;
        float f = (float)((double)this.doorPos.m_123341_() + 0.5 - this.mob.m_20185_());
        float f2 = this.doorOpenDirX * f + this.doorOpenDirZ * (f1 = (float)((double)this.doorPos.m_123343_() + 0.5 - this.mob.m_20189_()));
        if (f2 < 0.0f) {
            this.passed = true;
        }
    }
}

