/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.common.block.SpellPrismBlock;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class EntityProjectileSpell
extends ColoredProjectile {
    public int age;
    public SpellResolver spellResolver;
    public int pierceLeft;
    public int numSensitive;
    public Set<BlockPos> hitList = new HashSet<BlockPos>();

    public EntityProjectileSpell(EntityType<? extends EntityProjectileSpell> entityType, Level world) {
        super(entityType, world);
    }

    public EntityProjectileSpell(Level world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityProjectileSpell(Level world, SpellResolver resolver) {
        super(world, resolver.spellContext.caster);
        this.spellResolver = resolver;
        this.pierceLeft = resolver.spell.getBuffsAtIndex(0, resolver.spellContext.caster, AugmentPierce.INSTANCE);
        this.numSensitive = resolver.spell.getBuffsAtIndex(0, resolver.spellContext.caster, AugmentSensitive.INSTANCE);
        resolver.spellContext.colors.makeVisible();
        this.setColor(resolver.spellContext.colors);
    }

    public EntityProjectileSpell(Level world, LivingEntity shooter) {
        super(world, shooter);
    }

    public void m_8119_() {
        EntityHitResult entityraytraceresult;
        Vec3 vector3d3;
        Vec3 vector3d2;
        BlockHitResult raytraceresult;
        ++this.age;
        Vec3 vector3d = this.m_20184_();
        if (this.age > 1200) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        if (this.f_36703_) {
            this.f_36703_ = false;
            this.m_20256_(this.m_20184_());
        }
        if ((raytraceresult = this.f_19853_.m_45547_(new ClipContext(vector3d2 = this.m_20182_(), vector3d3 = vector3d2.m_82549_(vector3d), this.numSensitive > 0 ? ClipContext.Block.OUTLINE : ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))) != null && raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vector3d3 = raytraceresult.m_82450_();
        }
        if ((entityraytraceresult = this.m_6351_(vector3d2, vector3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult instanceof EntityHitResult) {
            Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
            Entity entity1 = this.m_37282_();
            if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
            this.m_6532_((HitResult)raytraceresult);
            this.f_19812_ = true;
        }
        if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.MISS && raytraceresult instanceof BlockHitResult) {
            BlockRegistry.PORTAL_BLOCK.m_5581_(this.f_19853_, this.f_19853_.m_8055_(new BlockPos(raytraceresult.m_82450_())), raytraceresult, (Projectile)this);
        }
        Vec3 vec3d = this.m_20184_();
        double x = this.m_20185_() + vec3d.f_82479_;
        double y = this.m_20186_() + vec3d.f_82480_;
        double z = this.m_20189_() + vec3d.f_82481_;
        if (!this.m_20068_()) {
            Vec3 vec3d1 = this.m_20184_();
            this.m_20334_(vec3d1.f_82479_, vec3d1.f_82480_, vec3d1.f_82481_);
        }
        this.m_6034_(x, y, z);
        if (this.f_19853_.f_46443_ && this.age > 2) {
            for (int i = 0; i < 3; ++i) {
                double deltaX = this.m_20185_() - this.f_19790_;
                double deltaY = this.m_20186_() - this.f_19791_;
                double deltaZ = this.m_20189_() - this.f_19792_;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 8.0);
                for (double j = 0.0; j < dist; j += 1.0) {
                    double coeff = j / dist;
                    this.f_19853_.m_7106_(GlowParticleData.createData(this.getParticleColor()), (double)((float)(this.f_19854_ + deltaX * coeff)), (double)((float)(this.f_19855_ + deltaY * coeff)), (double)((float)(this.f_19856_ + deltaZ * coeff)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)));
                }
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, inaccuracy);
        Vec3 vec3d = entityThrower.m_20154_();
        this.m_20256_(this.m_20184_().m_82520_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_));
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec3d = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vec3d);
        float f = Mth.m_14116_((float)((float)vec3d.m_165925_()));
        this.f_19857_ = (float)(Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_) * 57.2957763671875);
        this.f_19858_ = (float)(Mth.m_14136_((double)vec3d.f_82480_, (double)f) * 57.2957763671875);
        this.f_19859_ = this.f_19857_;
        this.f_19860_ = this.f_19858_;
    }

    public boolean m_20068_() {
        return true;
    }

    public EntityType<?> m_6095_() {
        return ModEntities.SPELL_PROJ;
    }

    protected void attemptRemoval() {
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_ && result != null && result.m_6662_() == HitResult.Type.ENTITY) {
            if (((EntityHitResult)result).m_82443_().equals((Object)this.m_37282_())) {
                return;
            }
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.f_19853_, (LivingEntity)this.m_37282_(), result);
                Networking.sendToNearby(this.f_19853_, new BlockPos(result.m_82450_()), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.m_82450_()), this.getParticleColorWrapper(), new int[0]));
                this.attemptRemoval();
            }
        }
        if (!this.f_19853_.f_46443_ && result instanceof BlockHitResult && !this.m_146910_() && !this.hitList.contains(((BlockHitResult)result).m_82425_())) {
            BlockHitResult blockraytraceresult = (BlockHitResult)result;
            BlockState state = this.f_19853_.m_8055_(((BlockHitResult)result).m_82425_());
            if (state.m_60734_() instanceof SpellPrismBlock) {
                SpellPrismBlock.redirectSpell((ServerLevel)this.f_19853_, blockraytraceresult.m_82425_(), this);
                return;
            }
            if (state.m_60767_() == Material.f_76298_) {
                state.m_60734_().m_7892_(state, this.f_19853_, ((BlockHitResult)result).m_82425_(), (Entity)this);
                return;
            }
            if (this.spellResolver != null) {
                this.hitList.add(blockraytraceresult.m_82425_());
                this.spellResolver.onResolveEffect(this.f_19853_, (LivingEntity)this.m_37282_(), (HitResult)blockraytraceresult);
            }
            Networking.sendToNearby(this.f_19853_, ((BlockHitResult)result).m_82425_(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.m_82450_()).m_7495_(), this.getParticleColorWrapper(), new int[0]));
            this.attemptRemoval();
        }
    }

    public EntityProjectileSpell(PlayMessages.SpawnEntity packet, Level world) {
        super(ModEntities.SPELL_PROJ, world);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("pierce")) {
            this.pierceLeft = tag.m_128451_("pierce");
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("pierce", this.pierceLeft);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }
}

