/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraAttackGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraDiveGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraRageGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraRamGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraSpikeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraSummonGoal;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.potions.SnareEffect;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityChimera
extends Monster
implements IAnimatable,
IAnimationListener {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7006_(true).m_7005_(true);
    public static final EntityDataAccessor<Boolean> HAS_SPIKES = SynchedEntityData.m_135353_(EntityChimera.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HAS_HORNS = SynchedEntityData.m_135353_(EntityChimera.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HAS_WINGS = SynchedEntityData.m_135353_(EntityChimera.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(EntityChimera.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DEFENSIVE_MODE = SynchedEntityData.m_135353_(EntityChimera.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> PHASE_SWAPPING = SynchedEntityData.m_135353_(EntityChimera.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.m_135353_(EntityChimera.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean isRamming;
    public int summonCooldown;
    public int diveCooldown;
    public int spikeCooldown;
    public int ramCooldown;
    public int rageTimer;
    public boolean diving;
    public FlyingPathNavigation flyingNavigator;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public Vec3 orbitOffset = Vec3.f_82478_;

    public EntityChimera(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21342_ = new ChimeraMoveController(this, 10, true);
        this.f_19793_ = 2.0f;
        this.m_21530_();
        this.initFlyingNavigator();
        this.rageTimer = 300;
        this.f_21364_ = 75;
    }

    public EntityChimera(Level level) {
        this(ModEntities.WILDEN_BOSS, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new ChimeraAttackGoal(this, true));
        this.f_21345_.m_25352_(3, (Goal)new ChimeraSummonGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(1, (Goal)new ChimeraRageGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ChimeraRamGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ChimeraDiveGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ChimeraSpikeGoal(this));
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "walkController", 20.0f, this::groundPredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 1.0f, this::attackPredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "crouchController", 1.0f, this::crouchPredicate));
    }

    private <E extends Entity> PlayState attackPredicate(AnimationEvent event) {
        return PlayState.CONTINUE;
    }

    private <E extends Entity> PlayState crouchPredicate(AnimationEvent event) {
        if (this.isDefensive()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("crouch"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends Entity> PlayState groundPredicate(AnimationEvent e) {
        if (!this.isDefensive() && e.isMoving() && !this.isFlying()) {
            e.getController().setAnimation(new AnimationBuilder().addAnimation("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void m_8119_() {
        Path path;
        super.m_8119_();
        if (this.isDefensive()) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (this.f_19853_.f_46443_ && this.isFlying() && this.f_19796_.nextInt(18) == 0) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11734_, this.m_5720_(), 0.95f + this.f_19796_.nextFloat() * 0.05f, 0.3f + this.f_19796_.nextFloat() * 0.05f, false);
        }
        if (!(this.f_19853_.f_46443_ || this.m_5448_() == null || this.f_19802_ != 0 || this.isDefensive() || this.isFlying() || !this.f_19861_ || (path = this.m_21573_().m_6570_((Entity)this.m_5448_(), 1)) != null && path.m_77403_() && !(this.m_5448_().m_20186_() - (this.m_20186_() + 2.0) >= 3.0))) {
            --this.rageTimer;
        }
        if (!this.isFlying()) {
            this.m_20242_(this.m_20077_());
        }
        if (!this.f_19853_.f_46443_ && this.m_20077_() && this.f_19853_.m_46467_() % 10L == 0L) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, 4));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, 3));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 20));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20, 3));
        }
        if (this.isFlying()) {
            this.f_21344_.m_26573_();
            this.flyingNavigator.m_7638_();
        }
        if (!this.f_19853_.f_46443_) {
            if (this.isFlying() && this.f_21345_.m_25386_().noneMatch(g -> g.m_26015_() instanceof ChimeraDiveGoal)) {
                this.setFlying(false);
            }
            if (this.isDefensive() && this.f_21345_.m_25386_().noneMatch(g -> g.m_26015_() instanceof ChimeraSpikeGoal)) {
                this.setDefensiveMode(false);
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (this.summonCooldown > 0) {
                --this.summonCooldown;
            }
            if (this.diveCooldown > 0) {
                --this.diveCooldown;
                if (this.m_20077_() || this.m_20069_()) {
                    this.spikeCooldown -= 2;
                }
            }
            if (this.spikeCooldown > 0) {
                --this.spikeCooldown;
            }
            if (this.ramCooldown > 0) {
                --this.ramCooldown;
            }
        }
        if (!this.f_19853_.f_46443_ && this.getPhaseSwapping() && !this.f_20890_) {
            if (this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
            } else {
                this.m_21219_();
                this.setPhaseSwapping(false);
                for (LivingEntity e : this.f_19853_.m_45976_(Player.class, new AABB(this.m_142538_()).m_82400_(5.0))) {
                    EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(new Spell.Builder().add(MethodTouch.INSTANCE).add(EffectLaunch.INSTANCE).add(AugmentAmplify.INSTANCE, 2).add(EffectDelay.INSTANCE).add(EffectKnockback.INSTANCE).add(AugmentAmplify.INSTANCE, 2).build(), (LivingEntity)this));
                    resolver.onCastOnEntity(ItemStack.f_41583_, (LivingEntity)this, (Entity)e, InteractionHand.MAIN_HAND);
                }
                this.getRandomUpgrade();
                this.gainPhaseBuffs();
                ParticleUtil.spawnPoof((ServerLevel)this.f_19853_, this.m_142538_().m_7494_());
                if (this.getPhase() == 1) {
                    this.rageTimer = 200;
                }
            }
        }
        if (this.getPhaseSwapping() && this.f_19853_.f_46443_) {
            EntityChimera.spawnPhaseParticles(this.m_142538_(), this.f_19853_, this.getPhase());
        }
    }

    public static void spawnPhaseParticles(BlockPos pos, Level level, int multiplier) {
        if (!level.f_46443_) {
            return;
        }
        int baseAge = 40;
        float scaleAge = (float)ParticleUtil.inRange(0.1, 0.2);
        for (int i = 0; i < 10 * Math.min(1, multiplier); ++i) {
            Vec3 particlePos = new Vec3((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_()).m_82520_(0.5, 0.5, 0.5);
            particlePos = particlePos.m_82549_(ParticleUtil.pointInSphere().m_82542_(3.0, 3.0, 3.0));
            level.m_7106_(ParticleLineData.createData(ParticleColor.makeRandomColor(255, 255, 255, level.f_46441_), scaleAge, baseAge + level.f_46441_.nextInt(20)), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        }
    }

    protected void m_7472_(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.m_7472_(p_213333_1_, p_213333_2_, p_213333_3_);
        ItemEntity itementity = this.m_19998_((ItemLike)ItemsRegistry.WILDEN_TRIBUTE);
        if (itementity != null) {
            itementity.m_32064_();
        }
    }

    protected boolean m_6125_() {
        return true;
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f + this.f_19796_.nextFloat() * 0.3f, 0.8f + this.f_19796_.nextFloat() * 0.1f);
    }

    public boolean m_20067_() {
        return false;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12283_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12282_;
    }

    public void gainPhaseBuffs() {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100 + 100 * this.getPhase(), 3));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300 + 300 * this.getPhase(), this.getPhase()));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300 + 300 * this.getPhase(), this.getPhase()));
    }

    public void resetCooldowns() {
        this.spikeCooldown = 0;
        this.ramCooldown = 0;
        this.diveCooldown = 0;
        this.summonCooldown = 0;
    }

    public void m_5634_(float p_70691_1_) {
        this.m_21153_(this.m_21223_() + p_70691_1_);
    }

    public boolean canDive() {
        return !this.isRamming && this.diveCooldown <= 0 && this.hasWings() && !this.getPhaseSwapping() && !this.isFlying() && this.f_19861_ && !this.isDefensive();
    }

    public boolean canSpike() {
        return !this.isRamming && this.spikeCooldown <= 0 && this.hasSpikes() && !this.getPhaseSwapping() && !this.isFlying() && this.f_19861_ && this.m_5448_() != null;
    }

    public boolean canRam() {
        return !this.isRamming && this.ramCooldown <= 0 && this.hasHorns() && !this.getPhaseSwapping() && !this.isFlying() && !this.isDefensive() && this.m_5448_() != null && this.m_5448_().m_20096_() && this.m_20096_();
    }

    public boolean canSummon() {
        return !this.isRamming && this.m_5448_() != null && this.summonCooldown <= 0 && !this.isFlying() && !this.getPhaseSwapping() && !this.isDefensive() && this.f_19861_;
    }

    public boolean canAttack() {
        return !this.isRamming && this.m_5448_() != null && this.m_21223_() >= 1.0f && !this.getPhaseSwapping() && !this.isFlying() && !this.isDefensive();
    }

    public boolean canRage() {
        return !this.getPhaseSwapping() && !this.isRamming;
    }

    public boolean m_21224_() {
        return this.getPhase() > 3;
    }

    public void getRandomUpgrade() {
        ArrayList<Integer> upgrades = new ArrayList<Integer>();
        if (!this.hasWings()) {
            upgrades.add(0);
        }
        if (!this.hasSpikes()) {
            upgrades.add(1);
        }
        if (!this.hasHorns()) {
            upgrades.add(2);
        }
        if (upgrades.isEmpty()) {
            return;
        }
        int upgrade = (Integer)upgrades.get(this.f_19796_.nextInt(upgrades.size()));
        switch (upgrade) {
            case 0: {
                this.setWings(true);
                return;
            }
            case 1: {
                this.setSpikes(true);
                return;
            }
            case 2: {
                this.setHorns(true);
                return;
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19314_ || source == DamageSource.f_19325_ || source == DamageSource.f_19310_ || source == DamageSource.f_19308_ || source == DamageSource.f_19312_) {
            return false;
        }
        if (source.f_19326_.equals("cold")) {
            amount /= 2.0f;
        }
        if (this.getPhaseSwapping()) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity && !entity.equals((Object)this)) {
            LivingEntity entity1;
            if (this.isDefensive() && !source.f_19326_.equals("thorns") && !source.m_19376_() && BlockUtil.distanceFrom(entity.f_19825_, this.f_19825_) <= 3.0) {
                entity.m_6469_(DamageSource.m_19335_((Entity)this), 6.0f);
            }
            if ((entity1 = (LivingEntity)entity) instanceof WildenStalker || entity1 instanceof WildenGuardian || entity instanceof WildenHunter || entity instanceof ISummon && ((ISummon)entity).getOwnerID() != null && ((ISummon)entity).getOwnerID().equals(this.m_142081_()) || entity1 instanceof SummonWolf && ((SummonWolf)entity1).isWildenSummon) {
                return false;
            }
        }
        if (this.isDefensive()) {
            return false;
        }
        boolean res = super.m_6469_(source, amount);
        if (!this.f_19853_.f_46443_ && (double)this.m_21223_() <= 0.0 && this.getPhase() < 3) {
            this.setPhaseSwapping(true);
            this.setPhase(this.getPhase() + 1);
            this.m_21573_().m_26573_();
            this.m_21153_(1.0f);
            Networking.sendToNearby(this.f_19853_, (Entity)this, (Object)new PacketAnimEntity(this.m_142049_(), Animations.HOWL.ordinal()));
            this.setFlying(false);
            this.setDefensiveMode(false);
            this.isRamming = false;
            this.f_20890_ = false;
        }
        if (!this.f_19853_.f_46443_ && (double)this.m_21223_() <= 0.0 && this.getPhase() == 3) {
            this.setPhase(4);
            super.m_6667_(source);
        }
        return res;
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected boolean m_7341_(Entity p_184228_1_) {
        return false;
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            this.f_20891_ = 0;
        }
    }

    public void m_6457_(ServerPlayer p_184178_1_) {
        super.m_6457_(p_184178_1_);
        this.bossEvent.m_6543_(p_184178_1_);
    }

    public void m_6452_(ServerPlayer p_184203_1_) {
        super.m_6452_(p_184203_1_);
        this.bossEvent.m_6539_(p_184203_1_);
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance instance) {
        MobEffect effect = instance.m_19544_();
        if (instance.m_19544_() instanceof SnareEffect) {
            return false;
        }
        if (effect == MobEffects.f_19597_) {
            instance = new MobEffectInstance(instance.m_19544_(), 1, 0);
        }
        if (effect == ModPotions.GRAVITY_EFFECT) {
            instance = new MobEffectInstance(instance.m_19544_(), Math.min(instance.m_19557_(), 100), 0);
        }
        return super.m_7301_(instance);
    }

    public int getCooldownModifier() {
        return 300 / (this.getPhase() + 1);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_HORNS, (Object)false);
        this.f_19804_.m_135372_(HAS_SPIKES, (Object)false);
        this.f_19804_.m_135372_(HAS_WINGS, (Object)false);
        this.f_19804_.m_135372_(PHASE, (Object)1);
        this.f_19804_.m_135372_(DEFENSIVE_MODE, (Object)false);
        this.f_19804_.m_135372_(PHASE_SWAPPING, (Object)false);
        this.f_19804_.m_135372_(IS_FLYING, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(IS_FLYING, (Object)flying);
    }

    public boolean hasHorns() {
        return (Boolean)this.f_19804_.m_135370_(HAS_HORNS);
    }

    public void setHorns(boolean hasHorns) {
        this.f_19804_.m_135381_(HAS_HORNS, (Object)hasHorns);
    }

    public boolean hasSpikes() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SPIKES);
    }

    public void setSpikes(boolean hasSpikes) {
        this.f_19804_.m_135381_(HAS_SPIKES, (Object)hasSpikes);
    }

    public boolean hasWings() {
        return (Boolean)this.f_19804_.m_135370_(HAS_WINGS);
    }

    public void setWings(boolean hasWings) {
        this.f_19804_.m_135381_(HAS_WINGS, (Object)hasWings);
    }

    public boolean isDefensive() {
        return (Boolean)this.f_19804_.m_135370_(DEFENSIVE_MODE);
    }

    public void setDefensiveMode(boolean defensiveMode) {
        this.f_19804_.m_135381_(DEFENSIVE_MODE, (Object)defensiveMode);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public boolean getPhaseSwapping() {
        return (Boolean)this.f_19804_.m_135370_(PHASE_SWAPPING);
    }

    public void setPhaseSwapping(boolean swapping) {
        this.f_19804_.m_135381_(PHASE_SWAPPING, (Object)swapping);
    }

    public void m_20258_(CompoundTag tag) {
        super.m_20258_(tag);
        this.setHorns(tag.m_128471_("horns"));
        this.setSpikes(tag.m_128471_("spikes"));
        this.setWings(tag.m_128471_("wings"));
        this.setPhase(tag.m_128451_("phase"));
        this.setDefensiveMode(tag.m_128471_("defensive"));
        this.setPhaseSwapping(tag.m_128471_("swapping"));
        this.summonCooldown = tag.m_128451_("summonCooldown");
        this.diveCooldown = tag.m_128451_("diveCooldown");
        this.spikeCooldown = tag.m_128451_("spikeCooldown");
        this.ramCooldown = tag.m_128451_("ramCooldown");
        this.rageTimer = tag.m_128451_("rage");
    }

    public boolean m_20223_(CompoundTag tag) {
        tag.m_128379_("spikes", this.hasSpikes());
        tag.m_128379_("horns", this.hasHorns());
        tag.m_128379_("wings", this.hasWings());
        tag.m_128405_("phase", this.getPhase());
        tag.m_128379_("defensive", this.isDefensive());
        tag.m_128405_("summonCooldown", this.summonCooldown);
        tag.m_128405_("diveCooldown", this.diveCooldown);
        tag.m_128405_("spikeCooldown", this.spikeCooldown);
        tag.m_128405_("ramCooldown", this.ramCooldown);
        tag.m_128379_("swapping", this.getPhaseSwapping());
        tag.m_128405_("rage", this.rageTimer);
        return super.m_20223_(tag);
    }

    @Override
    public void startAnimation(int arg) {
        try {
            AnimationController controller;
            if (arg == Animations.ATTACK.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animationName.equals("claw_swipe")) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("claw_swipe", Boolean.valueOf(false)).addAnimation("idle"));
            }
            if (arg == Animations.HOWL.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animationName.equals("howl")) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("howl", Boolean.valueOf(false)).addAnimation("idle"));
            }
            if (arg == Animations.CHARGE.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("ready_charge", Boolean.valueOf(false)).addAnimation("charge", Boolean.valueOf(true)));
            }
            if (arg == Animations.FLYING.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("flying", Boolean.valueOf(true)));
            }
            if (arg == Animations.DIVE_BOMB.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("divebomb", Boolean.valueOf(true)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void m_7840_(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        super.m_7840_(p_184231_1_, p_184231_3_, p_184231_4_, p_184231_5_);
        if (this.hasWings()) {
            this.f_19789_ = 0.0f;
        }
        this.f_19789_ = Math.min(this.f_19789_, 10.0f);
    }

    public PathNavigation m_21573_() {
        return this.isFlying() ? this.flyingNavigator : super.m_21573_();
    }

    public void initFlyingNavigator() {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, this.f_19853_);
        flyingpathnavigator.m_26440_(true);
        flyingpathnavigator.m_7008_(false);
        flyingpathnavigator.m_26443_(true);
        this.flyingNavigator = flyingpathnavigator;
    }

    public static void faceBlock(BlockPos block, LivingEntity citizen) {
        double xDifference = block.m_123341_() - citizen.m_142538_().m_123341_();
        double zDifference = block.m_123343_() - citizen.m_142538_().m_123343_();
        double yDifference = (float)block.m_123342_() - ((float)citizen.m_142538_().m_123342_() + citizen.m_20192_());
        double squareDifference = Math.sqrt(xDifference * xDifference + zDifference * zDifference);
        double intendedRotationYaw = Math.atan2(zDifference, xDifference) * 180.0 / Math.PI - 90.0;
        double intendedRotationPitch = -(Math.atan2(yDifference, squareDifference) * 180.0 / Math.PI);
        citizen.f_19857_ = (float)(EntityChimera.updateRotation(citizen.f_19857_, intendedRotationYaw, 360.0) % 360.0);
        citizen.f_19858_ = (float)(EntityChimera.updateRotation(citizen.f_19858_, intendedRotationPitch, 360.0) % 360.0);
    }

    public static double updateRotation(double currentRotation, double intendedRotation, double maxIncrement) {
        double wrappedAngle = Mth.m_14175_((double)(intendedRotation - currentRotation));
        if (wrappedAngle > maxIncrement) {
            wrappedAngle = maxIncrement;
        }
        if (wrappedAngle < -maxIncrement) {
            wrappedAngle = -maxIncrement;
        }
        return currentRotation + wrappedAngle;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public static AttributeSupplier.Builder getModdedAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 225.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22280_, (double)0.4f);
    }

    public static class ChimeraMoveController
    extends MoveControl {
        private final int maxTurn;
        private final boolean hoversInPlace;

        public ChimeraMoveController(EntityChimera p_i225710_1_, int maxTurn, boolean hoversInPlace) {
            super((Mob)p_i225710_1_);
            this.maxTurn = maxTurn;
            this.hoversInPlace = hoversInPlace;
        }

        public void m_8126_() {
            EntityChimera chimera = (EntityChimera)this.f_24974_;
            if (chimera.isFlying()) {
                if (chimera.diving) {
                    this.diveTick();
                } else {
                    this.flyTick();
                }
            } else {
                super.m_8126_();
            }
        }

        public void flyTick() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.f_24974_.m_20242_(true);
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                double d1 = this.f_24976_ - this.f_24974_.m_20186_();
                double d2 = this.f_24977_ - this.f_24974_.m_20189_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.f_24974_.m_21567_(0.0f);
                    this.f_24974_.m_21564_(0.0f);
                    return;
                }
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.f_24974_.f_19857_ = this.m_24991_(this.f_24974_.f_19857_, f, 90.0f);
                float f1 = this.f_24974_.m_20096_() ? (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) : (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
                this.f_24974_.m_7910_(f1);
                double d4 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                float f2 = (float)(-(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                this.f_24974_.f_19858_ = this.m_24991_(this.f_24974_.f_19858_, f2, this.maxTurn);
                this.f_24974_.m_21567_(d1 > 0.0 ? f1 : -f1);
            } else {
                if (!this.hoversInPlace) {
                    this.f_24974_.m_20242_(false);
                }
                this.f_24974_.m_21567_(0.0f);
                this.f_24974_.m_21564_(0.0f);
            }
        }

        public void diveTick() {
            EntityChimera mob = (EntityChimera)this.f_24974_;
            double posX = mob.m_20185_();
            double posY = mob.m_20186_();
            double posZ = mob.m_20189_();
            double motionX = mob.m_20184_().f_82479_;
            double motionY = mob.m_20184_().f_82480_;
            double motionZ = mob.m_20184_().f_82481_;
            BlockPos dest = new BlockPos(mob.orbitOffset);
            double speedMod = 1.3;
            if (dest.m_123341_() != 0 || dest.m_123342_() != 0 || dest.m_123343_() != 0) {
                double targetX = (double)dest.m_123341_() + 0.5;
                double targetY = (double)dest.m_123342_() + 0.5;
                double targetZ = (double)dest.m_123343_() + 0.5;
                Vec3 targetVector = new Vec3(targetX - posX, targetY - posY, targetZ - posZ);
                double length = targetVector.m_82553_();
                targetVector = targetVector.m_82490_(0.3 / length);
                double weight = 0.0;
                if (length <= 3.0) {
                    weight = 0.9 * ((3.0 - length) / 3.0);
                }
                motionX = (0.9 - weight) * motionX + (speedMod + weight) * targetVector.f_82479_;
                motionY = (0.9 - weight) * motionY + (speedMod + weight) * targetVector.f_82480_;
                motionZ = (0.9 - weight) * motionZ + (speedMod + weight) * targetVector.f_82481_;
            }
            mob.m_20334_(motionX, motionY, motionZ);
            EntityChimera.faceBlock(new BlockPos(mob.orbitOffset), (LivingEntity)mob);
        }
    }

    public static enum Animations {
        ATTACK,
        HOWL,
        CHARGE,
        FLYING,
        DIVE_BOMB;

    }
}

