/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ApparatusPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.CraftingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EnchantingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EntityPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphPressPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ImbuementPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.LinkPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.MultiblockPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.RelationsPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PatchouliProvider
implements DataProvider {
    private final DataGenerator generator;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public static ResourceLocation AUTOMATION = new ResourceLocation("ars_nouveau", "automation");
    public static ResourceLocation ENCHANTMENTS = new ResourceLocation("ars_nouveau", "enchantments");
    public static ResourceLocation EQUIPMENT = new ResourceLocation("ars_nouveau", "equipment");
    public static ResourceLocation FAMILIARS = new ResourceLocation("ars_nouveau", "familiars");
    public static ResourceLocation GETTING_STARTED = new ResourceLocation("ars_nouveau", "getting_started");
    public static ResourceLocation MOD_NEWS = new ResourceLocation("ars_nouveau", "mod_news");
    public static ResourceLocation MACHINES = new ResourceLocation("ars_nouveau", "machines");
    public static ResourceLocation RESOURCES = new ResourceLocation("ars_nouveau", "resources");
    public static ResourceLocation RITUALS = new ResourceLocation("ars_nouveau", "rituals");
    public static ResourceLocation SOURCE = new ResourceLocation("ars_nouveau", "source");
    public static ResourceLocation GLYPHS_1 = new ResourceLocation("ars_nouveau", "glyphs_1");
    public static ResourceLocation GLYPHS_2 = new ResourceLocation("ars_nouveau", "glyphs_2");
    public static ResourceLocation GLYPHS_3 = new ResourceLocation("ars_nouveau", "glyphs_3");
    public List<PatchouliPage> pages = new ArrayList<PatchouliPage>();
    List<Enchantment> enchants = Arrays.asList(new Enchantment[]{Enchantments.f_44971_, Enchantments.f_44979_, Enchantments.f_44968_, Enchantments.f_44973_, Enchantments.f_44984_, Enchantments.f_44967_, Enchantments.f_44981_, Enchantments.f_44966_, Enchantments.f_44990_, Enchantments.f_44987_, Enchantments.f_44952_, Enchantments.f_44980_, Enchantments.f_44982_, Enchantments.f_44959_, Enchantments.f_44961_, Enchantments.f_44988_, Enchantments.f_44969_, Enchantments.f_44965_, Enchantments.f_44989_, Enchantments.f_44960_, Enchantments.f_44970_, Enchantments.f_44977_, Enchantments.f_44985_, Enchantments.f_44978_, Enchantments.f_44983_, Enchantments.f_44972_, Enchantments.f_44986_, EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, EnchantmentRegistry.MANA_REGEN_ENCHANTMENT});

    public PatchouliProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void addEntries() {
        for (Enchantment enchantment : this.enchants) {
            this.addEnchantmentPage(enchantment);
        }
        for (AbstractRitual abstractRitual : ArsNouveauAPI.getInstance().getRitualMap().values()) {
            this.addRitualPage(abstractRitual);
        }
        for (AbstractFamiliarHolder abstractFamiliarHolder : ArsNouveauAPI.getInstance().getFamiliarHolderMap().values()) {
            this.addFamiliarPage(abstractFamiliarHolder);
        }
        for (AbstractSpellPart abstractSpellPart : ArsNouveauAPI.getInstance().getSpellpartMap().values()) {
            this.addGlyphPage(abstractSpellPart);
        }
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "spell_casting").withIcon((ItemLike)ItemsRegistry.NOVICE_SPELLBOOK).withSortNum(1).withLocalizedText().withLocalizedText().withLocalizedText().withPage(new CraftingPage((ItemLike)ItemsRegistry.NOVICE_SPELLBOOK)), this.getPath(GETTING_STARTED, "spell_casting"));
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "spell_mana").withSortNum(2).withIcon((ItemLike)ItemsRegistry.NOVICE_SPELLBOOK).withLocalizedText().withLocalizedText(), this.getPath(GETTING_STARTED, "spell_mana"));
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "obtaining_gems").withIcon((ItemLike)BlockRegistry.IMBUEMENT_BLOCK).withSortNum(3).withLocalizedText().withPage(new RelationsPage().withEntry(GETTING_STARTED, "source").withEntry(EQUIPMENT, "dowsing_rod")), this.getPath(GETTING_STARTED, "obtaining_gems"));
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "new_glyphs").withIcon((ItemLike)ItemsRegistry.BLANK_GLYPH).withSortNum(4).withLocalizedText().withPage(new RelationsPage().withEntry(MACHINES, "glyph_press").withEntry(GETTING_STARTED, "source")), this.getPath(GETTING_STARTED, "new_glyphs"));
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "source").withSortNum(5).withIcon((ItemLike)BlockRegistry.SOURCE_JAR).withLocalizedText().withPage(new RelationsPage().withEntry(SOURCE, "source_jar").withEntry(SOURCE, "agronomic_sourcelink")), this.getPath(GETTING_STARTED, "source"));
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "apparatus_crafting").withSortNum(6).withIcon((ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK).withLocalizedText().withPage(new RelationsPage().withEntry(MACHINES, "enchanting_apparatus")), this.getPath(GETTING_STARTED, "apparatus_crafting"));
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "better_casting").withSortNum(7).withIcon((ItemLike)ItemsRegistry.NOVICE_ROBES).withLocalizedText().withPage(new RelationsPage().withEntry(MACHINES, "enchanting_apparatus")), this.getPath(GETTING_STARTED, "better_casting"));
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "world_generation").withSortNum(8).withIcon((ItemLike)ItemsRegistry.SOURCE_GEM).withLocalizedText().withPage(new RelationsPage().withEntry(MACHINES, "imbuement_chamber").withEntry(RESOURCES, "archwood").withEntry(RESOURCES, "sourceberry")), this.getPath(GETTING_STARTED, "world_generation"));
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "upgrades").withSortNum(9).withIcon((ItemLike)ItemsRegistry.ARCHMAGE_SPELLBOOK).withLocalizedText().withPage(new RelationsPage().withEntry(EQUIPMENT, "spell_books").withEntry(EQUIPMENT, "armor")), this.getPath(GETTING_STARTED, "upgrades"));
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "starting_automation").withSortNum(10).withIcon((ItemLike)BlockRegistry.BASIC_SPELL_TURRET).withLocalizedText().withPage(new RelationsPage().withEntry(AUTOMATION, "spell_turret").withEntry(AUTOMATION, "spell_prism").withEntry(AUTOMATION, "bookwyrm_charm").withEntry(AUTOMATION, "starbuncle_charm").withEntry(AUTOMATION, "wixie_charm")), this.getPath(GETTING_STARTED, "starting_automation"));
        this.addPage(new PatchouliBuilder(GETTING_STARTED, "trinkets").withIcon((ItemLike)ItemsRegistry.WARP_SCROLL).withSortNum(11).withLocalizedText().withPage(new RelationsPage().withEntry(EQUIPMENT, "ring_of_greater_discount").withEntry(EQUIPMENT, "jar_of_light").withEntry(EQUIPMENT, "void_jar").withEntry(EQUIPMENT, "warp_scroll")), this.getPath(GETTING_STARTED, "trinkets"));
        this.addBasicItem((ItemLike)ItemsRegistry.AMULET_OF_MANA_BOOST, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.AMULET_OF_MANA_BOOST));
        this.addBasicItem((ItemLike)ItemsRegistry.AMULET_OF_MANA_REGEN, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.AMULET_OF_MANA_REGEN));
        this.addBasicItem((ItemLike)ItemsRegistry.BELT_OF_LEVITATION, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.BELT_OF_LEVITATION));
        this.addBasicItem((ItemLike)ItemsRegistry.BELT_OF_UNSTABLE_GIFTS, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.BELT_OF_UNSTABLE_GIFTS));
        this.addBasicItem((ItemLike)ItemsRegistry.JAR_OF_LIGHT, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.JAR_OF_LIGHT));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ItemsRegistry.STARBUNCLE_CHARM).withLocalizedText().withPage(new ApparatusPage((ItemLike)ItemsRegistry.STARBUNCLE_CHARM)).withPage(new EntityPage(ModEntities.STARBUNCLE_TYPE.getRegistryName().toString()).withText(this.getLangPath("starbuncle_charm", 2))).withPage(new TextPage(this.getLangPath("starbuncle_charm", 3)).withTitle("ars_nouveau.summoning")).withPage(new TextPage(this.getLangPath("starbuncle_charm", 4)).withTitle("ars_nouveau.item_transport")).withPage(new TextPage(this.getLangPath("starbuncle_charm", 5)).withTitle("ars_nouveau.filtering")).withPage(new TextPage(this.getLangPath("starbuncle_charm", 6)).withTitle("ars_nouveau.pathing")), this.getPath(AUTOMATION, "starbuncle_charm"));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ItemsRegistry.DRYGMY_CHARM).withLocalizedText().withPage(new ApparatusPage((ItemLike)ItemsRegistry.DRYGMY_CHARM)).withPage(new EntityPage(ModEntities.ENTITY_DRYGMY.getRegistryName().toString()).withText(this.getLangPath("drygmy_charm", 2))).withPage(new TextPage(this.getLangPath("drygmy_charm", 3)).withTitle("ars_nouveau.summoning")).withPage(new TextPage(this.getLangPath("drygmy_charm", 4)).withTitle("ars_nouveau.happiness")).withPage(new TextPage(this.getLangPath("drygmy_charm", 5)).withTitle("ars_nouveau.production")), this.getPath(AUTOMATION, "drygmy_charm"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ItemsRegistry.DULL_TRINKET).withPage(new CraftingPage((ItemLike)ItemsRegistry.DULL_TRINKET).withRecipe2((ItemLike)ItemsRegistry.MUNDANE_BELT)).withPage(new CraftingPage((ItemLike)ItemsRegistry.RING_OF_POTENTIAL)), this.getPath(EQUIPMENT, "dull_items"));
        this.addBasicItem((ItemLike)BlockRegistry.MAGE_BLOOM_CROP, RESOURCES, new ApparatusPage((ItemLike)BlockRegistry.MAGE_BLOOM_CROP));
        this.addPage(new PatchouliBuilder(EQUIPMENT, (ItemLike)ItemsRegistry.POTION_FLASK).withLocalizedText().withPage(new ApparatusPage((ItemLike)ItemsRegistry.POTION_FLASK)).withLocalizedText().withPage(new ApparatusPage((ItemLike)ItemsRegistry.POTION_FLASK_EXTEND_TIME)).withLocalizedText().withPage(new ApparatusPage((ItemLike)ItemsRegistry.POTION_FLASK_AMPLIFY)), this.getPath(EQUIPMENT, "potion_flask"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, "reactive_enchantment").withIcon((ItemLike)Items.f_42690_).withLocalizedText().withPage(new EnchantingPage("ars_nouveau:" + EnchantmentRegistry.REACTIVE_ENCHANTMENT.getRegistryName().m_135815_() + "_1")).withLocalizedText().withPage(new EnchantingPage("ars_nouveau:" + EnchantmentRegistry.REACTIVE_ENCHANTMENT.getRegistryName().m_135815_() + "_2")).withPage(new EnchantingPage("ars_nouveau:" + EnchantmentRegistry.REACTIVE_ENCHANTMENT.getRegistryName().m_135815_() + "_3")).withPage(new EnchantingPage("ars_nouveau:" + EnchantmentRegistry.REACTIVE_ENCHANTMENT.getRegistryName().m_135815_() + "_4")).withLocalizedText().withPage(new ApparatusPage("ars_nouveau:spell_write")), this.getPath(EQUIPMENT, "reactive_enchantment"));
        this.addBasicItem((ItemLike)ItemsRegistry.RING_OF_GREATER_DISCOUNT, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.RING_OF_GREATER_DISCOUNT));
        this.addBasicItem((ItemLike)ItemsRegistry.RING_OF_LESSER_DISCOUNT, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.RING_OF_LESSER_DISCOUNT));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)BlockRegistry.BASIC_SPELL_TURRET).withLocalizedText().withPage(new CraftingPage((ItemLike)BlockRegistry.BASIC_SPELL_TURRET)).withLocalizedText().withPage(new ApparatusPage((ItemLike)BlockRegistry.ENCHANTED_SPELL_TURRET)).withLocalizedText().withPage(new ApparatusPage((ItemLike)BlockRegistry.TIMER_SPELL_TURRET)).withLocalizedText(), this.getPath(AUTOMATION, "spell_turret"));
        this.addBasicItem((ItemLike)ItemsRegistry.SUMMONING_FOCUS, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.SUMMONING_FOCUS));
        this.addBasicItem((ItemLike)ItemsRegistry.VOID_JAR, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.VOID_JAR));
        this.addBasicItem((ItemLike)ItemsRegistry.WAND, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.WAND));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ItemsRegistry.WHIRLISPRIG_CHARM).withLocalizedText().withPage(new ApparatusPage((ItemLike)ItemsRegistry.WHIRLISPRIG_CHARM)).withPage(new EntityPage(ModEntities.WHIRLISPRIG_TYPE.getRegistryName().toString()).withText(this.getLangPath("whirlisprig_charm", 2))).withPage(new TextPage(this.getLangPath("whirlisprig_charm", 3)).withTitle("ars_nouveau.summoning")).withPage(new TextPage(this.getLangPath("whirlisprig_charm", 4)).withTitle("ars_nouveau.happiness")).withPage(new TextPage(this.getLangPath("whirlisprig_charm", 5)).withTitle("ars_nouveau.important")).withPage(new TextPage(this.getLangPath("whirlisprig_charm", 6)).withTitle("ars_nouveau.production")), this.getPath(AUTOMATION, "whirlisprig_charm"));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ItemsRegistry.BOOKWYRM_CHARM).withLocalizedText().withPage(new ApparatusPage((ItemLike)ItemsRegistry.BOOKWYRM_CHARM)).withPage(new EntityPage(ModEntities.ENTITY_BOOKWYRM_TYPE.getRegistryName().toString()).withText(this.getLangPath("bookwyrm_charm", 2))).withPage(new TextPage(this.getLangPath("bookwyrm_charm", 3))).withPage(new TextPage(this.getLangPath("bookwyrm_charm", 4))).withPage(new TextPage(this.getLangPath("bookwyrm_charm", 5))), this.getPath(AUTOMATION, "bookwyrm_charm"));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ItemsRegistry.WIXIE_CHARM).withLocalizedText().withPage(new ApparatusPage((ItemLike)ItemsRegistry.WIXIE_CHARM)).withPage(new EntityPage(ModEntities.ENTITY_WIXIE_TYPE.getRegistryName().toString()).withText(this.getLangPath("wixie_charm", 2))).withPage(new TextPage(this.getLangPath("wixie_charm", 3)).withTitle("ars_nouveau.item_crafting")).withPage(new TextPage(this.getLangPath("wixie_charm", 4)).withTitle("ars_nouveau.potion_crafting")).withPage(new TextPage(this.getLangPath("wixie_charm", 5))), this.getPath(AUTOMATION, "wixie_charm"));
        this.addPage(new PatchouliBuilder(RESOURCES, "archwood").withIcon((ItemLike)BlockRegistry.CASCADING_SAPLING).withLocalizedText(), this.getPath(RESOURCES, "archwood"));
        this.addPage(new PatchouliBuilder(RESOURCES, "decorative").withIcon((ItemLike)BlockRegistry.ARCANE_BRICKS).withLocalizedText().withPage(new CraftingPage((ItemLike)BlockRegistry.ARCANE_STONE).withRecipe2((ItemLike)BlockRegistry.AS_GOLD_STONE)), this.getPath(RESOURCES, "decorative"));
        this.addPage(new PatchouliBuilder(RESOURCES, (ItemLike)BlockRegistry.LAVA_LILY).withLocalizedText().withPage(new CraftingPage((ItemLike)BlockRegistry.LAVA_LILY)), this.getPath(RESOURCES, "lava_lily"));
        this.addPage(new PatchouliBuilder(RESOURCES, (ItemLike)BlockRegistry.SOURCEBERRY_BUSH).withLocalizedText().withPage(new CraftingPage((ItemLike)ItemsRegistry.SOURCE_BERRY_PIE).withRecipe2((ItemLike)ItemsRegistry.SOURCE_BERRY_ROLL)), this.getPath(RESOURCES, "sourceberry"));
        this.addPage(new PatchouliBuilder(RESOURCES, "weald_walker").withIcon((ItemLike)ArsNouveauAPI.getInstance().getRitualItemMap().get("awakening")).withLocalizedText().withPage(new EntityPage(ModEntities.ENTITY_BLAZING_WEALD.getRegistryName().toString()).withText(this.getLangPath("weald_walker", 2))).withPage(new EntityPage(ModEntities.ENTITY_CASCADING_WEALD.getRegistryName().toString()).withText(this.getLangPath("weald_walker", 3))).withPage(new EntityPage(ModEntities.ENTITY_FLOURISHING_WEALD.getRegistryName().toString()).withText(this.getLangPath("weald_walker", 4))).withPage(new EntityPage(ModEntities.ENTITY_VEXING_WEALD.getRegistryName().toString()).withText(this.getLangPath("weald_walker", 5))), this.getPath(RESOURCES, "weald_walker"));
        this.addPage(new PatchouliBuilder(RESOURCES, "wilden").withIcon((ItemLike)ItemsRegistry.WILDEN_SPIKE).withLocalizedText().withPage(new EntityPage(ModEntities.WILDEN_HUNTER.getRegistryName().toString()).withText(this.getLangPath("wilden", 3))).withPage(new EntityPage(ModEntities.WILDEN_STALKER.getRegistryName().toString()).withText(this.getLangPath("wilden", 4))).withPage(new EntityPage(ModEntities.WILDEN_GUARDIAN.getRegistryName().toString()).withText(this.getLangPath("wilden", 5))).withPage(new EntityPage(ModEntities.WILDEN_BOSS.getRegistryName().toString())).withPage(new TextPage(this.getLangPath("wilden", 6))), this.getPath(RESOURCES, "wilden"));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ItemsRegistry.DENY_ITEM_SCROLL).withLocalizedText().withPage(new CraftingPage((ItemLike)ItemsRegistry.BLANK_PARCHMENT).withRecipe2((ItemLike)ItemsRegistry.DENY_ITEM_SCROLL)), this.getPath(AUTOMATION, "deny_scroll"));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ItemsRegistry.MIMIC_ITEM_SCROLL).withLocalizedText().withPage(new CraftingPage((ItemLike)ItemsRegistry.BLANK_PARCHMENT).withRecipe2((ItemLike)ItemsRegistry.MIMIC_ITEM_SCROLL)), this.getPath(AUTOMATION, "mimic_scroll"));
        this.addPage(new PatchouliBuilder(AUTOMATION, (ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL).withLocalizedText().withPage(new CraftingPage((ItemLike)ItemsRegistry.BLANK_PARCHMENT).withRecipe2((ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL)), this.getPath(AUTOMATION, "allow_scroll"));
        this.addBasicItem((ItemLike)ItemsRegistry.DOMINION_ROD, AUTOMATION, new ApparatusPage((ItemLike)ItemsRegistry.DOMINION_ROD));
        this.addBasicItem((ItemLike)BlockRegistry.SPELL_PRISM, AUTOMATION, new CraftingPage((ItemLike)BlockRegistry.SPELL_PRISM));
        this.addBasicItem((ItemLike)BlockRegistry.SCONCE_BLOCK, RESOURCES, new CraftingPage((ItemLike)BlockRegistry.SCONCE_BLOCK));
        this.addPage(new PatchouliBuilder(EQUIPMENT, "armor").withIcon((ItemLike)ItemsRegistry.NOVICE_ROBES).withLocalizedText().withPage(new CraftingPage((ItemLike)ItemsRegistry.MAGE_FIBER).withRecipe2((ItemLike)ItemsRegistry.NOVICE_HOOD)).withPage(new CraftingPage((ItemLike)ItemsRegistry.NOVICE_ROBES).withRecipe2((ItemLike)ItemsRegistry.NOVICE_LEGGINGS)).withPage(new CraftingPage((ItemLike)ItemsRegistry.NOVICE_BOOTS).withRecipe2((ItemLike)ItemsRegistry.BLAZE_FIBER)).withPage(new CraftingPage((ItemLike)ItemsRegistry.APPRENTICE_HOOD).withRecipe2((ItemLike)ItemsRegistry.APPRENTICE_ROBES)).withPage(new CraftingPage((ItemLike)ItemsRegistry.APPRENTICE_LEGGINGS).withRecipe2((ItemLike)ItemsRegistry.APPRENTICE_BOOTS)).withPage(new CraftingPage((ItemLike)ItemsRegistry.END_FIBER).withRecipe2((ItemLike)ItemsRegistry.ARCHMAGE_HOOD)).withPage(new CraftingPage((ItemLike)ItemsRegistry.ARCHMAGE_ROBES).withRecipe2((ItemLike)ItemsRegistry.ARCHMAGE_LEGGINGS)).withPage(new CraftingPage((ItemLike)ItemsRegistry.ARCHMAGE_BOOTS)), this.getPath(EQUIPMENT, "armor"));
        this.addPage(new PatchouliBuilder(EQUIPMENT, "spell_books").withIcon((ItemLike)ItemsRegistry.ARCHMAGE_SPELLBOOK).withLocalizedText().withPage(new CraftingPage((ItemLike)ItemsRegistry.NOVICE_SPELLBOOK).withRecipe2("ars_nouveau:apprentice_spell_book_upgrade")).withPage(new CraftingPage("ars_nouveau:archmage_spell_book_upgrade")), this.getPath(EQUIPMENT, "spell_books"));
        this.addBasicItem((ItemLike)ItemsRegistry.ENCHANTERS_MIRROR, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.ENCHANTERS_MIRROR));
        this.addBasicItem((ItemLike)ItemsRegistry.ENCHANTERS_SHIELD, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.ENCHANTERS_SHIELD));
        this.addBasicItem((ItemLike)ItemsRegistry.ENCHANTERS_SWORD, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.ENCHANTERS_SWORD));
        this.addBasicItem((ItemLike)ItemsRegistry.SPELL_BOW, EQUIPMENT, new ApparatusPage((ItemLike)ItemsRegistry.SPELL_BOW));
        this.addBasicItem((ItemLike)ItemsRegistry.RUNIC_CHALK, EQUIPMENT, new CraftingPage((ItemLike)ItemsRegistry.RUNIC_CHALK));
        this.addBasicItem((ItemLike)ItemsRegistry.WARP_SCROLL, EQUIPMENT, new CraftingPage((ItemLike)ItemsRegistry.WARP_SCROLL));
        this.addPage(new PatchouliBuilder(MACHINES, (ItemLike)BlockRegistry.IMBUEMENT_BLOCK).withLocalizedText().withPage(new CraftingPage((ItemLike)BlockRegistry.IMBUEMENT_BLOCK)).withPage(new ImbuementPage("ars_nouveau:imbuement_lapis")).withPage(new ImbuementPage("ars_nouveau:imbuement_amethyst")).withPage(new ImbuementPage("ars_nouveau:imbuement_amethyst_block")).withPage(new ImbuementPage("ars_nouveau:imbuement_" + ItemsRegistry.FIRE_ESSENCE.getRegistryName().m_135815_())).withPage(new ImbuementPage("ars_nouveau:imbuement_" + ItemsRegistry.EARTH_ESSENCE.getRegistryName().m_135815_())).withPage(new ImbuementPage("ars_nouveau:imbuement_" + ItemsRegistry.WATER_ESSENCE.getRegistryName().m_135815_())).withPage(new ImbuementPage("ars_nouveau:imbuement_" + ItemsRegistry.AIR_ESSENCE.getRegistryName().m_135815_())).withPage(new ImbuementPage("ars_nouveau:imbuement_" + ItemsRegistry.ABJURATION_ESSENCE.getRegistryName().m_135815_())).withPage(new ImbuementPage("ars_nouveau:imbuement_" + ItemsRegistry.CONJURATION_ESSENCE.getRegistryName().m_135815_())).withPage(new ImbuementPage("ars_nouveau:imbuement_" + ItemsRegistry.MANIPULATION_ESSENCE.getRegistryName().m_135815_())), this.getPath(MACHINES, "imbuement_chamber"));
        this.addPage(new PatchouliBuilder(MACHINES, (ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK).withLocalizedText().withPage(new CraftingPage((ItemLike)BlockRegistry.ARCANE_PEDESTAL).withRecipe2((ItemLike)BlockRegistry.ARCANE_CORE_BLOCK)).withPage(new CraftingPage((ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK)), this.getPath(MACHINES, "enchanting_apparatus"));
        this.addPage(new PatchouliBuilder(MACHINES, (ItemLike)BlockRegistry.GLYPH_PRESS_BLOCK).withLocalizedText().withLocalizedText().withPage(new CraftingPage((ItemLike)BlockRegistry.GLYPH_PRESS_BLOCK).withRecipe2((ItemLike)ItemsRegistry.MAGIC_CLAY)).withPage(new CraftingPage((ItemLike)ItemsRegistry.MARVELOUS_CLAY).withRecipe2((ItemLike)ItemsRegistry.MYTHICAL_CLAY)), this.getPath(MACHINES, "glyph_press"));
        this.addBasicItem((ItemLike)BlockRegistry.POTION_JAR, MACHINES, new CraftingPage((ItemLike)BlockRegistry.POTION_JAR));
        this.addPage(new PatchouliBuilder(MACHINES, (ItemLike)BlockRegistry.POTION_MELDER).withLocalizedText().withPage(new ApparatusPage((ItemLike)BlockRegistry.POTION_MELDER)).withPage(new MultiblockPage(BlockRegistry.POTION_MELDER.m_7705_(), new String[][]{{"   "}, {"C0C"}, {" C "}}).withMapping("C", "ars_nouveau:potion_jar").withMapping("0", "ars_nouveau:potion_melder").withText(this.getLangPath("potion_melder", 2))), this.getPath(MACHINES, "potion_melder"));
        this.addBasicItem((ItemLike)BlockRegistry.RITUAL_BLOCK, MACHINES, new CraftingPage((ItemLike)BlockRegistry.RITUAL_BLOCK));
        this.addPage(new PatchouliBuilder(MACHINES, (ItemLike)BlockRegistry.SCRIBES_BLOCK).withLocalizedText().withLocalizedText().withPage(new CraftingPage((ItemLike)ItemsRegistry.SPELL_PARCHMENT).withRecipe2((ItemLike)BlockRegistry.SCRIBES_BLOCK)), this.getPath(MACHINES, "scribes_block"));
        this.addPage(new PatchouliBuilder(MACHINES, "warp_portal").withIcon((ItemLike)ItemsRegistry.WARP_SCROLL).withLocalizedText().withLocalizedText().withPage(new MultiblockPage(this.getLangPath("warp_portal", 3), new String[][]{{" BB "}, {"BPPB"}, {"B0PB"}, {"BPPB"}, {" BB "}}).withMapping("B", "ars_nouveau:arcane_bricks").withMapping("P", "ars_nouveau:portal").withMapping("0", "ars_nouveau:portal").withText(this.getLangPath("warp_portal", 4))), this.getPath(MACHINES, "warp_portal"));
        this.addBasicItem((ItemLike)BlockRegistry.AGRONOMIC_SOURCELINK, SOURCE, new CraftingPage((ItemLike)BlockRegistry.AGRONOMIC_SOURCELINK));
        this.addBasicItem((ItemLike)BlockRegistry.ALCHEMICAL_BLOCK, SOURCE, new CraftingPage((ItemLike)BlockRegistry.ALCHEMICAL_BLOCK));
        this.addBasicItem((ItemLike)BlockRegistry.MYCELIAL_BLOCK, SOURCE, new CraftingPage((ItemLike)BlockRegistry.MYCELIAL_BLOCK));
        this.addBasicItem((ItemLike)BlockRegistry.SOURCE_JAR, SOURCE, new CraftingPage((ItemLike)BlockRegistry.SOURCE_JAR));
        this.addBasicItem((ItemLike)BlockRegistry.RELAY, SOURCE, new CraftingPage((ItemLike)BlockRegistry.RELAY));
        this.addBasicItem((ItemLike)BlockRegistry.RELAY_DEPOSIT, SOURCE, new ApparatusPage((ItemLike)BlockRegistry.RELAY_DEPOSIT));
        this.addBasicItem((ItemLike)BlockRegistry.RELAY_SPLITTER, SOURCE, new ApparatusPage((ItemLike)BlockRegistry.RELAY_SPLITTER));
        this.addBasicItem((ItemLike)BlockRegistry.RELAY_WARP, SOURCE, new ApparatusPage((ItemLike)BlockRegistry.RELAY_WARP));
        this.addBasicItem((ItemLike)BlockRegistry.VITALIC_BLOCK, SOURCE, new CraftingPage((ItemLike)BlockRegistry.VITALIC_BLOCK));
        this.addPage(new PatchouliBuilder(SOURCE, (ItemLike)BlockRegistry.VOLCANIC_BLOCK).withLocalizedText().withPage(new TextPage(this.getLangPath("volcanic_sourcelink", 2)).withTitle("ars_nouveau.active_generation")).withPage(new TextPage(this.getLangPath("volcanic_sourcelink", 3)).withTitle("ars_nouveau.heat")).withPage(new CraftingPage((ItemLike)BlockRegistry.VOLCANIC_BLOCK).withRecipe2((ItemLike)BlockRegistry.LAVA_LILY)).withPage(new TextPage(this.getLangPath("volcanic_sourcelink", 4))), this.getPath(SOURCE, "volcanic_sourcelink"));
        this.addPage(new PatchouliBuilder(ENCHANTMENTS, "how_to_enchant").withIcon((ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK).withSortNum(-1).withLocalizedText().withLocalizedText().withPage(new RelationsPage().withEntry(MACHINES, "enchanting_apparatus")), this.getPath(ENCHANTMENTS, "how_to_enchant"));
        this.addPage(new PatchouliBuilder(RITUALS, "performing_rituals").withSortNum(-1).withIcon((ItemLike)BlockRegistry.RITUAL_BLOCK).withLocalizedText().withLocalizedText().withPage(new CraftingPage((ItemLike)ArsNouveauAPI.getInstance().getRitualItemMap().get("sunrise"))).withPage(new RelationsPage().withEntry(MACHINES, "ritual_brazier")), this.getPath(RITUALS, "performing_rituals"));
        this.addPage(new PatchouliBuilder(FAMILIARS, "summoning_familiars").withSortNum(-1).withIcon((ItemLike)ArsNouveauAPI.getInstance().getRitualItemMap().get("binding")).withLocalizedText().withLocalizedText().withPage(new CraftingPage((ItemLike)ArsNouveauAPI.getInstance().getRitualItemMap().get("binding"))).withPage(new RelationsPage().withEntry(MACHINES, "ritual_brazier").withEntry(RITUALS, "binding")), this.getPath(FAMILIARS, "summoning_familiars"));
        this.addPage(new PatchouliBuilder(MOD_NEWS, "mod_news").withIcon((ItemLike)ItemsRegistry.SPELL_PARCHMENT).withPage(new LinkPage("https://discord.gg/y7TMXZu", "ars_nouveau.discord_text", "ars_nouveau.community")).withPage(new LinkPage("https://www.redbubble.com/people/Gootastic/explore?page=1&sortOrder=recent", "ars_nouveau.store_text", "ars_nouveau.store")), this.getPath(MOD_NEWS, "mod_news"));
        this.addBasicItem((ItemLike)ItemsRegistry.DOWSING_ROD, EQUIPMENT, new CraftingPage((ItemLike)ItemsRegistry.DOWSING_ROD));
    }

    public String getLangPath(String name, int count) {
        return "ars_nouveau.page" + count + "." + name;
    }

    public String getLangPath(String name) {
        return "ars_nouveau.page." + name;
    }

    public void addPage(PatchouliBuilder builder, Path path) {
        this.pages.add(new PatchouliPage(builder, path));
    }

    public void addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = new PatchouliBuilder(category, item.m_5456_().m_5524_()).withIcon((ItemLike)item.m_5456_()).withPage(new TextPage("ars_nouveau.page." + item.m_5456_().getRegistryName().m_135815_())).withPage(recipePage);
        this.pages.add(new PatchouliPage(builder, this.getPath(category, item.m_5456_().getRegistryName())));
    }

    public Path getPath(ResourceLocation category, ResourceLocation fileName) {
        return this.generator.m_123916_().resolve("data/ars_nouveau/patchouli/" + category.m_135815_() + "/" + fileName.m_135815_() + ".json");
    }

    public Path getPath(ResourceLocation category, String fileName) {
        return this.generator.m_123916_().resolve("data/ars_nouveau/patchouli/" + category.m_135815_() + "/" + fileName + ".json");
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.addEntries();
        for (PatchouliPage patchouliPage : this.pages) {
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)patchouliPage.builder.build(), (Path)patchouliPage.path);
        }
    }

    public void addGlyphPage(AbstractSpellPart spellPart) {
        ResourceLocation category = null;
        category = spellPart.getTier() == ISpellTier.Tier.ONE ? GLYPHS_1 : (spellPart.getTier() == ISpellTier.Tier.TWO ? GLYPHS_2 : GLYPHS_3);
        PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName("ars_nouveau.glyph_name." + spellPart.getTag()).withIcon("ars_nouveau:" + spellPart.getItemID()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage(new TextPage("ars_nouveau.glyph_desc." + spellPart.tag)).withPage(new GlyphPressPage(spellPart));
        this.pages.add(new PatchouliPage(builder, this.getPath(category, "glyph_" + spellPart.tag)));
    }

    public void addFamiliarPage(AbstractFamiliarHolder familiarHolder) {
        PatchouliBuilder builder = new PatchouliBuilder(FAMILIARS, "entity.ars_nouveau." + familiarHolder.getId()).withIcon("ars_nouveau:familiar_" + familiarHolder.getId()).withTextPage("ars_nouveau.familiar_desc." + familiarHolder.getId()).withPage(new EntityPage(new ResourceLocation("ars_nouveau", familiarHolder.getEntityKey()).toString()));
        this.pages.add(new PatchouliPage(builder, this.generator.m_123916_().resolve("data/ars_nouveau/patchouli/familiars/" + familiarHolder.getId() + ".json")));
    }

    public void addRitualPage(AbstractRitual ritual) {
        PatchouliBuilder builder = new PatchouliBuilder(RITUALS, "item.ars_nouveau.ritual_" + ritual.getID()).withIcon("ars_nouveau:ritual_" + ritual.getID()).withTextPage("ars_nouveau.ritual_desc." + ritual.getID()).withPage(new CraftingPage("ars_nouveau:ritual_" + ritual.getID()));
        this.pages.add(new PatchouliPage(builder, this.generator.m_123916_().resolve("data/ars_nouveau/patchouli/rituals/" + ritual.getID() + ".json")));
    }

    public void addEnchantmentPage(Enchantment enchantment) {
        PatchouliBuilder builder = new PatchouliBuilder(ENCHANTMENTS, enchantment.m_44704_()).withIcon(Items.f_42690_.getRegistryName().toString());
        for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
            builder.withPage(new EnchantingPage("ars_nouveau:" + enchantment.getRegistryName().m_135815_() + "_" + i));
        }
        this.pages.add(new PatchouliPage(builder, this.generator.m_123916_().resolve("data/ars_nouveau/patchouli/enchantments/" + enchantment.getRegistryName().m_135815_() + ".json")));
    }

    public String m_6055_() {
        return "Patchouli";
    }

    public record PatchouliPage(PatchouliBuilder builder, Path path) {
    }
}

