/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CrushRecipe
implements Recipe<Container> {
    public final Ingredient input;
    public final List<CrushOutput> outputs;
    public final ResourceLocation id;
    public static final String RECIPE_ID = "crush";

    public CrushRecipe(ResourceLocation id, Ingredient input, List<CrushOutput> outputs) {
        this.input = input;
        this.outputs = outputs;
        this.id = id;
    }

    public CrushRecipe(String id, Ingredient input, List<CrushOutput> outputs) {
        this(new ResourceLocation("ars_nouveau", "crush_" + id), input, outputs);
    }

    public CrushRecipe(String id, Ingredient input) {
        this(id, input, new ArrayList<CrushOutput>());
    }

    public List<ItemStack> getRolledOutputs(Random random) {
        ArrayList<ItemStack> finalOutputs = new ArrayList<ItemStack>();
        for (CrushOutput crushRoll : this.outputs) {
            if (!(random.nextDouble() <= (double)crushRoll.chance)) continue;
            finalOutputs.add(crushRoll.stack.m_41777_());
        }
        return finalOutputs;
    }

    public CrushRecipe withItems(ItemStack output, float chance) {
        this.outputs.add(new CrushOutput(output, chance));
        return this;
    }

    public CrushRecipe withItems(ItemStack output) {
        this.outputs.add(new CrushOutput(output, 1.0f));
        return this;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return this.input.test(inventory.m_8020_(0));
    }

    public boolean matches(ItemStack i, Level world) {
        return this.input.test(i);
    }

    @Nonnull
    public ItemStack m_5874_(Container inventory) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_194133_1_, int p_194133_2_) {
        return true;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeRegistry.CRUSH_SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)Registry.f_122864_.m_7745_(new ResourceLocation("ars_nouveau", RECIPE_ID));
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:crush");
        jsonobject.add("input", this.input.m_43942_());
        JsonArray array = new JsonArray();
        for (CrushOutput output : this.outputs) {
            JsonObject element = new JsonObject();
            element.addProperty("item", output.stack.m_41720_().getRegistryName().toString());
            element.addProperty("chance", (Number)Float.valueOf(output.chance));
            element.addProperty("count", (Number)output.stack.m_41613_());
            array.add((JsonElement)element);
        }
        jsonobject.add("output", (JsonElement)array);
        return jsonobject;
    }

    public static class CrushOutput {
        public ItemStack stack;
        public float chance;

        public CrushOutput(ItemStack stack, float chance) {
            this.stack = stack;
            this.chance = chance;
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<CrushRecipe> {
        public CrushRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = null;
            input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"input")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            JsonArray outputs = GsonHelper.m_13933_((JsonObject)json, (String)"output");
            ArrayList<CrushOutput> parsedOutputs = new ArrayList<CrushOutput>();
            for (JsonElement e : outputs) {
                JsonObject obj = e.getAsJsonObject();
                float chance = GsonHelper.m_13915_((JsonObject)obj, (String)"chance");
                String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"item");
                int count = obj.has("count") ? GsonHelper.m_13927_((JsonObject)obj, (String)"count") : 1;
                ItemStack output = new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(itemId)), count);
                parsedOutputs.add(new CrushOutput(output, chance));
            }
            return new CrushRecipe(recipeId, input, parsedOutputs);
        }

        public void toNetwork(FriendlyByteBuf buf, CrushRecipe recipe) {
            buf.writeInt(recipe.outputs.size());
            recipe.input.m_43923_(buf);
            for (CrushOutput i : recipe.outputs) {
                buf.writeFloat(i.chance);
                buf.writeItemStack(i.stack, false);
            }
        }

        @Nullable
        public CrushRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int length = buffer.readInt();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ArrayList<CrushOutput> stacks = new ArrayList<CrushOutput>();
            for (int i = 0; i < length; ++i) {
                try {
                    float chance = buffer.readFloat();
                    ItemStack outStack = buffer.m_130267_();
                    stacks.add(new CrushOutput(outStack, chance));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            return new CrushRecipe(recipeId, input, stacks);
        }
    }
}

