/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.ArcaneRelayTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RelaySplitterTile
extends ArcaneRelayTile {
    ArrayList<BlockPos> toList = new ArrayList();
    ArrayList<BlockPos> fromList = new ArrayList();

    public RelaySplitterTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.RELAY_SPLITTER_TILE, pos, state);
    }

    public RelaySplitterTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean setTakeFrom(BlockPos pos) {
        return this.closeEnough(pos) && this.fromList.add(pos) && this.update();
    }

    @Override
    public boolean setSendTo(BlockPos pos) {
        return this.closeEnough(pos) && this.toList.add(pos) && this.update();
    }

    @Override
    public void clearPos() {
        this.toList.clear();
        this.fromList.clear();
        this.update();
    }

    public void processFromList() {
        if (this.fromList.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        int ratePer = this.getTransferRate() / this.fromList.size();
        for (BlockPos fromPos : this.fromList) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(fromPos);
            if (!(blockEntity instanceof AbstractSourceMachine)) {
                stale.add(fromPos);
                continue;
            }
            AbstractSourceMachine fromTile = (AbstractSourceMachine)blockEntity;
            if (this.transferSource(fromTile, this, ratePer) <= 0) continue;
            this.createParticles(fromPos, this.f_58858_);
        }
        for (BlockPos s : stale) {
            this.fromList.remove(s);
        }
    }

    public void createParticles(BlockPos from, BlockPos to) {
        ParticleUtil.spawnFollowProjectile(this.f_58857_, from, to);
    }

    public void processToList() {
        if (this.toList.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        int ratePer = this.getTransferRate() / this.toList.size();
        for (BlockPos toPos : this.toList) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(toPos);
            if (!(blockEntity instanceof AbstractSourceMachine)) {
                stale.add(toPos);
                continue;
            }
            AbstractSourceMachine toTile = (AbstractSourceMachine)blockEntity;
            int transfer = this.transferSource(this, toTile, ratePer);
            if (transfer <= 0) continue;
            this.createParticles(this.f_58858_, toPos);
        }
        for (BlockPos s : stale) {
            this.toList.remove(s);
        }
    }

    @Override
    public void tick() {
        if (this.f_58857_.m_46467_() % 20L != 0L || this.toList.isEmpty() || this.f_58857_.f_46443_) {
            return;
        }
        this.processFromList();
        this.processToList();
        this.update();
    }

    @Override
    public int getTransferRate() {
        return 2500;
    }

    @Override
    public int getMaxSource() {
        return 2500;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        BlockPos pos;
        super.m_142466_(tag);
        this.fromList = new ArrayList();
        this.toList = new ArrayList();
        int counter = 0;
        while (NBTUtil.hasBlockPos(tag, "from_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "from_" + counter);
            if (!this.fromList.contains(pos)) {
                this.fromList.add(pos);
            }
            ++counter;
        }
        counter = 0;
        while (NBTUtil.hasBlockPos(tag, "to_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "to_" + counter);
            if (!this.toList.contains(pos)) {
                this.toList.add(NBTUtil.getBlockPos(tag, "to_" + counter));
            }
            ++counter;
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        int counter = 0;
        for (BlockPos p : this.fromList) {
            NBTUtil.storeBlockPos(tag, "from_" + counter, p);
            ++counter;
        }
        counter = 0;
        for (BlockPos p : this.toList) {
            NBTUtil.storeBlockPos(tag, "to_" + counter, p);
            ++counter;
        }
    }

    @Override
    public List<Component> getTooltip(List<Component> tooltip) {
        if (this.toList == null || this.toList.isEmpty()) {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.relay.no_to"));
        } else {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.relay.one_to", new Object[]{this.toList.size()}));
        }
        if (this.fromList == null || this.fromList.isEmpty()) {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.relay.no_from"));
        } else {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.relay.one_from", new Object[]{this.fromList.size()}));
        }
        return tooltip;
    }
}

