/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PotionJarTile
extends ModdedTile
implements ITickable,
ITooltipProvider,
IWandable {
    private int amount;
    private Potion potion = Potions.f_43598_;
    public boolean isLocked;
    private List<MobEffectInstance> customEffects = new ArrayList<MobEffectInstance>();

    public PotionJarTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public PotionJarTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.POTION_JAR_TYPE, pos, state);
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        int fillState = 0;
        if (this.getCurrentFill() > 0 && this.getCurrentFill() < 1000) {
            fillState = 1;
        } else if (this.getCurrentFill() != 0) {
            fillState = this.getCurrentFill() / 1000 + 1;
        }
        if (this.f_58857_.m_46467_() % 20L == 0L && this.getAmount() <= 0 && this.potion != Potions.f_43598_ && !this.isLocked) {
            this.potion = Potions.f_43598_;
            this.customEffects = new ArrayList<MobEffectInstance>();
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_(SourceJar.fill, (Comparable)Integer.valueOf(fillState)), 3);
        }
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_(SourceJar.fill, (Comparable)Integer.valueOf(fillState)), 3);
    }

    public boolean canAcceptNewPotion() {
        return this.amount <= 0 && !this.isLocked || this.potion == Potions.f_43598_ && !this.isLocked;
    }

    @Override
    public void onWanded(Player playerEntity) {
        if (!this.isLocked) {
            this.isLocked = true;
            playerEntity.m_6352_((Component)new TranslatableComponent("ars_nouveau.locked"), Util.f_137441_);
        } else {
            this.isLocked = false;
            playerEntity.m_6352_((Component)new TranslatableComponent("ars_nouveau.unlocked"), Util.f_137441_);
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
    }

    public void setPotion(Potion potion, List<MobEffectInstance> effectInstances) {
        this.potion = potion == null ? Potions.f_43598_ : potion;
        this.customEffects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance e : effectInstances) {
            if (potion.m_43488_().contains(e)) continue;
            this.customEffects.add(e);
        }
    }

    public void setPotion(ItemStack stack) {
        this.setPotion(PotionUtils.m_43579_((ItemStack)stack), PotionUtils.m_43547_((ItemStack)stack));
    }

    private void setPotion(Potion potion) {
        this.potion = potion == null ? Potions.f_43598_ : potion;
    }

    @Nonnull
    public Potion getPotion() {
        return this.potion == null ? Potions.f_43598_ : this.potion;
    }

    public int getColor() {
        return this.potion == null ? 0xF800F8 : PotionUtils.m_43564_(this.getFullEffects());
    }

    public int getCurrentFill() {
        return this.getAmount();
    }

    public void setFill(int fill) {
        this.setAmount(fill);
    }

    public void addAmount(Potion potion, int fill) {
        this.setPotion(potion);
        this.addAmount(fill);
    }

    public void addAmount(int fill) {
        this.setAmount(Math.min(this.getMaxFill(), this.getAmount() + fill));
        if (this.getAmount() <= 0 && !this.isLocked) {
            this.potion = Potions.f_43598_;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
    }

    @Override
    public List<Component> getTooltip(List<Component> tooltip) {
        if (this.potion != null && this.potion != Potions.f_43598_) {
            ItemStack potionStack = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)potionStack, (Potion)this.potion);
            tooltip.add(potionStack.m_41786_());
            PotionUtils.m_43552_((ItemStack)potionStack, this.customEffects);
            PotionUtils.m_43555_((ItemStack)potionStack, tooltip, (float)1.0f);
        }
        tooltip.add((Component)new TranslatableComponent("ars_nouveau.source_jar.fullness", new Object[]{this.getCurrentFill() * 100 / this.getMaxFill()}));
        if (this.isLocked) {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.locked"));
        }
        return tooltip;
    }

    public void appendEffect(List<MobEffectInstance> effects) {
        this.customEffects.addAll(effects);
    }

    public void setCustomEffects(List<MobEffectInstance> effects) {
        this.customEffects.clear();
        this.customEffects.addAll(effects);
    }

    public List<MobEffectInstance> getFullEffects() {
        List<MobEffectInstance> thisEffects = this.getCustomEffects();
        thisEffects.addAll(this.potion.m_43488_());
        return thisEffects;
    }

    public List<MobEffectInstance> getCustomEffects() {
        return new ArrayList<MobEffectInstance>(this.customEffects);
    }

    public boolean isMixEqual(List<MobEffectInstance> effects) {
        ArrayList<MobEffectInstance> thisEffects = new ArrayList<MobEffectInstance>(this.customEffects);
        thisEffects.addAll(this.potion.m_43488_());
        effects = new ArrayList<MobEffectInstance>(effects);
        if (thisEffects.size() != effects.size()) {
            return false;
        }
        effects.sort(Comparator.comparing(MobEffectInstance::toString));
        thisEffects.sort(Comparator.comparing(MobEffectInstance::toString));
        return thisEffects.equals(effects);
    }

    public boolean isMixEqual(Potion potion) {
        return this.isMixEqual(potion.m_43488_());
    }

    public boolean isMixEqual(ItemStack stack) {
        return this.isMixEqual(PotionUtils.m_43547_((ItemStack)stack));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.amount = tag.m_128451_("amount");
        this.potion = PotionUtils.m_43577_((CompoundTag)tag);
        this.customEffects = new ArrayList<MobEffectInstance>();
        this.customEffects.addAll(PotionUtils.m_43573_((CompoundTag)tag));
        this.isLocked = tag.m_128471_("locked");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        ResourceLocation resourcelocation = Registry.f_122828_.m_7981_((Object)this.potion);
        tag.m_128405_("amount", this.getAmount());
        tag.m_128359_("Potion", resourcelocation.toString());
        tag.m_128379_("locked", this.isLocked);
        if (!this.customEffects.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.customEffects) {
                listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("CustomPotionEffects", (Tag)listnbt);
        }
    }

    public int getMaxFill() {
        return 10000;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
    }
}

