/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.recipe.GlyphPressRecipe;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.AnimatedTile;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GlyphPressTile
extends AnimatedTile
implements ITickable,
IAnimatable,
IAnimationListener,
WorldlyContainer {
    private final Map<Direction, LazyOptional<IItemHandler>> itemHandlers = new HashMap<Direction, LazyOptional<IItemHandler>>();
    public long frames = 0L;
    public boolean isCrafting;
    public ItemStack reagentItem = ItemStack.f_41583_;
    public ItemStack baseMaterial = ItemStack.f_41583_;
    public ItemStack oldBaseMat = ItemStack.f_41583_;
    public ItemEntity entity;
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);

    public GlyphPressTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.GLYPH_PRESS_TILE, pos, state);
        ImmutableList.of((Object)Direction.UP, (Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.EAST, (Object)Direction.WEST).forEach(this::addItemHandler);
        this.addItemHandler(null);
    }

    @Override
    public void tick() {
        GlyphPressRecipe recipe;
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 20L == 0L && this.canCraft(this.reagentItem, this.baseMaterial)) {
            this.craft((Player)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.f_58857_)));
        }
        if (this.f_58857_.f_46443_ || !this.isCrafting) {
            return;
        }
        ++this.counter;
        if (this.counter == 110) {
            recipe = ArsNouveauAPI.getInstance().getGlyphPressRecipe(this.f_58857_, this.reagentItem.m_41720_(), this.getTier(this.baseMaterial.m_41720_()));
            this.oldBaseMat = this.baseMaterial.m_41777_();
            this.baseMaterial = recipe.output.m_41777_();
            this.updateBlock();
        }
        if (this.counter == 150) {
            this.isCrafting = false;
            recipe = ArsNouveauAPI.getInstance().getGlyphPressRecipe(this.f_58857_, this.reagentItem.m_41720_(), this.getTier(this.oldBaseMat.m_41720_()));
            if (recipe == null) {
                return;
            }
            ItemStack stack = recipe.output.m_41777_();
            if (!stack.m_41619_()) {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, stack));
            }
            this.reagentItem = ItemStack.f_41583_;
            this.baseMaterial = ItemStack.f_41583_;
            this.oldBaseMat = ItemStack.f_41583_;
            this.counter = 1;
        }
        this.updateBlock();
    }

    @Override
    public void updateBlock() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
    }

    public boolean craft(Player playerEntity) {
        if (this.isCrafting || this.baseMaterial == ItemStack.f_41583_) {
            return false;
        }
        GlyphPressRecipe recipe = ArsNouveauAPI.getInstance().getGlyphPressRecipe(this.f_58857_, this.reagentItem.m_41720_(), this.getTier(this.baseMaterial.m_41720_()));
        if (recipe == null) {
            return false;
        }
        int manaCost = recipe.tier == ISpellTier.Tier.ONE ? 1000 : (recipe.tier == ISpellTier.Tier.TWO ? 2000 : 3000);
        BlockPos jar = SourceUtil.takeSourceNearbyWithParticles(this.f_58858_, this.f_58857_, 5, manaCost);
        if (jar != null) {
            this.isCrafting = true;
            Networking.sendToNearby(this.f_58857_, this.f_58858_, (Object)new PacketOneShotAnimation(this.f_58858_));
            return true;
        }
        playerEntity.m_6352_((Component)new TranslatableComponent("ars_nouveau.glyph_press.no_mana"), Util.f_137441_);
        return false;
    }

    public ISpellTier.Tier getTier(Item clay) {
        if (clay == ItemsRegistry.MAGIC_CLAY) {
            return ISpellTier.Tier.ONE;
        }
        if (clay == ItemsRegistry.MARVELOUS_CLAY) {
            return ISpellTier.Tier.TWO;
        }
        if (clay == ItemsRegistry.MYTHICAL_CLAY) {
            return ISpellTier.Tier.THREE;
        }
        return null;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 1.0f, this::idlePredicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    private <E extends BlockEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    @Override
    public void startAnimation(int arg) {
        AnimationData data = this.manager.getOrCreateAnimationData(Integer.valueOf(this.hashCode()));
        data.setResetSpeedInTicks(0.0);
        AnimationController controller = (AnimationController)data.getAnimationControllers().get("controller");
        controller.markNeedsReload();
        controller.setAnimation(new AnimationBuilder().addAnimation("press", Boolean.valueOf(false)));
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        return this.reagentItem.m_41619_() && this.baseMaterial.m_41619_();
    }

    public ItemStack m_8020_(int index) {
        return index == 0 ? this.reagentItem : (index == 1 ? this.baseMaterial : ItemStack.f_41583_);
    }

    public ItemStack m_7407_(int index, int count) {
        if (index == 0) {
            ItemStack stack = this.reagentItem.m_41777_();
            stack.m_41764_(count);
            this.reagentItem.m_41774_(count);
            this.updateBlock();
            return stack;
        }
        if (index == 1) {
            ItemStack stack = this.baseMaterial.m_41777_();
            stack.m_41774_(count);
            this.baseMaterial.m_41774_(count);
            this.updateBlock();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = this.reagentItem.m_41777_();
        this.reagentItem.m_41764_(0);
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index == 0) {
            this.reagentItem = stack;
        }
        if (index == 1) {
            this.baseMaterial = stack;
        }
        this.updateBlock();
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.reagentItem = ItemStack.f_41583_;
        this.baseMaterial = ItemStack.f_41583_;
    }

    public int[] m_7071_(Direction side) {
        int[] nArray;
        if (side == Direction.UP) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else if (side != Direction.DOWN) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        if (this.isCrafting) {
            return false;
        }
        if (index == 0 && this.reagentItem.m_41619_() && direction == Direction.UP) {
            return this.canCraft(itemStackIn, this.baseMaterial);
        }
        if (index == 1 && direction != Direction.UP && direction != Direction.DOWN && this.baseMaterial.m_41619_()) {
            return this.getTier(itemStackIn.m_41720_()) != null;
        }
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean canCraft(ItemStack reagent, ItemStack base) {
        if (reagent.m_41619_() || base.m_41619_()) {
            return false;
        }
        GlyphPressRecipe recipe = ArsNouveauAPI.getInstance().getGlyphPressRecipe(this.f_58857_, reagent.m_41720_(), this.getTier(base.m_41720_()));
        if (recipe == null) {
            return false;
        }
        int manaCost = recipe.tier == ISpellTier.Tier.ONE ? 500 : (recipe.tier == ISpellTier.Tier.TWO ? 1500 : 3000);
        AtomicBoolean valid = new AtomicBoolean(false);
        BlockPos.m_121990_((BlockPos)this.m_58899_().m_142082_(5, -3, 5), (BlockPos)this.m_58899_().m_142082_(-5, 3, -5)).forEach(blockPos -> {
            if (!valid.get() && this.f_58857_.m_7702_(blockPos) instanceof SourceJarTile && ((SourceJarTile)this.f_58857_.m_7702_(blockPos)).getSource() >= manaCost) {
                valid.set(true);
            }
        });
        return valid.get();
    }

    private void addItemHandler(@Nullable Direction side) {
        this.itemHandlers.put(side, (LazyOptional<IItemHandler>)LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, side)));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlers.getOrDefault(side, (LazyOptional<IItemHandler>)super.getCapability(cap, side).cast()).cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.itemHandlers.values().forEach(LazyOptional::invalidate);
        super.invalidateCaps();
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.reagentItem = ItemStack.m_41712_((CompoundTag)((CompoundTag)compound.m_128423_("itemStack")));
        this.baseMaterial = ItemStack.m_41712_((CompoundTag)((CompoundTag)compound.m_128423_("baseMat")));
        this.oldBaseMat = ItemStack.m_41712_((CompoundTag)((CompoundTag)compound.m_128423_("oldBase")));
        this.isCrafting = compound.m_128471_("crafting");
        super.m_142466_(compound);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag baseMatTag;
        super.m_183515_(tag);
        if (this.reagentItem != null) {
            CompoundTag reagentTag = new CompoundTag();
            this.reagentItem.m_41739_(reagentTag);
            tag.m_128365_("itemStack", (Tag)reagentTag);
        }
        if (this.baseMaterial != null) {
            baseMatTag = new CompoundTag();
            this.baseMaterial.m_41739_(baseMatTag);
            tag.m_128365_("baseMat", (Tag)baseMatTag);
        }
        if (this.oldBaseMat != null) {
            baseMatTag = new CompoundTag();
            this.oldBaseMat.m_41739_(baseMatTag);
            tag.m_128365_("oldBase", (Tag)baseMatTag);
        }
        tag.m_128379_("crafting", this.isCrafting);
    }
}

