/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.AnimatedTile;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EnchantingApparatusTile
extends AnimatedTile
implements Container,
ITickable,
IAnimatable,
IAnimationListener {
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    public ItemStack catalystItem = ItemStack.f_41583_;
    public ItemEntity entity;
    public long frames = 0L;
    private int craftingLength = 220;
    public boolean isCrafting;
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);

    public EnchantingApparatusTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.ENCHANTING_APP_TILE, pos, state);
        this.counter = 1;
    }

    @Override
    public void tick() {
        int craftingLength = 210;
        if (this.f_58857_.f_46443_) {
            if (this.isCrafting) {
                Level world = this.m_58904_();
                BlockPos pos = this.m_58899_().m_142022_(0.0, 0.5, 0.0);
                Random rand = world.m_5822_();
                Vec3 particlePos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.5, 0.0, 0.5);
                particlePos = particlePos.m_82549_(ParticleUtil.pointInSphere());
                world.m_7106_(ParticleLineData.createData(new ParticleColor(rand.nextInt(255), rand.nextInt(255), rand.nextInt(255))), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
                for (BlockPos p : this.pedestalList()) {
                    this.m_58904_().m_7106_(GlowParticleData.createData(new ParticleColor(rand.nextInt(255), rand.nextInt(255), rand.nextInt(255))), (double)p.m_123341_() + 0.5 + ParticleUtil.inRange(-0.2, 0.2), (double)p.m_123342_() + 1.5 + ParticleUtil.inRange(-0.3, 0.3), (double)p.m_123343_() + 0.5 + ParticleUtil.inRange(-0.2, 0.2), 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        if (this.isCrafting) {
            if (this.getRecipe(this.catalystItem, null) == null) {
                this.isCrafting = false;
            }
            ++this.counter;
        }
        if (this.counter > craftingLength) {
            this.counter = 1;
            if (this.isCrafting) {
                IEnchantingRecipe recipe = this.getRecipe(this.catalystItem, null);
                List<ItemStack> pedestalItems = this.getPedestalItems();
                if (recipe != null) {
                    pedestalItems.forEach(i -> {
                        i = null;
                    });
                    this.catalystItem = recipe.getResult(pedestalItems, this.catalystItem, this);
                    this.clearItems();
                    ParticleUtil.spawnPoof((ServerLevel)this.f_58857_, this.f_58858_);
                }
                this.isCrafting = false;
            }
            this.updateBlock();
        }
    }

    public void clearItems() {
        BlockPos.m_121990_((BlockPos)this.m_58899_().m_142082_(3, -3, 3), (BlockPos)this.m_58899_().m_142082_(-3, 3, -3)).forEach(blockPos -> {
            if (this.f_58857_.m_7702_(blockPos) instanceof ArcanePedestalTile && ((ArcanePedestalTile)this.f_58857_.m_7702_((BlockPos)blockPos)).stack != null) {
                ArcanePedestalTile tile = (ArcanePedestalTile)this.f_58857_.m_7702_(blockPos);
                tile.stack = tile.stack == null ? ItemStack.f_41583_ : tile.stack.getContainerItem();
                BlockState state = this.f_58857_.m_8055_(blockPos);
                this.f_58857_.m_7260_(blockPos, state, state, 3);
            }
        });
    }

    public List<BlockPos> pedestalList() {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        BlockPos.m_121990_((BlockPos)this.m_58899_().m_142082_(5, -3, 5), (BlockPos)this.m_58899_().m_142082_(-3, 3, -3)).forEach(blockPos -> {
            if (this.f_58857_.m_7702_(blockPos) instanceof ArcanePedestalTile && ((ArcanePedestalTile)this.f_58857_.m_7702_((BlockPos)blockPos)).stack != null && !((ArcanePedestalTile)this.f_58857_.m_7702_((BlockPos)blockPos)).stack.m_41619_()) {
                posList.add(blockPos.m_7949_());
            }
        });
        return posList;
    }

    public List<ItemStack> getPedestalItems() {
        ArrayList<ItemStack> pedestalItems = new ArrayList<ItemStack>();
        BlockPos.m_121990_((BlockPos)this.m_58899_().m_142082_(3, -3, 3), (BlockPos)this.m_58899_().m_142082_(-3, 3, -3)).forEach(blockPos -> {
            if (this.f_58857_.m_7702_(blockPos) instanceof ArcanePedestalTile && ((ArcanePedestalTile)this.f_58857_.m_7702_((BlockPos)blockPos)).stack != null && !((ArcanePedestalTile)this.f_58857_.m_7702_((BlockPos)blockPos)).stack.m_41619_()) {
                pedestalItems.add(((ArcanePedestalTile)this.f_58857_.m_7702_((BlockPos)blockPos)).stack);
            }
        });
        return pedestalItems;
    }

    public IEnchantingRecipe getRecipe(ItemStack stack, @Nullable Player playerEntity) {
        List<ItemStack> pedestalItems = this.getPedestalItems();
        return ArsNouveauAPI.getInstance().getEnchantingApparatusRecipes(this.f_58857_).stream().filter(r -> r.isMatch(pedestalItems, stack, this, playerEntity)).findFirst().orElse(null);
    }

    public boolean attemptCraft(ItemStack catalyst, @Nullable Player playerEntity) {
        if (this.isCrafting) {
            return false;
        }
        if (!this.craftingPossible(catalyst, playerEntity)) {
            return false;
        }
        IEnchantingRecipe recipe = this.getRecipe(catalyst, playerEntity);
        if (recipe.consumesSource()) {
            SourceUtil.takeSourceNearbyWithParticles(this.f_58858_, this.f_58857_, 10, recipe.getSourceCost());
        }
        this.isCrafting = true;
        this.updateBlock();
        Networking.sendToNearby(this.f_58857_, this.f_58858_, (Object)new PacketOneShotAnimation(this.f_58858_));
        return true;
    }

    public boolean craftingPossible(ItemStack stack, Player playerEntity) {
        if (this.isCrafting || stack.m_41619_()) {
            return false;
        }
        IEnchantingRecipe recipe = this.getRecipe(stack, playerEntity);
        return recipe != null && (!recipe.consumesSource() || recipe.consumesSource() && SourceUtil.hasSourceNearby(this.f_58858_, this.f_58857_, 10, recipe.getSourceCost()));
    }

    @Override
    public void updateBlock() {
        if (this.counter == 0) {
            this.counter = 1;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.catalystItem = ItemStack.m_41712_((CompoundTag)((CompoundTag)compound.m_128423_("itemStack")));
        this.isCrafting = compound.m_128471_("is_crafting");
        this.counter = compound.m_128451_("counter");
        super.m_142466_(compound);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.catalystItem != null) {
            CompoundTag reagentTag = new CompoundTag();
            this.catalystItem.m_41739_(reagentTag);
            tag.m_128365_("itemStack", (Tag)reagentTag);
        }
        tag.m_128379_("is_crafting", this.isCrafting);
        tag.m_128405_("counter", this.counter);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("counter", this.counter);
        tag.m_128379_("is_crafting", this.isCrafting);
        this.m_183515_(tag);
        return tag;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.catalystItem.m_41619_();
    }

    public ItemStack m_8020_(int index) {
        if (this.isCrafting) {
            return ItemStack.f_41583_;
        }
        return this.catalystItem;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (this.isCrafting || stack.m_41619_()) {
            return false;
        }
        return this.catalystItem.m_41619_() && this.craftingPossible(stack, null);
    }

    public ItemStack m_7407_(int index, int count) {
        if (this.isCrafting) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.catalystItem.m_41777_();
        this.catalystItem.m_41774_(count);
        this.updateBlock();
        return stack;
    }

    public ItemStack m_8016_(int index) {
        if (this.isCrafting) {
            return ItemStack.f_41583_;
        }
        return this.catalystItem;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (this.isCrafting) {
            return;
        }
        this.catalystItem = stack;
        this.updateBlock();
        this.attemptCraft(this.catalystItem, null);
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    public void m_6211_() {
        this.catalystItem = ItemStack.f_41583_;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.itemHandler.invalidate();
        super.invalidateCaps();
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 1.0f, this::idlePredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "craft_controller", 1.0f, this::craftPredicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    private <E extends BlockEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("floating", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends BlockEntity> PlayState craftPredicate(AnimationEvent<E> event) {
        if (!this.isCrafting) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void startAnimation(int arg) {
        AnimationData data = this.manager.getOrCreateAnimationData(Integer.valueOf(this.hashCode()));
        data.setResetSpeedInTicks(0.0);
        AnimationController controller = (AnimationController)data.getAnimationControllers().get("craft_controller");
        controller.markNeedsReload();
        controller.setAnimation(new AnimationBuilder().addAnimation("enchanting", Boolean.valueOf(false)));
    }
}

