/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class BasicSpellTurret
extends TickableModBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;

    public BasicSpellTurret(BlockBehaviour.Properties properties, String registry) {
        super(properties, registry);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE));
    }

    public BasicSpellTurret() {
        this(BasicSpellTurret.defaultProperties().m_60955_(), "basic_spell_turret");
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        this.shootSpell(worldIn, pos);
    }

    public void shootSpell(ServerLevel world, BlockPos pos) {
        BasicSpellTurretTile tile = (BasicSpellTurretTile)world.m_7702_(pos);
        if (tile == null || tile.spell.isEmpty()) {
            return;
        }
        int manaCost = tile.getManaCost();
        if (SourceUtil.takeSourceNearbyWithParticles(pos, (Level)world, 10, manaCost) == null) {
            return;
        }
        Networking.sendToNearby((Level)world, pos, (Object)new PacketOneShotAnimation(pos));
        Position iposition = BasicSpellTurret.getDispensePosition((BlockSource)new BlockSourceImpl(world, pos));
        Direction direction = (Direction)world.m_8055_(pos).m_61143_((Property)FACING);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer(world);
        fakePlayer.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(tile.spell, (LivingEntity)fakePlayer).withCastingTile(world.m_7702_(pos)).withType(SpellContext.CasterType.TURRET).withColors(tile.color));
        if (resolver.castType instanceof MethodProjectile) {
            this.shootProjectile(world, pos, tile, resolver);
            return;
        }
        if (resolver.castType instanceof MethodTouch) {
            BlockPos touchPos = new BlockPos(iposition.m_7096_(), iposition.m_7098_(), iposition.m_7094_());
            if (direction == Direction.WEST || direction == Direction.NORTH) {
                touchPos = touchPos.m_142300_(direction);
            }
            if (direction == Direction.DOWN) {
                touchPos = touchPos.m_7495_();
            }
            resolver.onCastOnBlock(new BlockHitResult(new Vec3((double)touchPos.m_123341_(), (double)touchPos.m_123342_(), (double)touchPos.m_123343_()), direction.m_122424_(), new BlockPos(touchPos.m_123341_(), touchPos.m_123342_(), touchPos.m_123343_()), false), (LivingEntity)fakePlayer);
        }
    }

    public void shootProjectile(ServerLevel world, BlockPos pos, BasicSpellTurretTile tile, SpellResolver resolver) {
        Position iposition = BasicSpellTurret.getDispensePosition((BlockSource)new BlockSourceImpl(world, pos));
        Direction direction = (Direction)world.m_8055_(pos).m_61143_((Property)DispenserBlock.f_52659_);
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)world);
        fakePlayer.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        EntityProjectileSpell spell = new EntityProjectileSpell((Level)world, resolver);
        spell.m_5602_((Entity)fakePlayer);
        spell.m_6034_(iposition.m_7096_(), iposition.m_7098_(), iposition.m_7094_());
        spell.m_6686_(direction.m_122429_(), direction.m_122430_(), direction.m_122431_(), 0.5f, 0.0f);
        world.m_7967_((Entity)spell);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean neighborSignal = worldIn.m_46753_(pos) || worldIn.m_46753_(pos.m_7494_());
        boolean isTriggered = (Boolean)state.m_61143_((Property)TRIGGERED);
        if (neighborSignal && !isTriggered) {
            worldIn.m_186460_(pos, (Block)this, 4);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.TRUE), 4);
        } else if (!neighborSignal && isTriggered) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE), 4);
        }
    }

    public boolean m_7278_(BlockState state) {
        return false;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)worldIn.m_7702_(pos));
    }

    public static Position getDispensePosition(BlockSource coords) {
        Direction direction = (Direction)coords.m_6414_().m_61143_((Property)FACING);
        double d0 = coords.m_7096_() + 0.5 * (double)direction.m_122429_();
        double d1 = coords.m_7098_() + 0.5 * (double)direction.m_122430_();
        double d2 = coords.m_7094_() + 0.5 * (double)direction.m_122431_();
        return new PositionImpl(d0, d1, d2);
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (handIn == InteractionHand.MAIN_HAND) {
            ItemStack stack = player.m_21120_(handIn);
            if (!(stack.m_41720_() instanceof SpellParchment) || worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Spell spell = CasterUtil.getCaster(stack).getSpell();
            if (spell.isEmpty()) {
                return InteractionResult.SUCCESS;
            }
            if (!(spell.recipe.get(0) instanceof MethodTouch) && !(spell.recipe.get(0) instanceof MethodProjectile)) {
                PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.alert.turret_type"));
                return InteractionResult.SUCCESS;
            }
            BasicSpellTurretTile tile = (BasicSpellTurretTile)worldIn.m_7702_(pos);
            tile.spell = spell;
            tile.color = CasterUtil.getCaster(stack).getColor();
            tile.color.makeVisible();
            PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.alert.spell_set"));
            worldIn.m_7260_(pos, state, state, 2);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TRIGGERED});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BasicSpellTurretTile(pos, state);
    }
}

