/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.client.renderer.entity.CarbuncleModel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ArmorItem;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class ModelLayerRenderer<T extends Entity>
extends GeoLayerRenderer
implements IGeoRenderer<T> {
    AnimatedGeoModel geoModelProvider;
    private static Map<Class<? extends ArmorItem>, GeoArmorRenderer> renderers = new ConcurrentHashMap<Class<? extends ArmorItem>, GeoArmorRenderer>();

    public ModelLayerRenderer(IGeoRenderer<T> entityRendererIn, AnimatedGeoModel modelProvider) {
        super(entityRendererIn);
        this.geoModelProvider = modelProvider;
    }

    public AnimatedGeoModel<T> getGeoModelProvider() {
        return this.geoModelProvider;
    }

    public ResourceLocation getTextureLocation(T instance) {
        return this.geoModelProvider.getTextureLocation(instance);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Entity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.m_85836_();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.headPitch = headPitch;
        entityModelData.netHeadYaw = netHeadYaw;
        GeoModel model = this.geoModelProvider.getModel(this.geoModelProvider.getModelLocation((Object)entity));
        AnimationEvent predicate = new AnimationEvent((IAnimatable)entity, limbSwing, limbSwingAmount, partialTicks, !(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f), Collections.singletonList(entityModelData));
        IBone carbuncle = ((CarbuncleModel)this.getEntityModel()).getBone("carbuncle");
        this.geoModelProvider.setLivingAnimations((IAnimatable)entity, this.getUniqueID(entity), predicate);
        IBone head = ((CarbuncleModel)this.getEntityModel()).getBone("head");
        matrixStackIn.m_85837_((double)(carbuncle.getPositionX() / 32.0f), (double)(carbuncle.getPositionY() / 16.0f), (double)carbuncle.getPositionZ());
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(carbuncle.getRotationZ());
        matrixStackIn.m_85845_(quaternion);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation((T)entity));
        Color renderColor = this.getRenderColor(entity, partialTicks, matrixStackIn, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(entity, partialTicks, matrixStackIn, bufferIn, null, packedLightIn, this.getTextureLocation((T)entity));
        this.render(model, entity, partialTicks, renderType, matrixStackIn, bufferIn, null, packedLightIn, OverlayTexture.f_118083_, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        matrixStackIn.m_85849_();
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof Entity) {
                // empty if block
            }
            return null;
        });
    }
}

