/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetBookMode;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiRadialMenu
extends Screen {
    private static final float PRECISION = 5.0f;
    private boolean closing;
    private double startAnimation;
    private ItemStack casterStack;
    private int selectedItem;

    public GuiRadialMenu(ItemStack casterStack) {
        super((Component)new TextComponent(""));
        this.casterStack = casterStack;
        this.closing = false;
        this.f_96541_ = Minecraft.m_91087_();
        this.startAnimation = (double)this.getMinecraft().f_91073_.m_46467_() + (double)this.getMinecraft().m_91296_();
        this.selectedItem = -1;
    }

    public GuiRadialMenu() {
        super((Component)new TextComponent(""));
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (Minecraft.m_91087_().f_91080_ instanceof GuiRadialMenu && event.getType() == RenderGameOverlayEvent.ElementType.LAYER) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void updateInputEvent(MovementInputUpdateEvent event) {
        if (Minecraft.m_91087_().f_91080_ instanceof GuiRadialMenu) {
            Options settings = Minecraft.m_91087_().f_91066_;
            Input eInput = event.getInput();
            eInput.f_108568_ = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)settings.f_92085_.getKey().m_84873_());
            eInput.f_108569_ = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)settings.f_92087_.getKey().m_84873_());
            eInput.f_108570_ = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)settings.f_92086_.getKey().m_84873_());
            eInput.f_108571_ = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)settings.f_92088_.getKey().m_84873_());
            float f = eInput.f_108568_ == eInput.f_108569_ ? 0.0f : (eInput.f_108567_ = eInput.f_108568_ ? 1.0f : -1.0f);
            eInput.f_108566_ = eInput.f_108570_ == eInput.f_108571_ ? 0.0f : (eInput.f_108570_ ? 1.0f : -1.0f);
            eInput.f_108572_ = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)settings.f_92089_.getKey().m_84873_());
            eInput.f_108573_ = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)settings.f_92090_.getKey().m_84873_());
            if (Minecraft.m_91087_().f_91074_.m_108635_()) {
                eInput.f_108566_ = (float)((double)eInput.f_108566_ * 0.3);
                eInput.f_108567_ = (float)((double)eInput.f_108567_ * 0.3);
            }
        }
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        float e;
        float s;
        int i;
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        float OPEN_ANIMATION_LENGTH = 2.5f;
        long worldTime = Minecraft.m_91087_().f_91073_.m_46467_();
        float animationTime = (float)((double)((float)worldTime + partialTicks) - this.startAnimation);
        float openAnimation = this.closing ? 1.0f - animationTime / 2.5f : animationTime / 2.5f;
        float animProgress = Mth.m_14036_((float)openAnimation, (float)0.0f, (float)1.0f);
        float radiusIn = Math.max(0.1f, 45.0f * animProgress);
        float radiusOut = radiusIn * 2.0f;
        float itemRadius = (radiusIn + radiusOut) * 0.5f;
        float animTop = (1.0f - animProgress) * (float)this.f_96544_ / 2.0f;
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        int numberOfSlices = 10;
        double a = Math.toDegrees(Math.atan2(mouseY - y, mouseX - x));
        double d = Math.sqrt(Math.pow(mouseX - x, 2.0) + Math.pow(mouseY - y, 2.0));
        float s0 = (-0.5f / (float)numberOfSlices + 0.25f) * 360.0f;
        if (a < (double)s0) {
            a += 360.0;
        }
        ms.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.m_85837_(0.0, (double)animTop, 0.0);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        boolean hasMouseOver = false;
        int mousedOverSlot = -1;
        if (!this.closing) {
            this.selectedItem = -1;
            for (i = 0; i < numberOfSlices; ++i) {
                s = (((float)i - 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
                e = (((float)i + 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
                if (!(a >= (double)s) || !(a < (double)e) || !(d >= (double)radiusIn) || !(d < (double)radiusOut)) continue;
                this.selectedItem = i;
                break;
            }
        }
        for (i = 0; i < numberOfSlices; ++i) {
            s = (((float)i - 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
            e = (((float)i + 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
            if (this.selectedItem == i) {
                this.drawSlice(buffer, x, y, 10.0f, radiusIn, radiusOut, s, e, 63, 161, 191, 60);
                hasMouseOver = true;
                mousedOverSlot = this.selectedItem;
                continue;
            }
            this.drawSlice(buffer, x, y, 10.0f, radiusIn, radiusOut, s, e, 0, 0, 0, 64);
        }
        tessellator.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        ISpellCaster caster = CasterUtil.getCaster(this.casterStack);
        if (hasMouseOver && mousedOverSlot != -1) {
            int adjusted = (mousedOverSlot + 6) % 10;
            adjusted = adjusted == 0 ? 10 : adjusted;
            String string = caster.getSpellName(adjusted);
            int n = this.f_96543_ / 2;
            Objects.requireNonNull(this.f_96547_);
            GuiRadialMenu.m_93208_((PoseStack)ms, (Font)this.f_96547_, (String)string, (int)n, (int)((this.f_96544_ - 9) / 2), (int)0xFFFFFF);
        }
        ms.m_85849_();
        for (int i2 = 0; i2 < numberOfSlices; ++i2) {
            ItemStack stack = new ItemStack((ItemLike)Blocks.f_50493_);
            float angle1 = ((float)i2 / (float)numberOfSlices - 0.25f) * 2.0f * (float)Math.PI;
            float posX = (float)(x - 8) + itemRadius * (float)Math.cos(angle1);
            float posY = (float)(y - 8) + itemRadius * (float)Math.sin(angle1);
            String resourceIcon = "";
            String castType = "";
            for (AbstractSpellPart p : caster.getSpell((int)(i2 + 1)).recipe) {
                if (p instanceof AbstractCastMethod) {
                    castType = p.getIcon();
                }
                if (!(p instanceof AbstractEffect)) continue;
                resourceIcon = p.getIcon();
                break;
            }
            RenderSystem.m_69465_();
            if (!resourceIcon.isEmpty()) {
                GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/items/" + resourceIcon), (int)posX, (int)posY, 0, 0, 16, 16, 16, 16, ms);
                GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/items/" + castType), (int)posX + 3, (int)posY - 10, 0, 0, 10, 10, 10, 10, ms);
            }
            this.f_96542_.m_115174_(this.f_96547_, stack, (int)posX + 5, (int)posY, String.valueOf(i2 + 1));
        }
        if (mousedOverSlot != -1) {
            int adjusted = (mousedOverSlot + 6) % 10;
            this.selectedItem = adjusted = adjusted == 0 ? 10 : adjusted;
        }
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        int adjustedKey = key - 48;
        if (adjustedKey >= 0 && adjustedKey < 10) {
            this.selectedItem = adjustedKey == 0 ? 10 : adjustedKey;
            this.m_6375_(0.0, 0.0, 0);
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.selectedItem != -1) {
            ISpellCaster caster = CasterUtil.getCaster(this.casterStack);
            caster.setCurrentSlot(this.selectedItem);
            Networking.INSTANCE.sendToServer((Object)new PacketSetBookMode(this.casterStack.m_41783_()));
            this.f_96541_.f_91074_.m_6915_();
        }
        return true;
    }

    private void drawSlice(BufferBuilder buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, Mth.m_14167_((float)(angle / 5.0f)));
        startAngle = (float)Math.toRadians(startAngle);
        endAngle = (float)Math.toRadians(endAngle);
        angle = endAngle - startAngle;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i / (float)sections * angle;
            float angle2 = startAngle + (float)(i + 1) / (float)sections * angle;
            float pos1InX = x + radiusIn * (float)Math.cos(angle1);
            float pos1InY = y + radiusIn * (float)Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float)Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float)Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float)Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float)Math.sin(angle2);
            float pos2InX = x + radiusIn * (float)Math.cos(angle2);
            float pos2InY = y + radiusIn * (float)Math.sin(angle2);
            buffer.m_5483_((double)pos1OutX, (double)pos1OutY, (double)z).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)pos1InX, (double)pos1InY, (double)z).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)pos2InX, (double)pos2InY, (double)z).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)pos2OutX, (double)pos2OutY, (double)z).m_6122_(r, g, b, a).m_5752_();
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

