/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.util.SpellPartConfigUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class AbstractSpellPart
implements ISpellTier,
Comparable<AbstractSpellPart> {
    public String tag;
    public String name;
    @Nullable
    public ForgeConfigSpec CONFIG;
    @Nullable
    public ForgeConfigSpec.IntValue COST;
    @Nullable
    public ForgeConfigSpec.BooleanValue ENABLED;
    @Nullable
    public ForgeConfigSpec.BooleanValue STARTER_SPELL;
    @Nullable
    public ForgeConfigSpec.IntValue PER_SPELL_LIMIT;
    private SpellPartConfigUtil.AugmentLimits augmentLimits;

    public String getTag() {
        return this.tag;
    }

    public String getIcon() {
        return this.tag + ".png";
    }

    protected AbstractSpellPart(String tag, String name) {
        this.tag = tag;
        this.name = name;
        for (SpellSchool spellSchool : this.getSchools()) {
            spellSchool.addSpellPart(this);
        }
    }

    public int getAdjustedManaCost(List<AbstractAugment> augmentTypes) {
        int cost = this.getConfigCost();
        for (AbstractAugment a : augmentTypes) {
            if (a instanceof AugmentDampen && !this.dampenIsAllowed()) continue;
            cost += a.getConfigCost();
        }
        return Math.max(cost, 0);
    }

    public abstract int getDefaultManaCost();

    public int getConfigCost() {
        return this.COST == null ? this.getDefaultManaCost() : ((Integer)this.COST.get()).intValue();
    }

    @Nullable
    public Item getCraftingReagent() {
        return null;
    }

    public boolean dampenIsAllowed() {
        return this.getCompatibleAugments().contains(AugmentDampen.INSTANCE);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.ONE;
    }

    @Nonnull
    public abstract Set<AbstractAugment> getCompatibleAugments();

    protected Set<AbstractAugment> augmentSetOf(AbstractAugment ... augments) {
        return this.setOf(augments);
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[0]);
    }

    protected <T> Set<T> setOf(T ... list) {
        return Set.of(list);
    }

    @Override
    public int compareTo(AbstractSpellPart o) {
        return this.getTier().ordinal() - o.getTier().ordinal();
    }

    public TranslatableComponent getBookDescLang() {
        return new TranslatableComponent("ars_nouveau.glyph_desc." + this.getTag());
    }

    public JsonElement serialize() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", this.getName());
        jsonobject.addProperty("icon", "ars_nouveau:" + this.getItemID());
        jsonobject.addProperty("category", "ars_nouveau:spells_" + (this.getTier().ordinal() + 1));
        jsonobject.addProperty("sortnum", (Number)(this instanceof AbstractCastMethod ? 1 : (this instanceof AbstractEffect ? 2 : 3)));
        JsonArray jsonArray = new JsonArray();
        JsonObject descPage = new JsonObject();
        descPage.addProperty("type", "patchouli:text");
        descPage.addProperty("text", "ars_nouveau.glyph_desc." + this.tag);
        JsonObject infoPage = new JsonObject();
        infoPage.addProperty("type", "ars_nouveau:glyph_recipe");
        infoPage.addProperty("recipe", "ars_nouveau:glyph_" + this.tag);
        infoPage.addProperty("tier", this.getTier().name());
        String manaCost = this.getDefaultManaCost() < 20 ? "Low" : "Medium";
        manaCost = this.getDefaultManaCost() > 50 ? "High" : manaCost;
        infoPage.addProperty("mana_cost", manaCost);
        if (this.getCraftingReagent() != null) {
            String clayType = this.getTier() == ISpellTier.Tier.ONE ? ItemsRegistry.MAGIC_CLAY.getRegistryName().toString() : (this.getTier() == ISpellTier.Tier.TWO ? ItemsRegistry.MARVELOUS_CLAY.getRegistryName().toString() : ItemsRegistry.MYTHICAL_CLAY.getRegistryName().toString());
            infoPage.addProperty("clay_type", clayType);
            infoPage.addProperty("reagent", this.getCraftingReagent().getRegistryName().toString());
        }
        jsonArray.add((JsonElement)descPage);
        jsonArray.add((JsonElement)infoPage);
        jsonobject.add("pages", (JsonElement)jsonArray);
        return jsonobject;
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("General settings").push("general");
        this.ENABLED = builder.comment("Is Enabled?").define("enabled", true);
        this.COST = builder.comment("Cost").defineInRange("cost", this.getDefaultManaCost(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.STARTER_SPELL = builder.comment("Is Starter Glyph?").define("starter", this.defaultedStarterGlyph());
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
    }

    public int getAugmentLimit(String augmentTag) {
        if (this.augmentLimits == null) {
            return Integer.MAX_VALUE;
        }
        return this.augmentLimits.getAugmentLimit(augmentTag);
    }

    protected void buildAugmentLimitsConfig(ForgeConfigSpec.Builder builder, Map<String, Integer> defaults) {
        this.augmentLimits = SpellPartConfigUtil.buildAugmentLimitsConfig(builder, defaults);
    }

    protected Map<String, Integer> getDefaultAugmentLimits() {
        return new HashMap<String, Integer>();
    }

    public boolean defaultedStarterGlyph() {
        return false;
    }

    public String getItemID() {
        return "glyph_" + this.getTag();
    }

    public String getBookDescription() {
        return "";
    }

    public String getLocalizationKey() {
        return "ars_nouveau.glyph_name." + this.tag;
    }

    public String getLocaleName() {
        return new TranslatableComponent(this.getLocalizationKey()).getString();
    }
}

