/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.recipe;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GlyphPressRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    public final ISpellTier.Tier tier;
    public final ItemStack reagent;
    public final ItemStack output;
    public static final String RECIPE_ID = "glyph_recipe";

    public GlyphPressRecipe(ResourceLocation id, ISpellTier.Tier tier, ItemStack reagent, ItemStack output) {
        this.id = id;
        this.tier = tier;
        this.reagent = reagent;
        this.output = output;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return false;
    }

    public ItemStack m_5874_(Container inv) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeRegistry.PRESS_SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)Registry.f_122864_.m_7745_(new ResourceLocation("ars_nouveau", RECIPE_ID));
    }

    public ItemStack getClay() {
        return GlyphPressRecipe.getClayFromTier(this.tier);
    }

    public static ItemStack getClayFromTier(ISpellTier.Tier tier) {
        switch (tier) {
            case ONE: {
                return new ItemStack((ItemLike)ItemsRegistry.MAGIC_CLAY);
            }
            case TWO: {
                return new ItemStack((ItemLike)ItemsRegistry.MARVELOUS_CLAY);
            }
        }
        return new ItemStack((ItemLike)ItemsRegistry.MYTHICAL_CLAY);
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<GlyphPressRecipe> {
        public GlyphPressRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ISpellTier.Tier tier = ISpellTier.Tier.valueOf(GsonHelper.m_13851_((JsonObject)json, (String)"tier", (String)"ONE"));
            ItemStack input = new ItemStack((ItemLike)GsonHelper.m_13909_((JsonObject)json, (String)"input"));
            ItemStack output = new ItemStack((ItemLike)GsonHelper.m_13909_((JsonObject)json, (String)"output"));
            return new GlyphPressRecipe(recipeId, tier, input, output);
        }

        @Nullable
        public GlyphPressRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ISpellTier.Tier tier = ISpellTier.Tier.valueOf(buffer.m_130277_());
            ItemStack input = buffer.m_130267_();
            ItemStack output = buffer.m_130267_();
            return new GlyphPressRecipe(recipeId, tier, input, output);
        }

        public void toNetwork(FriendlyByteBuf buf, GlyphPressRecipe recipe) {
            buf.m_130070_(recipe.tier.toString());
            buf.m_130055_(recipe.reagent);
            buf.m_130055_(recipe.output);
        }
    }
}

