/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EffectToss
extends AbstractEffect {
    public static EffectToss INSTANCE = new EffectToss();

    public EffectToss() {
        super("toss", "Toss");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext);
        BlockPos pos = rayTraceResult.m_82443_().m_142538_();
        this.summonStack(shooter, spellContext, world, pos);
    }

    public void summonStack(LivingEntity shooter, SpellContext context, Level world, BlockPos pos) {
        ItemStack casterStack = this.extractStackFromCaster(shooter, context, i -> {
            if (!i.m_41619_() && shooter instanceof Player) {
                return !ItemStack.m_41728_((ItemStack)shooter.m_21205_(), (ItemStack)i);
            }
            return false;
        }, 64);
        world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, casterStack.m_41777_()));
        casterStack.m_41764_(0);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveBlock(rayTraceResult, world, shooter, spellStats, spellContext);
        BlockPos pos = rayTraceResult.m_82425_().m_142300_(rayTraceResult.m_82434_());
        if (world.m_7702_(rayTraceResult.m_82425_()) != null && world.m_7702_(rayTraceResult.m_82425_()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            BlockEntity tileEntity = world.m_7702_(rayTraceResult.m_82425_());
            IItemHandler iItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            if (iItemHandler == null) {
                return;
            }
            ItemStack casterStack = this.getItemFromCaster(shooter, spellContext, (ItemStack i) -> {
                if (i.m_41619_()) {
                    return false;
                }
                if (shooter instanceof Player) {
                    return !ItemStack.m_41728_((ItemStack)shooter.m_21205_(), (ItemStack)i);
                }
                return true;
            });
            ItemStack stack = this.extractStackFromCaster(shooter, spellContext, stack1 -> {
                if (stack1.m_41619_()) {
                    return false;
                }
                for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                    if (!iItemHandler.isItemValid(i, casterStack)) continue;
                    return true;
                }
                return false;
            }, 64);
            ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)stack, (boolean)false);
            this.insertStackToCaster(shooter, spellContext, left);
        } else {
            this.summonStack(shooter, spellContext, world, pos);
        }
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.f_42162_;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    public String getBookDescription() {
        return "Causes the caster to place an item from their inventory to a location. If this glyph is used on an inventory, the item will attempt to be inserted into it.";
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(new AbstractAugment[0]);
    }
}

