/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectFreeze
extends AbstractEffect {
    public static EffectFreeze INSTANCE = new EffectFreeze();

    private EffectFreeze() {
        super("freeze", "Freeze");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockPos pos = rayTraceResult.m_82425_();
        for (BlockPos p : SpellUtil.calcAOEBlocks(shooter, pos, rayTraceResult, spellStats.getBuffCount(AugmentAOE.INSTANCE), spellStats.getBuffCount(AugmentPierce.INSTANCE))) {
            this.extinguishOrFreeze(world, p);
            for (Direction d : Direction.values()) {
                this.extinguishOrFreeze(world, p.m_142300_(d));
            }
        }
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (!(rayTraceResult.m_82443_() instanceof LivingEntity)) {
            return;
        }
        this.applyConfigPotion((LivingEntity)rayTraceResult.m_82443_(), MobEffects.f_19597_, spellStats);
    }

    public void extinguishOrFreeze(Level world, BlockPos p) {
        BlockState state = world.m_8055_(p.m_7494_());
        FluidState fluidState = world.m_6425_(p.m_7494_());
        if (fluidState.m_76152_() == Fluids.f_76193_ && state.m_60734_() instanceof LiquidBlock) {
            world.m_46597_(p.m_7494_(), Blocks.f_50126_.m_49966_());
        } else if (fluidState.m_76152_() == Fluids.f_76195_ && state.m_60734_() instanceof LiquidBlock) {
            world.m_46597_(p.m_7494_(), Blocks.f_50080_.m_49966_());
        } else if (fluidState.m_76152_() == Fluids.f_76194_ && state.m_60734_() instanceof LiquidBlock) {
            world.m_46597_(p.m_7494_(), Blocks.f_50652_.m_49966_());
        } else if (state.m_60767_() == Material.f_76309_) {
            world.m_46961_(p.m_7494_(), false);
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addPotionConfig(builder, 10);
        this.addExtendTimeConfig(builder, 5);
    }

    @Override
    public boolean wouldSucceed(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        return this.nonAirAnythingSuccess(rayTraceResult, world);
    }

    @Override
    public int getDefaultManaCost() {
        return 15;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.f_41981_;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        HashSet<AbstractAugment> augments = new HashSet<AbstractAugment>(this.POTION_AUGMENTS);
        augments.add(AugmentAOE.INSTANCE);
        augments.add(AugmentPierce.INSTANCE);
        return augments;
    }

    @Override
    public String getBookDescription() {
        return "Freezes water or lava in a small area or slows a target for a short time.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_WATER);
    }
}

