/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EffectBreak
extends AbstractEffect {
    public static EffectBreak INSTANCE = new EffectBreak();

    private EffectBreak() {
        super("break", "Break");
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    public ItemStack getStack(LivingEntity shooter) {
        return new ItemStack((ItemLike)Items.f_42390_);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockPos pos = rayTraceResult.m_82425_();
        int aoeBuff = spellStats.getBuffCount(AugmentAOE.INSTANCE);
        int pierceBuff = spellStats.getBuffCount(AugmentPierce.INSTANCE);
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, pos, rayTraceResult, aoeBuff, pierceBuff);
        ItemStack stack = spellStats.hasBuff(AugmentSensitive.INSTANCE) ? new ItemStack((ItemLike)Items.f_42574_) : this.getStack(shooter);
        for (BlockPos pos1 : posList) {
            BlockState state = world.m_8055_(pos1);
            if (!this.canBlockBeHarvested(spellStats, world, pos1) || !BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), world, pos1)) continue;
            if (spellStats.hasBuff(AugmentExtract.INSTANCE)) {
                stack.m_41663_(Enchantments.f_44985_, 1);
                state.m_60734_().m_6240_(world, this.getPlayer(shooter, (ServerLevel)world), pos1, world.m_8055_(pos1), world.m_7702_(pos1), stack);
                BlockUtil.destroyBlockSafely(world, pos1, false, shooter);
                continue;
            }
            if (spellStats.hasBuff(AugmentFortune.INSTANCE)) {
                int bonus = spellStats.getBuffCount(AugmentFortune.INSTANCE);
                stack.m_41663_(Enchantments.f_44987_, bonus);
                state.m_60734_().m_49805_((ServerLevel)world, pos1, state.getExpDrop((LevelReader)world, pos1, bonus, 0));
                state.m_60734_().m_6240_(world, this.getPlayer(shooter, (ServerLevel)world), pos1, world.m_8055_(pos1), world.m_7702_(pos1), stack);
                BlockUtil.destroyBlockSafely(world, pos1, false, shooter);
                continue;
            }
            state.m_60734_().m_6240_(world, this.getPlayer(shooter, (ServerLevel)world), pos1, world.m_8055_(pos1), world.m_7702_(pos1), stack);
            BlockUtil.destroyBlockSafely(world, pos1, false, shooter);
            state.m_60734_().m_49805_((ServerLevel)world, pos1, state.getExpDrop((LevelReader)world, pos1, 0, 0));
        }
    }

    @Override
    public boolean defaultedStarterGlyph() {
        return true;
    }

    @Override
    public boolean wouldSucceed(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        return rayTraceResult instanceof BlockHitResult && world.m_8055_(((BlockHitResult)rayTraceResult).m_82425_()).m_60767_() != Material.f_76296_ && this.canBlockBeHarvested(spellStats, world, ((BlockHitResult)rayTraceResult).m_82425_());
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.f_42385_;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentPierce.INSTANCE, AugmentAOE.INSTANCE, AugmentExtract.INSTANCE, AugmentFortune.INSTANCE, AugmentSensitive.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "A spell you start with. Breaks blocks of an average hardness. Can be amplified to increase the harvest level. Sensitive will simulate breaking blocks with Shears instead of a pickaxe.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_EARTH);
    }
}

