/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IInventoryResponder;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketWarpPosition;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectBlink
extends AbstractEffect {
    public static EffectBlink INSTANCE = new EffectBlink();

    private EffectBlink() {
        super("blink", "Blink");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockPos pos;
        ItemStack scroll;
        Vec3 vec = this.safelyGetHitPos((HitResult)rayTraceResult);
        double distance = (double)((Integer)this.GENERIC_INT.get()).intValue() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
        if (spellContext.castingTile instanceof IInventoryResponder && !(scroll = ((IInventoryResponder)spellContext.castingTile).getItem(new ItemStack((ItemLike)ItemsRegistry.WARP_SCROLL))).m_41619_() && (pos = WarpScroll.getPos(scroll)) != null) {
            EffectBlink.warpEntity(rayTraceResult.m_82443_(), pos);
            return;
        }
        if (rayTraceResult.m_82443_().equals((Object)shooter)) {
            EffectBlink.blinkForward(world, shooter, distance);
            return;
        }
        if (this.isRealPlayer(shooter) && spellContext.castingTile == null && shooter != null) {
            if (shooter.m_21206_().m_41720_() instanceof WarpScroll) {
                BlockPos warpPos = WarpScroll.getPos(shooter.m_21206_());
                if (warpPos != null && !warpPos.equals((Object)BlockPos.f_121853_)) {
                    EffectBlink.warpEntity(rayTraceResult.m_82443_(), warpPos);
                }
            } else {
                shooter.m_6021_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
            }
        } else if (spellContext.getType() == SpellContext.CasterType.RUNE && rayTraceResult.m_82443_() instanceof LivingEntity) {
            EffectBlink.blinkForward(world, (LivingEntity)rayTraceResult.m_82443_(), distance);
        }
    }

    public static void warpEntity(Entity entity, BlockPos warpPos) {
        if (entity == null) {
            return;
        }
        Level world = entity.f_19853_;
        ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 4, (world.f_46441_.nextDouble() - 0.5) * 2.0, -world.f_46441_.nextDouble(), (world.f_46441_.nextDouble() - 0.5) * 2.0, (double)0.1f);
        entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_(), (double)warpPos.m_123343_() + 0.5);
        Networking.sendToNearby(world, entity, (Object)new PacketWarpPosition(entity.m_142049_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.f_19858_, entity.f_19857_));
        entity.f_19853_.m_5594_(null, warpPos, SoundEvents.f_12052_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_() + 1.0, (double)warpPos.m_123343_() + 0.5, 4, (world.f_46441_.nextDouble() - 0.5) * 2.0, -world.f_46441_.nextDouble(), (world.f_46441_.nextDouble() - 0.5) * 2.0, (double)0.1f);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        Vec3 vec = rayTraceResult.m_82450_();
        if (this.isRealPlayer(shooter) && EffectBlink.isValidTeleport(world, rayTraceResult.m_82425_().m_142300_(rayTraceResult.m_82434_()))) {
            EffectBlink.warpEntity((Entity)shooter, new BlockPos(vec));
        }
    }

    public static void blinkForward(Level world, LivingEntity shooter, double distance) {
        Vec3 lookVec = new Vec3(shooter.m_20154_().m_7096_(), 0.0, shooter.m_20154_().m_7094_());
        Vec3 vec = shooter.m_20182_().m_82549_(lookVec.m_82490_(distance));
        BlockPos pos = new BlockPos(vec);
        if (!EffectBlink.isValidTeleport(world, pos)) {
            BlockPos blockPos = pos = EffectBlink.getForward(world, pos, shooter, distance) == null ? EffectBlink.getForward(world, pos.m_6630_(2), shooter, distance) : EffectBlink.getForward(world, pos, shooter, distance);
        }
        if (pos == null) {
            return;
        }
        EffectBlink.warpEntity((Entity)shooter, pos);
    }

    public static BlockPos getForward(Level world, BlockPos pos, LivingEntity shooter, double distance) {
        Vec3 lookVec = new Vec3(shooter.m_20154_().m_7096_(), 0.0, shooter.m_20154_().m_7094_());
        Vec3 oldVec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82549_(lookVec.m_82490_(distance));
        for (double i = distance; i >= 0.0; i -= 1.0) {
            Vec3 vec = oldVec.m_82549_(lookVec.m_82490_(i));
            BlockPos sendPos = new BlockPos(vec);
            if (i <= 0.0) {
                return null;
            }
            if (!EffectBlink.isValidTeleport(world, sendPos)) continue;
            return sendPos;
        }
        return null;
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 8, "Base teleport distance", "distance");
        this.addAmpConfig(builder, 3.0);
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    public static boolean isValidTeleport(Level world, BlockPos pos) {
        return !world.m_8055_(pos).m_60815_() && !world.m_8055_(pos.m_7494_()).m_60815_() && !world.m_8055_(pos.m_6630_(2)).m_60815_();
    }

    @Override
    public int getDefaultManaCost() {
        return 50;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.THREE;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.f_42584_;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Teleports the caster to a location. If an entity is hit and the caster is holding a Warp Scroll in the offhand, the entity will be warped to the location on the Warp Scroll. When used on Self, the caster blinks forward. Spell Turrets and Runes can warp entities using Warp Scrolls from adjacent inventories without consuming the scroll.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

