/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.RitualContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.RitualTile;
import com.hollingsworth.arsnouveau.common.entity.EntityRitualProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayerFactory;

public class RitualDig
extends AbstractRitual {
    public RitualDig() {
    }

    public RitualDig(RitualTile tile, RitualContext context) {
        super(tile, context);
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.tile == null) {
            return;
        }
        EntityRitualProjectile ritualProjectile = new EntityRitualProjectile(this.getWorld(), this.getPos().m_7494_());
        ritualProjectile.m_6034_(ritualProjectile.m_20185_() + 0.5, ritualProjectile.m_20186_(), ritualProjectile.m_20189_() + 0.5);
        ritualProjectile.tilePos = this.getPos();
        this.getWorld().m_7967_((Entity)ritualProjectile);
    }

    public boolean canBlockBeHarvested(BlockPos pos) {
        return this.getWorld().m_8055_(pos).m_60800_((BlockGetter)this.getWorld(), pos) >= 0.0f && SpellUtil.isCorrectHarvestLevel(5, this.getWorld().m_8055_(pos));
    }

    public void breakBlock(BlockPos pos) {
        if (!this.canBlockBeHarvested(pos) || !BlockUtil.destroyRespectsClaim((LivingEntity)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.getWorld())), this.getWorld(), pos)) {
            return;
        }
        BlockState state = this.getWorld().m_8055_(pos);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42390_);
        state.m_60734_().m_6240_(this.getWorld(), (Player)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.getWorld())), pos, this.getWorld().m_8055_(pos), this.getWorld().m_7702_(pos), stack);
        BlockUtil.destroyBlockSafely(this.getWorld(), pos, false, (LivingEntity)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.getWorld())));
    }

    @Override
    public void tick() {
        Level world = this.tile.m_58904_();
        if (world.m_46467_() % 20L == 0L && !world.f_46443_) {
            BlockPos pos = this.tile.m_58899_().m_142127_().m_6625_(this.getContext().progress);
            if (pos.m_123342_() < 1) {
                this.onEnd();
                return;
            }
            this.breakBlock(pos);
            this.breakBlock(pos.m_142128_().m_142128_());
            this.breakBlock(pos.m_142128_().m_142126_());
            this.breakBlock(pos.m_142128_().m_142125_());
            ++this.getContext().progress;
        }
    }

    @Override
    public ParticleColor getCenterColor() {
        return new ParticleColor(this.rand.nextInt(50), this.rand.nextInt(255), this.rand.nextInt(20));
    }

    @Override
    public String getID() {
        return "burrowing";
    }

    @Override
    public String getLangDescription() {
        return "Digs four adjacent holes to bedrock, dropping any blocks.";
    }

    @Override
    public String getLangName() {
        return "Burrowing";
    }
}

