/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateBookGUI;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PacketUpdateSpellbook {
    String spellRecipe;
    int cast_slot;
    String spellName;

    public PacketUpdateSpellbook() {
    }

    public PacketUpdateSpellbook(String spellRecipe, int cast_slot, String spellName) {
        this.spellRecipe = spellRecipe;
        this.cast_slot = cast_slot;
        this.spellName = spellName;
    }

    public PacketUpdateSpellbook(FriendlyByteBuf buf) {
        this.spellRecipe = buf.m_130136_(Short.MAX_VALUE);
        this.cast_slot = buf.readInt();
        this.spellName = buf.m_130136_(Short.MAX_VALUE);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.spellRecipe);
        buf.writeInt(this.cast_slot);
        buf.m_130070_(this.spellName);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            if (((NetworkEvent.Context)ctx.get()).getSender() != null && (stack = StackUtil.getHeldSpellbook((Player)((NetworkEvent.Context)ctx.get()).getSender())) != null && stack.m_41720_() instanceof SpellBook && this.spellRecipe != null) {
                ISpellCaster caster = CasterUtil.getCaster(stack);
                caster.setCurrentSlot(this.cast_slot);
                caster.setSpell(Spell.deserialize(this.spellRecipe));
                caster.setSpellName(this.spellName);
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> PacketUpdateSpellbook.lambda$handle$0((Supplier)ctx)), (Object)new PacketUpdateBookGUI(stack));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ ServerPlayer lambda$handle$0(Supplier ctx) {
        return ((NetworkEvent.Context)ctx.get()).getSender();
    }
}

