/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.goal.CheckStuckGoal;
import com.hollingsworth.arsnouveau.common.util.ArrayUtil;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class GetUnstuckGoal
extends CheckStuckGoal {
    int numUnstucks;
    BlockPos targetPos;
    public Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH};
    Supplier<Boolean> isStuck;
    Mob entity;
    boolean isStuckTrying;
    Function<Boolean, Void> setUnstuck;

    public GetUnstuckGoal(Mob entity, Supplier<Boolean> isStuck, Function<Boolean, Void> setUnstuck) {
        super(() -> ((Mob)entity).m_142538_(), 4, null);
        this.entity = entity;
        this.isStuck = isStuck;
        this.setStuck = this::setStuckTrying;
        this.setUnstuck = setUnstuck;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public Void setStuckTrying(boolean isStuck) {
        this.isStuckTrying = isStuck;
        return null;
    }

    @Override
    public void m_8056_() {
        this.resetStuckCheck();
        ArrayUtil.shuffleArray(this.directions);
        this.numUnstucks = 0;
        this.targetPos = this.getNextTarget();
        this.isStuckTrying = false;
        this.entity.m_21573_().m_26573_();
    }

    public boolean m_8045_() {
        return this.targetPos != null && this.isStuck.get() != false;
    }

    public boolean m_8036_() {
        return this.isStuck.get();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.targetPos == null) {
            return;
        }
        if (!(BlockUtil.distanceFrom(this.entity.m_142538_(), this.targetPos) > 0.5)) {
            this.setUnstuck.apply(false);
            this.targetPos = null;
            return;
        }
        this.entity.m_21573_().m_26536_(this.getPath(this.targetPos), 1.2);
        if (this.isStuckTrying) {
            this.targetPos = this.getNextTarget();
            this.resetStuckCheck();
        }
    }

    public BlockPos getNextTarget() {
        ++this.numUnstucks;
        if (this.numUnstucks >= this.directions.length) {
            return null;
        }
        Direction direction = this.directions[this.numUnstucks];
        if (this.entity.m_6374_() == direction) {
            return this.getNextTarget();
        }
        for (int i = 3; i > 1; --i) {
            BlockPos posToMove = this.entity.m_142538_().m_5484_(direction, i);
            Path path = this.getPath(posToMove);
            if (path != null && path.m_77403_()) {
                return posToMove;
            }
            if (this.getPath(posToMove.m_7495_()) != null && this.getPath(posToMove.m_7495_()).m_77403_()) {
                return posToMove.m_7495_();
            }
            if (this.getPath(posToMove.m_6625_(2)) != null && this.getPath(posToMove.m_6625_(2)).m_77403_()) {
                return posToMove.m_6625_(2);
            }
            if (this.getPath(posToMove.m_7494_()) != null && this.getPath(posToMove.m_7494_()).m_77403_()) {
                return posToMove.m_7494_();
            }
            if (this.getPath(posToMove.m_6630_(2)) == null || !this.getPath(posToMove.m_6630_(2)).m_77403_()) continue;
            return posToMove.m_6630_(2);
        }
        return this.getNextTarget();
    }

    public Path getPath(BlockPos p) {
        return this.entity.m_21573_().m_7864_(p, 0);
    }
}

