/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class EntityOrbitProjectile
extends EntityProjectileSpell {
    public Entity wardedEntity;
    int ticksLeft;
    private static final EntityDataAccessor<Integer> OWNER_UUID = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OFFSET = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ACCELERATES = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> AOE = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> TOTAL = SynchedEntityData.m_135353_(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int extendTimes;

    public EntityOrbitProjectile(Level worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityOrbitProjectile(Level worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
    }

    public EntityOrbitProjectile(Level world, SpellResolver resolver) {
        super(world, resolver);
    }

    public EntityOrbitProjectile(EntityType<EntityOrbitProjectile> entityWardProjectileEntityType, Level world) {
        super((EntityType<? extends EntityProjectileSpell>)entityWardProjectileEntityType, world);
    }

    public void setOffset(int offset) {
        this.f_19804_.m_135381_(OFFSET, (Object)offset);
    }

    public int getOffset() {
        int val = 15;
        return (Integer)this.f_19804_.m_135370_(OFFSET) * val;
    }

    public void setTotal(int total) {
        this.f_19804_.m_135381_(TOTAL, (Object)total);
    }

    public int getTotal() {
        return (Integer)this.f_19804_.m_135370_(TOTAL) > 0 ? (Integer)this.f_19804_.m_135370_(TOTAL) : 1;
    }

    public void setAccelerates(int accelerates) {
        this.f_19804_.m_135381_(ACCELERATES, (Object)accelerates);
    }

    public int getAccelerates() {
        return (Integer)this.f_19804_.m_135370_(ACCELERATES);
    }

    public void setAoe(int aoe) {
        this.f_19804_.m_135381_(AOE, (Object)aoe);
    }

    public int getAoe() {
        return (Integer)this.f_19804_.m_135370_(AOE);
    }

    @Override
    public void m_8119_() {
        EntityHitResult entityraytraceresult;
        ++this.age;
        if (!this.f_19853_.f_46443_ && this.age > 1200 + 600 * this.extendTimes) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!this.f_19853_.f_46443_ && this.spellResolver == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        Entity owner = this.f_19853_.m_6815_(this.getOwnerID());
        if (!this.f_19853_.f_46443_ && owner == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (owner == null) {
            return;
        }
        double rotateSpeed = 10.0 - (double)this.getAccelerates();
        double radiusMultiplier = 1.5 + 0.5 * (double)this.getAoe();
        this.m_6034_(owner.m_20185_() - radiusMultiplier * Math.sin((double)this.f_19797_ / rotateSpeed + (double)this.getOffset()), owner.m_20186_() + 1.0, owner.m_20189_() - radiusMultiplier * Math.cos((double)this.f_19797_ / rotateSpeed + (double)this.getOffset()));
        Vec3 vector3d2 = this.m_20182_();
        int nextTick = this.f_19797_ + 3;
        Vec3 vector3d3 = new Vec3(owner.m_20185_() - radiusMultiplier * Math.sin((double)nextTick / rotateSpeed + (double)this.getOffset()), owner.m_20186_() + 1.0, owner.m_20189_() - radiusMultiplier * Math.cos((double)nextTick / rotateSpeed + (double)this.getOffset()));
        BlockHitResult raytraceresult = this.f_19853_.m_45547_(new ClipContext(vector3d2, vector3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vector3d3 = raytraceresult.m_82450_();
        }
        if ((entityraytraceresult = this.m_6351_(vector3d2, vector3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult instanceof EntityHitResult) {
            Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
            Entity entity1 = this.m_37282_();
            if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
            this.m_6532_((HitResult)raytraceresult);
            this.f_19812_ = true;
        }
        if (this.f_19853_.f_46443_ && this.age > 2) {
            double deltaX = this.m_20185_() - this.f_19790_;
            double deltaY = this.m_20186_() - this.f_19791_;
            double deltaZ = this.m_20189_() - this.f_19792_;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 8.0);
            for (double j = 0.0; j < dist; j += 1.0) {
                double coeff = j / dist;
                this.f_19853_.m_7106_(GlowParticleData.createData(this.getParticleColor()), (double)((float)(this.f_19854_ + deltaX * coeff)), (double)((float)(this.f_19855_ + deltaY * coeff)), (double)((float)(this.f_19856_ + deltaZ * coeff)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)));
            }
        }
    }

    @Override
    protected void attemptRemoval() {
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (this.f_19853_.f_46443_ || result == null) {
            return;
        }
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            if (((EntityHitResult)result).m_82443_().equals((Object)this.m_37282_())) {
                return;
            }
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.f_19853_, (LivingEntity)this.m_37282_(), result);
                Networking.sendToNearby(this.f_19853_, new BlockPos(result.m_82450_()), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.m_82450_()), this.getParticleColorWrapper(), new int[0]));
                this.attemptRemoval();
            }
        } else if (this.numSensitive > 0 && result instanceof BlockHitResult && !this.m_146910_()) {
            BlockHitResult blockraytraceresult = (BlockHitResult)result;
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.f_19853_, (LivingEntity)this.m_37282_(), (HitResult)blockraytraceresult);
            }
            Networking.sendToNearby(this.f_19853_, ((BlockHitResult)result).m_82425_(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.m_82450_()).m_7495_(), this.getParticleColorWrapper(), new int[0]));
            this.attemptRemoval();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, (Object)0);
        this.f_19804_.m_135372_(OFFSET, (Object)0);
        this.f_19804_.m_135372_(ACCELERATES, (Object)0);
        this.f_19804_.m_135372_(AOE, (Object)0);
        this.f_19804_.m_135372_(TOTAL, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("left", this.ticksLeft);
        tag.m_128405_("offset", this.getOffset());
        tag.m_128405_("aoe", this.getAoe());
        tag.m_128405_("accelerate", this.getAccelerates());
        tag.m_128405_("total", this.getTotal());
        tag.m_128405_("ownerID", this.getOwnerID());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.ticksLeft = tag.m_128451_("left");
        this.setOffset(tag.m_128451_("offset"));
        this.setAoe(tag.m_128451_("aoe"));
        this.setAccelerates(tag.m_128451_("accelerate"));
        this.setOwnerID(tag.m_128451_("ownerID"));
        this.setTotal(tag.m_128451_("total"));
    }

    @Override
    public EntityType<?> m_6095_() {
        return ModEntities.ORBIT_SPELL;
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityOrbitProjectile(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends EntityProjectileSpell>)ModEntities.ORBIT_SPELL, world);
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    public int getOwnerID() {
        return (Integer)this.m_20088_().m_135370_(OWNER_UUID);
    }

    public void setOwnerID(int uuid) {
        this.m_20088_().m_135381_(OWNER_UUID, (Object)uuid);
    }
}

