/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class EntityFollowProjectile
extends Arrow {
    public static final EntityDataAccessor<BlockPos> to = SynchedEntityData.m_135353_(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<BlockPos> from = SynchedEntityData.m_135353_(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Integer> RED = SynchedEntityData.m_135353_(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GREEN = SynchedEntityData.m_135353_(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BLUE = SynchedEntityData.m_135353_(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> SPAWN_TOUCH = SynchedEntityData.m_135353_(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DESPAWN = SynchedEntityData.m_135353_(EntityFollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int age;
    int maxAge = 500;

    public EntityFollowProjectile(Level world) {
        super(world, 0.0, 0.0, 0.0);
    }

    public void setDespawnDistance(int distance) {
        this.m_20088_().m_135381_(DESPAWN, (Object)distance);
    }

    public EntityFollowProjectile(Level worldIn, Vec3 from, Vec3 to) {
        this(ModEntities.ENTITY_FOLLOW_PROJ, worldIn);
        this.f_19804_.m_135381_(EntityFollowProjectile.to, (Object)new BlockPos(to));
        this.f_19804_.m_135381_(EntityFollowProjectile.from, (Object)new BlockPos(from));
        this.m_6034_(from.f_82479_ + 0.5, from.f_82480_ + 0.5, from.f_82481_ + 0.5);
        this.f_19804_.m_135381_(RED, (Object)255);
        this.f_19804_.m_135381_(GREEN, (Object)25);
        this.f_19804_.m_135381_(BLUE, (Object)180);
        double distance = BlockUtil.distanceFrom(new BlockPos(from), new BlockPos(to));
        this.setDespawnDistance((int)(distance + 10.0));
    }

    public EntityFollowProjectile(Level worldIn, BlockPos from, BlockPos to, int r, int g, int b) {
        this(worldIn, new Vec3((double)from.m_123341_(), (double)from.m_123342_(), (double)from.m_123343_()), new Vec3((double)to.m_123341_(), (double)to.m_123342_(), (double)to.m_123343_()));
        this.f_19804_.m_135381_(RED, (Object)Math.min(r, 255));
        this.f_19804_.m_135381_(GREEN, (Object)Math.min(g, 255));
        this.f_19804_.m_135381_(BLUE, (Object)Math.min(b, 255));
    }

    public EntityFollowProjectile(Level worldIn, BlockPos from, BlockPos to, ParticleColor.IntWrapper color) {
        this(worldIn, from, to, color.r, color.g, color.b);
    }

    public EntityFollowProjectile(Level worldIn, BlockPos from, BlockPos to) {
        this(worldIn, new Vec3((double)from.m_123341_(), (double)from.m_123342_(), (double)from.m_123343_()), new Vec3((double)to.m_123341_(), (double)to.m_123342_(), (double)to.m_123343_()));
    }

    public EntityFollowProjectile(EntityType<? extends EntityFollowProjectile> entityAOEProjectileEntityType, Level world) {
        super(entityAOEProjectileEntityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(to, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(from, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(RED, (Object)0);
        this.f_19804_.m_135372_(GREEN, (Object)0);
        this.f_19804_.m_135372_(BLUE, (Object)0);
        this.f_19804_.m_135372_(SPAWN_TOUCH, (Object)this.defaultsBurst());
        this.f_19804_.m_135372_(DESPAWN, (Object)10);
    }

    public boolean defaultsBurst() {
        return false;
    }

    public void m_8119_() {
        ++this.age;
        if (this.age > this.maxAge) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        Vec3 vec3d2 = this.m_20184_();
        BlockPos dest = (BlockPos)this.f_19804_.m_135370_(to);
        if (BlockUtil.distanceFrom(this.m_142538_(), dest) < 1.0 || this.age > 1000 || BlockUtil.distanceFrom(this.m_142538_(), dest) > (double)((Integer)this.f_19804_.m_135370_(DESPAWN)).intValue()) {
            if (this.f_19853_.f_46443_ && ((Boolean)this.f_19804_.m_135370_(SPAWN_TOUCH)).booleanValue()) {
                ParticleUtil.spawnTouch((ClientLevel)this.f_19853_, this.m_20097_(), new ParticleColor((Integer)this.f_19804_.m_135370_(RED), (Integer)this.f_19804_.m_135370_(GREEN), (Integer)this.f_19804_.m_135370_(BLUE)));
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        double motionX = this.m_20184_().f_82479_;
        double motionY = this.m_20184_().f_82480_;
        double motionZ = this.m_20184_().f_82481_;
        if (dest.m_123341_() != 0 || dest.m_123342_() != 0 || dest.m_123343_() != 0) {
            double targetX = (double)dest.m_123341_() + 0.5;
            double targetY = (double)dest.m_123342_() + 0.5;
            double targetZ = (double)dest.m_123343_() + 0.5;
            Vec3 targetVector = new Vec3(targetX - posX, targetY - posY, targetZ - posZ);
            double length = targetVector.m_82553_();
            targetVector = targetVector.m_82490_(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = 0.9 * ((3.0 - length) / 3.0);
            }
            motionX = (0.9 - weight) * motionX + (0.1 + weight) * targetVector.f_82479_;
            motionY = (0.9 - weight) * motionY + (0.1 + weight) * targetVector.f_82480_;
            motionZ = (0.9 - weight) * motionZ + (0.1 + weight) * targetVector.f_82481_;
        }
        this.m_6034_(posX += motionX, posY += motionY, posZ += motionZ);
        this.m_20334_(motionX, motionY, motionZ);
        if (this.f_19853_.f_46443_ && this.age > 1) {
            double deltaX = this.m_20185_() - this.f_19790_;
            double deltaY = this.m_20186_() - this.f_19791_;
            double deltaZ = this.m_20189_() - this.f_19792_;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
            int counter = 0;
            for (double i = 0.0; i < dist; i += 1.0) {
                double coeff = i / dist;
                if ((counter += this.f_19853_.f_46441_.nextInt(2)) % (Minecraft.m_91087_().f_91066_.f_92073_.m_92198_() == 0 ? 1 : 2 * Minecraft.m_91087_().f_91066_.f_92073_.m_92198_()) != 0) continue;
                this.f_19853_.m_7106_(GlowParticleData.createData(new ParticleColor((Integer)this.f_19804_.m_135370_(RED), (Integer)this.f_19804_.m_135370_(GREEN), (Integer)this.f_19804_.m_135370_(BLUE))), (double)((float)(this.f_19854_ + deltaX * coeff)), (double)((float)(this.f_19855_ + deltaY * coeff)), (double)((float)(this.f_19856_ + deltaZ * coeff)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)), (double)(0.0125f * (this.f_19796_.nextFloat() - 0.5f)));
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(from, (Object)NBTUtil.getBlockPos(compound, "from"));
        this.f_19804_.m_135381_(to, (Object)NBTUtil.getBlockPos(compound, "to"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (from != null) {
            NBTUtil.storeBlockPos(compound, "from", (BlockPos)this.f_19804_.m_135370_(from));
        }
        if (to != null) {
            NBTUtil.storeBlockPos(compound, "to", (BlockPos)this.f_19804_.m_135370_(to));
        }
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityFollowProjectile(PlayMessages.SpawnEntity packet, Level world) {
        super(ModEntities.ENTITY_FOLLOW_PROJ, world);
    }

    public EntityType<?> m_6095_() {
        return ModEntities.ENTITY_FOLLOW_PROJ;
    }

    public boolean m_20068_() {
        return true;
    }
}

