/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlyphRecipeProvider
implements DataProvider {
    private final DataGenerator generator;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();

    public GlyphRecipeProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void m_6865_(HashCache cache) throws IOException {
        List glyphList = ArsNouveauAPI.getInstance().getGlyphItemMap().values().stream().collect(Collectors.toList());
        Path output = this.generator.m_123916_();
        for (Glyph g : glyphList) {
            Path path = GlyphRecipeProvider.getGlyphPath(output, g);
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)g.asRecipe(), (Path)path);
        }
    }

    private static Path getGlyphPath(Path pathIn, Glyph glyph) {
        return pathIn.resolve("data/ars_nouveau/recipes/glyphs/" + glyph.getRegistryName().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Glyph Recipes";
    }
}

