/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.loot.DungeonLootTables;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DungeonLootGenerator
extends GlobalLootModifierProvider {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> GLM = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"ars_nouveau");
    public static final RegistryObject<DungeonLootEnhancerModifier.Serializer> DUNGEON_LOOT = GLM.register("dungeon_loot", DungeonLootEnhancerModifier.Serializer::new);

    public DungeonLootGenerator(DataGenerator gen, String modid) {
        super(gen, modid);
    }

    protected void start() {
        this.add("dungeon_loot", (GlobalLootModifierSerializer)DUNGEON_LOOT.get(), (IGlobalLootModifier)new DungeonLootEnhancerModifier(new LootItemCondition[]{this.getList(new String[]{"chests/simple_dungeon", "chests/jungle_temple", "chests/abandoned_mineshaft", "chests/bastion_treasure", "chests/desert_pyramid", "chests/end_city_treasure", "chests/ruined_portal", "chests/pillager_outpost", "chests/nether_bridge", "chests/stronghold_corridor", "chests/stronghold_crossing", "chests/stronghold_library", "chests/woodland_mansion", "chests/underwater_ruin_big", "chests/underwater_ruin_small"})}));
    }

    public LootItemCondition getList(String[] chests) {
        Object condition = null;
        for (String s : chests) {
            condition = condition == null ? LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(s)) : condition.m_7818_((LootItemCondition.Builder)LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(s)));
        }
        return condition.m_6409_();
    }

    public static class DungeonLootEnhancerModifier
    extends LootModifier {
        public double commonChance;
        public double uncommonChance;
        public double rareChance;
        public int commonRolls;
        public int uncommonRolls;
        public int rareRolls;

        public DungeonLootEnhancerModifier(LootItemCondition[] conditionsIn, double commonChance, double uncommonChance, double rareChance, int commonRolls, int uncommonRolls, int rareRolls) {
            super(conditionsIn);
            this.commonChance = commonChance;
            this.uncommonChance = uncommonChance;
            this.rareChance = rareChance;
            this.commonRolls = commonRolls;
            this.uncommonRolls = uncommonRolls;
            this.rareRolls = rareRolls;
        }

        public DungeonLootEnhancerModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
            this.commonChance = 0.3;
            this.uncommonChance = 0.2;
            this.rareChance = 0.1;
            this.commonRolls = 3;
            this.uncommonRolls = 2;
            this.rareRolls = 1;
        }

        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            generatedLoot.addAll(DungeonLootTables.getRandomRoll(this));
            return generatedLoot;
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<DungeonLootEnhancerModifier> {
            public DungeonLootEnhancerModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
                return new DungeonLootEnhancerModifier(conditions, object.get("common_chance").getAsDouble(), object.get("uncommon_chance").getAsDouble(), object.get("rare_chance").getAsDouble(), object.get("common_rolls").getAsInt(), object.get("uncommon_rolls").getAsInt(), object.get("rare_rolls").getAsInt());
            }

            public JsonObject write(DungeonLootEnhancerModifier instance) {
                JsonObject obj = this.makeConditions(instance.conditions);
                obj.addProperty("common_chance", (Number)instance.commonChance);
                obj.addProperty("uncommon_chance", (Number)instance.uncommonChance);
                obj.addProperty("rare_chance", (Number)instance.rareChance);
                obj.addProperty("common_rolls", (Number)instance.commonRolls);
                obj.addProperty("uncommon_rolls", (Number)instance.uncommonRolls);
                obj.addProperty("rare_rolls", (Number)instance.rareRolls);
                return obj;
            }
        }
    }
}

