/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class SpellPrismBlock
extends ModBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;

    public SpellPrismBlock(BlockBehaviour.Properties properties, String registry) {
        super(properties, registry);
    }

    public SpellPrismBlock(String name) {
        super(name);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public static void redirectSpell(ServerLevel world, BlockPos pos, EntityProjectileSpell spell) {
        Position iposition = SpellPrismBlock.getDispensePosition((BlockSource)new BlockSourceImpl(world, pos));
        Direction direction = (Direction)world.m_8055_(pos).m_61143_((Property)DispenserBlock.f_52659_);
        spell.m_6034_(iposition.m_7096_(), iposition.m_7098_(), iposition.m_7094_());
        if (spell.spellResolver == null) {
            spell.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        float velocity = 0.5f + 0.1f * (float)Math.min(2, spell.spellResolver.spell.getBuffsAtIndex(0, null, AugmentAccelerate.INSTANCE));
        spell.m_6686_(direction.m_122429_(), direction.m_122430_(), direction.m_122431_(), velocity, 0.0f);
        for (Direction d : Direction.values()) {
            BlockState observer;
            BlockPos adjacentPos = pos.m_142300_(d);
            if (!(world.m_8055_(adjacentPos).m_60734_() instanceof ObserverBlock) || !adjacentPos.m_142300_((Direction)(observer = world.m_8055_(adjacentPos)).m_61143_((Property)FACING)).equals((Object)pos)) continue;
            world.m_186460_(pos.m_142300_(d), world.m_8055_(pos.m_142300_(d)).m_60734_(), 2);
        }
    }

    public static Position getDispensePosition(BlockSource coords) {
        Direction direction = (Direction)coords.m_6414_().m_61143_((Property)FACING);
        double d0 = coords.m_7096_() + 0.3 * (double)direction.m_122429_();
        double d1 = coords.m_7098_() + 0.3 * (double)direction.m_122430_();
        double d2 = coords.m_7094_() + 0.3 * (double)direction.m_122431_();
        return new PositionImpl(d0, d1, d2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

