/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.PressModel;
import com.hollingsworth.arsnouveau.common.block.tile.GlyphPressTile;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoBlockRenderer;

public class PressRenderer
extends GeoBlockRenderer<GlyphPressTile> {
    public PressRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn, (AnimatedGeoModel)new PressModel());
    }

    public void renderFloatingItem(GlyphPressTile tileEntityIn, ItemEntity entityItem, double x, double y, double z, PoseStack stack, MultiBufferSource iRenderTypeBuffer) {
        stack.m_85836_();
        ++tileEntityIn.frames;
        entityItem.m_5616_((float)tileEntityIn.frames);
        Minecraft.m_91087_().m_91290_().m_114384_((Entity)entityItem, 0.5, 1.0, 0.5, entityItem.f_19857_, 2.0f, stack, iRenderTypeBuffer, 0xF000F0);
        Minecraft.m_91087_().m_91290_().m_114382_((Entity)entityItem);
        stack.m_85849_();
    }

    public void renderPressedItem(double x, double y, double z, Item itemToRender, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int i, int il) {
        matrixStack.m_85836_();
        Direction direction1 = Direction.m_122407_((int)((1 + Direction.NORTH.m_122416_()) % 4));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-direction1.m_122435_()));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, -0.2);
        matrixStack.m_85841_(0.35f, 0.35f, 0.35f);
        Minecraft.m_91087_().m_91291_().m_174269_(new ItemStack((ItemLike)itemToRender), ItemTransforms.TransformType.NONE, 150, il, matrixStack, iRenderTypeBuffer, 1);
        matrixStack.m_85849_();
    }

    public void renderEarly(GlyphPressTile tileEntityIn, PoseStack matrixStack, float ticks, MultiBufferSource iRenderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        double x = tileEntityIn.m_58899_().m_123341_();
        double y = tileEntityIn.m_58899_().m_123342_();
        double z = tileEntityIn.m_58899_().m_123343_();
        if (tileEntityIn.baseMaterial == null || tileEntityIn.baseMaterial.m_41619_()) {
            return;
        }
        if (tileEntityIn.entity == null || !ItemStack.m_41728_((ItemStack)tileEntityIn.entity.m_32055_(), (ItemStack)tileEntityIn.reagentItem)) {
            tileEntityIn.entity = new ItemEntity(tileEntityIn.m_58904_(), x, y, z, tileEntityIn.reagentItem);
        }
        x += 0.5;
        y += 0.9;
        z += 0.5;
        if (tileEntityIn.counter <= 40) {
            this.renderPressedItem(x, y, z, tileEntityIn.baseMaterial.m_41720_(), matrixStack, iRenderTypeBuffer, packedLightIn, packedOverlayIn);
        } else if (tileEntityIn.counter <= 110) {
            this.renderPressedItem(x, y, z, ItemsRegistry.BLANK_GLYPH, matrixStack, iRenderTypeBuffer, packedLightIn, packedOverlayIn);
        } else {
            this.renderPressedItem(x, y, z, tileEntityIn.baseMaterial.m_41720_(), matrixStack, iRenderTypeBuffer, packedLightIn, packedOverlayIn);
        }
        if (tileEntityIn.counter > 70 && tileEntityIn.counter < 120) {
            BlockPos pos = tileEntityIn.m_58899_();
            Level world = tileEntityIn.m_58904_();
            if (world.m_46467_() % 3L != 0L) {
                return;
            }
            for (int i = 0; i < 1; ++i) {
                double posX = pos.m_123341_();
                double posY = pos.m_123342_();
                double posZ = pos.m_123343_();
                double randX = (double)world.f_46441_.nextFloat() > 0.5 ? (double)world.f_46441_.nextFloat() : (double)(-world.f_46441_.nextFloat());
                double randZ = (double)world.f_46441_.nextFloat() > 0.5 ? (double)world.f_46441_.nextFloat() : (double)(-world.f_46441_.nextFloat());
                double d0 = posX + 0.5 + randX * 0.2;
                double d1 = posY + 0.4;
                double d2 = posZ + 0.5 + randZ * 0.2;
                double spdX = (double)world.f_46441_.nextFloat() > 0.5 ? (double)world.f_46441_.nextFloat() : (double)(-world.f_46441_.nextFloat());
                double spdZ = (double)world.f_46441_.nextFloat() > 0.5 ? (double)world.f_46441_.nextFloat() : (double)(-world.f_46441_.nextFloat());
                world.m_7106_((ParticleOptions)ParticleTypes.f_123808_, d0, d1, d2, spdX * 0.05, 0.0, spdZ * 0.05);
            }
        }
    }

    public static GenericItemRenderer getISTER() {
        return new GenericItemRenderer(new PressModel());
    }
}

