/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.patchouli.component;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.client.patchouli.component.RotatingItemListComponentBase;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.item.crafting.Ingredient;
import vazkii.patchouli.api.IVariable;

public class RotatingItemListComponent
extends RotatingItemListComponentBase {
    @SerializedName(value="recipe_name")
    public String recipeName;
    @SerializedName(value="recipe_type")
    public String recipeType;

    @Override
    protected List<Ingredient> makeIngredients() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if ("enchanting_apparatus".equals(this.recipeType)) {
            EnchantingApparatusRecipe recipe = world.m_7465_().m_44013_(RecipeRegistry.APPARATUS_TYPE).stream().filter(f -> f.id.toString().equals(this.recipeName)).findFirst().orElse(null);
            return recipe == null ? ImmutableList.of() : recipe.pedestalItems;
        }
        if ("imbuement_chamber".equals(this.recipeType)) {
            ImbuementRecipe recipe = world.m_7465_().m_44013_(RecipeRegistry.IMBUEMENT_TYPE).stream().filter(f -> f.id.toString().equals(this.recipeName)).findFirst().orElse(null);
            return recipe == null ? ImmutableList.of() : recipe.pedestalItems;
        }
        throw new IllegalArgumentException("Type must be 'enchanting_apparatus' or 'imbuement_chamber'!");
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.recipeName = ((IVariable)lookup.apply(IVariable.wrap((String)this.recipeName))).asString();
        this.recipeType = ((IVariable)lookup.apply(IVariable.wrap((String)this.recipeType))).asString();
    }
}

