/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.keybindings;

import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.client.gui.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.keybindings.ModKeyBindings;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateSpellbook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class KeyHandler {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();

    public static void checkKeysPressed(int key) {
        ItemStack stack = StackUtil.getHeldSpellbook((Player)KeyHandler.MINECRAFT.f_91074_);
        ISpellCaster caster = null;
        if (stack.m_41720_() instanceof SpellBook) {
            caster = CasterUtil.getCaster(stack);
        }
        if (key == ModKeyBindings.NEXT_SLOT.getKey().m_84873_() && stack.m_41720_() instanceof SpellBook) {
            if (!stack.m_41782_()) {
                return;
            }
            caster.setNextSlot();
            KeyHandler.sendUpdatePacket(stack, caster.getCurrentSlot());
            return;
        }
        if (key == ModKeyBindings.PREVIOUS_SLOT.getKey().m_84873_() && stack.m_41720_() instanceof SpellBook) {
            if (!stack.m_41782_()) {
                return;
            }
            caster.setPreviousSlot();
            KeyHandler.sendUpdatePacket(stack, caster.getCurrentSlot());
            return;
        }
        if (key == ModKeyBindings.OPEN_SPELL_SELECTION.getKey().m_84873_()) {
            if (KeyHandler.MINECRAFT.f_91080_ instanceof GuiRadialMenu) {
                KeyHandler.MINECRAFT.f_91074_.m_6915_();
                return;
            }
            if (stack.m_41720_() instanceof SpellBook && stack.m_41782_() && KeyHandler.MINECRAFT.f_91080_ == null) {
                MINECRAFT.m_91152_((Screen)new GuiRadialMenu(stack));
            }
        }
        if (key == ModKeyBindings.OPEN_BOOK.getKey().m_84873_()) {
            if (KeyHandler.MINECRAFT.f_91080_ instanceof GuiSpellBook && !((GuiSpellBook)KeyHandler.MINECRAFT.f_91080_).spell_name.m_93696_()) {
                KeyHandler.MINECRAFT.f_91074_.m_6915_();
                return;
            }
            if (stack.m_41720_() instanceof SpellBook && KeyHandler.MINECRAFT.f_91080_ == null) {
                GuiSpellBook.open(stack, ((SpellBook)stack.m_41720_()).getTier().ordinal());
            }
        }
    }

    @SubscribeEvent
    public static void mouseEvent(InputEvent.MouseInputEvent event) {
        if (KeyHandler.MINECRAFT.f_91074_ == null || KeyHandler.MINECRAFT.f_91080_ != null || event.getAction() != 1) {
            return;
        }
        KeyHandler.checkKeysPressed(event.getButton());
    }

    @SubscribeEvent
    public static void keyEvent(InputEvent.KeyInputEvent event) {
        if (KeyHandler.MINECRAFT.f_91074_ == null || KeyHandler.MINECRAFT.f_91080_ != null || event.getAction() != 1) {
            return;
        }
        KeyHandler.checkKeysPressed(event.getKey());
    }

    public static void sendUpdatePacket(ItemStack stack, int newMode) {
        ISpellCaster caster = CasterUtil.getCaster(stack);
        String recipe = caster.getSpell(newMode).serialize();
        String name = caster.getSpellName(newMode);
        Networking.INSTANCE.sendToServer((Object)new PacketUpdateSpellbook(recipe, newMode, name));
    }
}

