/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class CraftingButton
extends GuiImageButton {
    int slotNum;
    public String spellTag;
    public String resourceIcon;
    public List<SpellValidationError> validationErrors;

    public CraftingButton(GuiSpellBook parent, int x, int y, int slotNum, Button.OnPress onPress) {
        super(x, y, 0, 0, 22, 20, 22, 20, "textures/gui/spell_glyph_slot.png", onPress);
        this.slotNum = slotNum;
        this.spellTag = "";
        this.resourceIcon = "";
        this.validationErrors = new LinkedList<SpellValidationError>();
        this.parent = parent;
    }

    public void clear() {
        this.spellTag = "";
        this.resourceIcon = "";
        this.validationErrors.clear();
    }

    @Override
    public void m_6305_(PoseStack ms, int parX, int parY, float partialTicks) {
        if (this.f_93624_) {
            if (this.validationErrors.isEmpty()) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
            if (!this.resourceIcon.equals("")) {
                GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/items/" + this.resourceIcon), this.f_93620_ + 3, this.f_93621_ + 2, this.u, this.v, 16, 16, 16, 16, ms);
            }
            if (this.parent.isMouseInRelativeRange(parX, parY, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_) && this.parent.api.getSpellpartMap().containsKey(this.spellTag)) {
                LinkedList<Object> tooltip = new LinkedList<Object>();
                tooltip.add(new TranslatableComponent(this.parent.api.getSpellpartMap().get(this.spellTag).getLocalizationKey()));
                for (SpellValidationError ve : this.validationErrors) {
                    tooltip.add(ve.makeTextComponentExisting().m_130940_(ChatFormatting.RED));
                }
                this.parent.tooltip = tooltip;
            }
        }
        super.m_6305_(ms, parX, parY, partialTicks);
    }
}

