/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.client.gui.GuiEntityInfoHUD;
import com.hollingsworth.arsnouveau.client.gui.GuiManaHUD;
import com.hollingsworth.arsnouveau.client.gui.GuiScrollHUD;
import com.hollingsworth.arsnouveau.client.gui.GuiSpellHUD;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class HUDEventHandler {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final GuiSpellHUD spellHUD = new GuiSpellHUD();
    private static final GuiManaHUD manaHUD = new GuiManaHUD();
    private static final GuiEntityInfoHUD entityHUD = new GuiEntityInfoHUD();
    private static final GuiScrollHUD scrollHUD = new GuiScrollHUD();

    @SubscribeEvent
    public static void renderSpellHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        LocalPlayer player = HUDEventHandler.minecraft.f_91074_;
        spellHUD.drawHUD(event.getMatrixStack());
        manaHUD.drawHUD(event.getMatrixStack(), event.getPartialTicks());
    }

    @SubscribeEvent
    public static void renderEntityHUD(RenderGameOverlayEvent.Post event) {
        EntityHitResult result;
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        HitResult mouseOver = Minecraft.m_91087_().f_91077_;
        if (mouseOver != null && mouseOver.m_6662_() == HitResult.Type.ENTITY) {
            result = (EntityHitResult)mouseOver;
            if (result.m_82443_() instanceof ITooltipProvider) {
                entityHUD.drawHUD(event.getMatrixStack(), ((ITooltipProvider)result.m_82443_()).getTooltip(new ArrayList<Component>()));
            }
            if (result.m_82443_() instanceof ItemFrame) {
                scrollHUD.drawHUD(event.getMatrixStack(), (ItemFrame)result.m_82443_());
            }
        }
        if (mouseOver != null && mouseOver.m_6662_() == HitResult.Type.BLOCK) {
            result = (BlockHitResult)mouseOver;
            BlockPos pos = result.m_82425_();
            if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_7702_(pos) instanceof ITooltipProvider) {
                entityHUD.drawHUD(event.getMatrixStack(), ((ITooltipProvider)Minecraft.m_91087_().f_91073_.m_7702_(pos)).getTooltip(new ArrayList<Component>()));
            }
        }
    }
}

