/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class SourceUtil {
    @Nullable
    public static BlockPos takeSourceNearby(BlockPos pos, Level world, int range, int mana) {
        Optional loc = BlockPos.m_121930_((BlockPos)pos, (int)range, (int)range, b -> world.m_7702_(b) instanceof SourceJarTile && ((SourceJarTile)world.m_7702_(b)).getSource() >= mana);
        if (!loc.isPresent()) {
            return null;
        }
        SourceJarTile tile = (SourceJarTile)world.m_7702_((BlockPos)loc.get());
        tile.removeSource(mana);
        return (BlockPos)loc.get();
    }

    @Nullable
    public static BlockPos takeSourceNearbyWithParticles(BlockPos pos, Level world, int range, int mana) {
        BlockPos result = SourceUtil.takeSourceNearby(pos, world, range, mana);
        if (result != null) {
            EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(world, result, pos);
            world.m_7967_((Entity)aoeProjectile);
        }
        return result;
    }

    public static boolean hasSourceNearby(BlockPos pos, Level world, int range, int mana) {
        Optional loc = BlockPos.m_121930_((BlockPos)pos, (int)range, (int)range, b -> world.m_7702_(b) instanceof SourceJarTile && ((SourceJarTile)world.m_7702_(b)).getSource() >= mana);
        return loc.isPresent();
    }

    @Nullable
    public static BlockPos canGiveSourceClosest(BlockPos pos, Level world, int range) {
        Optional loc = BlockPos.m_121930_((BlockPos)pos, (int)range, (int)range, b -> world.m_7702_(b) instanceof SourceJarTile && ((SourceJarTile)world.m_7702_(b)).canAcceptSource());
        return loc.orElse(null);
    }

    public static List<BlockPos> canGiveSourceAny(BlockPos pos, Level world, int range) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        BlockPos.m_121985_((BlockPos)pos, (int)range, (int)range, (int)range).forEach(b -> {
            if (world.m_7702_(b) instanceof SourceJarTile && ((SourceJarTile)world.m_7702_(b)).canAcceptSource()) {
                posList.add(b.m_7949_());
            }
        });
        return posList;
    }
}

