/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class NBTUtil {
    public static CompoundTag storeBlockPos(CompoundTag tag, String prefix, BlockPos pos) {
        if (pos == null) {
            return tag;
        }
        tag.m_128347_(prefix + "_x", (double)pos.m_123341_());
        tag.m_128347_(prefix + "_y", (double)pos.m_123342_());
        tag.m_128347_(prefix + "_z", (double)pos.m_123343_());
        return tag;
    }

    public static CompoundTag removeBlockPos(CompoundTag tag, String prefix) {
        tag.m_128473_(prefix + "_x");
        tag.m_128473_(prefix + "_y");
        tag.m_128473_(prefix + "_z");
        return tag;
    }

    public static BlockPos getBlockPos(CompoundTag tag, String prefix) {
        return new BlockPos(tag.m_128459_(prefix + "_x"), tag.m_128459_(prefix + "_y"), tag.m_128459_(prefix + "_z"));
    }

    public static boolean hasBlockPos(CompoundTag tag, String prefix) {
        return tag.m_128441_(prefix + "_x");
    }

    public static List<ItemStack> readItems(CompoundTag tag, String prefix) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (tag == null) {
            return stacks;
        }
        for (String s : tag.m_128431_()) {
            if (!s.contains(prefix)) continue;
            stacks.add(ItemStack.m_41712_((CompoundTag)tag.m_128469_(s)));
        }
        return stacks;
    }

    public static void writeItems(CompoundTag tag, String prefix, List<ItemStack> items) {
        for (ItemStack item : items) {
            CompoundTag itemTag = new CompoundTag();
            item.m_41739_(itemTag);
            tag.m_128365_(NBTUtil.getItemKey(item, prefix), (Tag)itemTag);
        }
    }

    public static List<String> readStrings(CompoundTag tag, String prefix) {
        ArrayList<String> strings = new ArrayList<String>();
        if (tag == null) {
            return strings;
        }
        for (String s : tag.m_128431_()) {
            if (!s.contains(prefix)) continue;
            strings.add(tag.m_128461_(s));
        }
        return strings;
    }

    public static void writeStrings(CompoundTag tag, String prefix, Collection<String> strings) {
        int i = 0;
        for (String s : strings) {
            tag.m_128359_(prefix + "_" + i, s);
            ++i;
        }
    }

    public static String getItemKey(ItemStack stack, String prefix) {
        return prefix + stack.m_41720_().getRegistryName().toString();
    }
}

