/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.mana.IManaEquipment;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.common.armor.MagicArmor;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ManaUtil {
    public static int getPlayerDiscounts(LivingEntity e) {
        AtomicInteger discounts = new AtomicInteger();
        CuriosUtil.getAllWornItems(e).ifPresent(items -> {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).m_41720_();
                if (!(item instanceof IManaEquipment)) continue;
                discounts.addAndGet(((IManaEquipment)item).getManaDiscount(items.getStackInSlot(i)));
            }
        });
        return discounts.get();
    }

    public static int getMaxMana(Player e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return 0;
        }
        int max = (Integer)Config.INIT_MAX_MANA.get();
        for (ItemStack i : e.m_20158_()) {
            if (i.m_41720_() instanceof IManaEquipment) {
                max += ((IManaEquipment)i.m_41720_()).getMaxManaBoost(i);
            }
            max += (Integer)Config.MANA_BOOST_BONUS.get() * EnchantmentHelper.m_44843_((Enchantment)EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, (ItemStack)i);
        }
        IItemHandlerModifiable items = (IItemHandlerModifiable)CuriosUtil.getAllWornItems((LivingEntity)e).orElse(null);
        if (items != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).m_41720_();
                if (!(item instanceof IManaEquipment)) continue;
                max += ((IManaEquipment)item).getMaxManaBoost(items.getStackInSlot(i));
            }
        }
        int tier = mana.getBookTier();
        int numGlyphs = mana.getGlyphBonus() > 5 ? mana.getGlyphBonus() - 5 : 0;
        max += numGlyphs * (Integer)Config.GLYPH_MAX_BONUS.get();
        MaxManaCalcEvent event = new MaxManaCalcEvent((LivingEntity)e, max += tier * (Integer)Config.TIER_MAX_BONUS.get());
        MinecraftForge.EVENT_BUS.post((Event)event);
        max = event.getMax();
        return max;
    }

    public static double getManaRegen(Player e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return 0.0;
        }
        double regen = ((Integer)Config.INIT_MANA_REGEN.get()).intValue();
        for (ItemStack i : e.m_20158_()) {
            if (i.m_41720_() instanceof MagicArmor) {
                MagicArmor armor = (MagicArmor)i.m_41720_();
                regen += (double)armor.getManaRegenBonus(i);
            }
            regen += (double)((Integer)Config.MANA_REGEN_ENCHANT_BONUS.get() * EnchantmentHelper.m_44843_((Enchantment)EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, (ItemStack)i));
        }
        IItemHandlerModifiable items = (IItemHandlerModifiable)CuriosUtil.getAllWornItems((LivingEntity)e).orElse(null);
        if (items != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).m_41720_();
                if (!(item instanceof IManaEquipment)) continue;
                regen += (double)((IManaEquipment)item).getManaRegenBonus(items.getStackInSlot(i));
            }
        }
        int tier = mana.getBookTier();
        double numGlyphs = mana.getGlyphBonus() > 5 ? (double)(mana.getGlyphBonus() - 5) : 0.0;
        regen += numGlyphs * (Double)Config.GLYPH_REGEN_BONUS.get();
        regen += (double)tier;
        if (e.m_21124_((MobEffect)ModPotions.MANA_REGEN_EFFECT) != null) {
            regen += (double)((Integer)Config.MANA_REGEN_POTION.get() * (1 + e.m_21124_((MobEffect)ModPotions.MANA_REGEN_EFFECT).m_19564_()));
        }
        ManaRegenCalcEvent event = new ManaRegenCalcEvent((LivingEntity)e, regen);
        MinecraftForge.EVENT_BUS.post((Event)event);
        regen = event.getRegen();
        return regen;
    }
}

