/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public interface ISpellCaster {
    @Nonnull
    public Spell getSpell();

    @Nonnull
    public Spell getSpell(int var1);

    public int getMaxSlots();

    public int getCurrentSlot();

    public void setCurrentSlot(int var1);

    default public void setNextSlot() {
        int slot = this.getCurrentSlot() + 1;
        if (slot > this.getMaxSlots()) {
            slot = 1;
        }
        this.setCurrentSlot(slot);
    }

    default public void setPreviousSlot() {
        int slot = this.getCurrentSlot() - 1;
        if (slot < 1) {
            slot = this.getMaxSlots();
        }
        this.setCurrentSlot(slot);
    }

    public void setSpell(Spell var1, int var2);

    public void setSpell(Spell var1);

    @Nonnull
    public ParticleColor.IntWrapper getColor(int var1);

    @Nonnull
    public ParticleColor.IntWrapper getColor();

    public void setColor(ParticleColor.IntWrapper var1);

    public void setColor(ParticleColor.IntWrapper var1, int var2);

    public void setFlavorText(String var1);

    public String getSpellName(int var1);

    public String getSpellName();

    public void setSpellName(String var1);

    public void setSpellName(String var1, int var2);

    public String getFlavorText();

    public Map<Integer, Spell> getSpells();

    public Map<Integer, String> getSpellNames();

    public Map<Integer, ParticleColor.IntWrapper> getColors();

    @Nonnull
    default public Spell getSpell(Level world, Player playerEntity, InteractionHand hand, ISpellCaster caster) {
        return caster.getSpell();
    }

    default public InteractionResultHolder<ItemStack> castSpell(Level worldIn, Player playerIn, InteractionHand handIn, @Nullable TranslatableComponent invalidMessage, @Nonnull Spell spell) {
        EntityHitResult entityHitResult;
        ItemStack stack = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)playerIn.m_21120_(handIn));
        }
        if (!spell.isValid() && invalidMessage != null) {
            PortUtil.sendMessageNoSpam((Entity)playerIn, (Component)invalidMessage);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        SpellResolver resolver = this.getSpellResolver(new SpellContext(spell, (LivingEntity)playerIn).withColors(this.getColor()), worldIn, playerIn, handIn);
        boolean isSensitive = resolver.spell.getBuffsAtIndex(0, (LivingEntity)playerIn, AugmentSensitive.INSTANCE) > 0;
        HitResult result = SpellUtil.rayTrace((Entity)playerIn, 5.0, 0.0f, isSensitive);
        if (result instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)result;
            BlockEntity tile = worldIn.m_7702_(blockHit.m_82425_());
            if (tile instanceof ScribesTile) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            if (!playerIn.m_6144_() && tile != null && !worldIn.m_8055_(blockHit.m_82425_()).m_60620_(BlockTagProvider.IGNORE_TILE)) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        if (result instanceof EntityHitResult && (entityHitResult = (EntityHitResult)result).m_82443_() instanceof LivingEntity) {
            resolver.onCastOnEntity(stack, (LivingEntity)playerIn, entityHitResult.m_82443_(), handIn);
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        if (result instanceof BlockHitResult && (result.m_6662_() == HitResult.Type.BLOCK || isSensitive)) {
            UseOnContext context = new UseOnContext(playerIn, handIn, (BlockHitResult)result);
            resolver.onCastOnBlock(context);
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        resolver.onCast(stack, (LivingEntity)playerIn, worldIn);
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
    }

    default public InteractionResultHolder<ItemStack> castSpell(Level worldIn, Player playerIn, InteractionHand handIn, TranslatableComponent invalidMessage) {
        return this.castSpell(worldIn, playerIn, handIn, invalidMessage, this.getSpell(worldIn, playerIn, handIn, this));
    }

    default public SpellResolver getSpellResolver(SpellContext context, Level worldIn, Player playerIn, InteractionHand handIn) {
        return new SpellResolver(context);
    }

    public String getTagID();
}

