/*
 * Decompiled with CFR 0.152.
 */
package com.faux.customentitydata.api.playersaves;

import com.faux.customentitydata.api.playersaves.IPlayerLoadListener;
import com.faux.customentitydata.api.playersaves.IPlayerSaveListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CustomPlayerSave
implements IPlayerSaveListener,
IPlayerLoadListener {
    private final class_2960 handlerId;
    private final Logger log;

    public CustomPlayerSave(class_2960 handlerId) {
        this.handlerId = handlerId;
        this.log = LoggerFactory.getLogger((String)handlerId.toString());
        IPlayerLoadListener.EVENT.register((Object)this);
        IPlayerSaveListener.EVENT.register((Object)this);
    }

    public abstract class_2487 savePlayer(class_1657 var1);

    public abstract void loadPlayer(class_1657 var1, class_2487 var2);

    @Override
    public void loadPlayerData(class_1657 player, Path saveDir) {
        long startTime = System.nanoTime();
        Path customSaveDir = this.getCustomSaveDir(saveDir);
        class_2487 data = new class_2487();
        try {
            Path targetSave = customSaveDir.resolve(player.method_5845() + ".dat");
            if (Files.exists(targetSave, new LinkOption[0]) && Files.isRegularFile(targetSave, new LinkOption[0])) {
                data = class_2507.method_30613((Path)targetSave, (class_2505)class_2505.method_53898());
            }
        }
        catch (IOException e) {
            this.log.error("Failed to read custom data file for player {} ({}).", new Object[]{player.method_5477().getString(), player.method_5845(), e});
        }
        try {
            this.loadPlayer(player, data);
            long endTime = System.nanoTime();
            this.log.debug("Loaded data for {}. Took {}ns.", (Object)player.method_5477().getString(), (Object)(endTime - startTime));
        }
        catch (Exception e) {
            this.log.error("Failed to read custom data for player {} ({}).", new Object[]{player.method_5477().getString(), player.method_5845(), e});
        }
    }

    @Override
    public void savePlayerData(class_1657 player, Path saveDir) {
        try {
            long startTime = System.nanoTime();
            Path customSaveDir = this.getCustomSaveDir(saveDir);
            Path tempSave = Files.createTempFile(customSaveDir, player.method_5845() + "-", ".dat", new FileAttribute[0]);
            class_2507.method_30614((class_2487)this.savePlayer(player), (Path)tempSave);
            Path targetSave = customSaveDir.resolve(player.method_5845() + ".dat");
            Path backupSave = customSaveDir.resolve(player.method_5845() + ".dat_old");
            class_156.method_30626((Path)targetSave, (Path)tempSave, (Path)backupSave);
            long endTime = System.nanoTime();
            this.log.debug("Saved data for {}. Took {}ns.", (Object)player.method_5477().getString(), (Object)(endTime - startTime));
        }
        catch (IOException e) {
            this.log.error("Failed to write custom data for player {} ({}).", new Object[]{player.method_5477().getString(), player.method_5845(), e});
        }
    }

    private Path getCustomSaveDir(Path saveDir) {
        Path customSaveDir = saveDir.resolve(this.handlerId.method_12836()).resolve(this.handlerId.method_12832());
        if (Files.notExists(customSaveDir, new LinkOption[0])) {
            try {
                return Files.createDirectories(customSaveDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.log.error("Failed to create custom save directory {}.", (Object)customSaveDir.toAbsolutePath());
                throw new RuntimeException(e);
            }
        }
        return customSaveDir;
    }
}

