package com.faux.customentitydata.mixin;

import com.faux.customentitydata.api.ICustomDataHolder;
import com.faux.customentitydata.api.PersistentEntityDataConstants;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1297.class)
public abstract class MixinEntity implements ICustomDataHolder {

    @Unique
    public class_2487 faux$persistentData;

    @Override
    public class_2487 faux$getCustomData() {
        if (faux$persistentData == null)
            faux$persistentData = new class_2487();

        return faux$persistentData;
    }

    @Override
    public void faux$setCustomData(class_2487 tag) {
        faux$persistentData = tag;
    }

    @Inject(method = "saveWithoutId", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V", shift = At.Shift.BEFORE))
    public void saveWithoutId(class_11372 valueOutput, CallbackInfo ci) {
        valueOutput.method_71468(PersistentEntityDataConstants.CUSTOM_NBT_KEY, class_2487.field_25128, faux$getCustomData());
    }

    @Inject(method = "load", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V", shift = At.Shift.BEFORE))
    public void load(class_11368 valueInput, CallbackInfo ci) {
        valueInput.method_71426(PersistentEntityDataConstants.CUSTOM_NBT_KEY, class_2487.field_25128).ifPresent(this::faux$setCustomData);
    }

}
