package com.faux.customentitydata.mixin;

import com.faux.customentitydata.api.ICustomDataHolder;
import com.faux.customentitydata.api.IPersistentDataHolder;
import com.faux.customentitydata.api.PersistentEntityDataConstants;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public class MixinServerPlayer implements IPersistentDataHolder {

    @Inject(method = "restoreFrom", at = @At("TAIL"))
    public void restoreFrom(class_3222 other, boolean keepEverything, CallbackInfo ci) {

        IPersistentDataHolder oldHolder = (IPersistentDataHolder) other;
        this.faux$setPersistentData(oldHolder.faux$getPersistentData());
    }

    @Override
    public class_2487 faux$getPersistentData() {
        class_2487 lifetimeData = ((ICustomDataHolder) this).faux$getCustomData();
        if (!lifetimeData.method_10545(PersistentEntityDataConstants.PERSISTENT_NBT_KEY)) {
            class_2487 tag = new class_2487();
            lifetimeData.method_10566(PersistentEntityDataConstants.PERSISTENT_NBT_KEY, tag);
            return tag;
        }
        return lifetimeData.method_68568(PersistentEntityDataConstants.PERSISTENT_NBT_KEY);
    }

    @Override
    public void faux$setPersistentData(class_2487 tag) {
        ((ICustomDataHolder) this).faux$getCustomData().method_10566(PersistentEntityDataConstants.PERSISTENT_NBT_KEY, tag);
    }
}
