package com.faux.customentitydata.mixin;

import com.faux.customentitydata.api.playersaves.IPlayerSaveListener;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.io.File;
import net.minecraft.class_1657;
import net.minecraft.class_29;

@Mixin(class_29.class)
public class MixinPlayerDataStorage {

    @Final
    @Shadow
    private File playerDir;

    @Inject(method = "save(Lnet/minecraft/world/entity/player/Player;)V", at = @At("RETURN"))
    private void onPlayerSave(class_1657 player, CallbackInfo info) {

        IPlayerSaveListener.EVENT.invoker().savePlayerData(player, this.playerDir.toPath());
    }
}