package com.faux.customentitydata.api;

import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class CustomDataHelper {

    /**
     * Gets the custom data on the given Entity.
     *
     * @param entity The entity to get the custom data of.
     * @return The custom data stored on the given entity, or null if the entity is not a ICustomDataHolder.
     */
    public static class_2487 getCustomData(class_1297 entity) {
        if (entity instanceof ICustomDataHolder holder) {
            return holder.faux$getCustomData();
        }
        return null;
    }

    /**
     * Sets the custom data on the given Entity.
     *
     * @param entity The entity to set the custom data of.
     * @param data   The custom data to set.
     */
    public static void setCustomData(class_1297 entity, class_2487 data) {
        if (entity instanceof ICustomDataHolder holder) {
            holder.faux$setCustomData(data);
        }
    }

    /**
     * Gets the persistent data of the given ServerPlayer.
     *
     * @param player The player to get the persistent data of.
     * @return The persistent data stored on the given player, or null if the player is not a IPersistentDataHolder.
     */
    public static class_2487 getPersistentData(class_3222 player) {
        if (player instanceof IPersistentDataHolder holder) {
            return holder.faux$getPersistentData();
        }
        return null;
    }

    /**
     * Sets the persistent data on the given ServerPlayer.
     *
     * @param player The player to set the persistent data of.
     * @param data   The custom data to set.
     */
    public static void setPersistentData(class_3222 player, class_2487 data) {
        if (player instanceof IPersistentDataHolder holder) {
            holder.faux$setPersistentData(data);
        }
    }
}
