/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.api.straw.StrawHandler;
import com.buuz135.industrial.registry.IFRegistries;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class StrawUtils {
    @Nonnull
    public static Optional<StrawHandler> getStrawHandler(@Nonnull Fluid stack) {
        @NotNull List<StrawHandler> current = IFRegistries.STRAW_HANDLER_REGISTRY.stream().sorted(Comparator.comparingInt(StrawHandler::getPriority)).toList();
        for (StrawHandler handler : current) {
            if (!handler.validFluid(stack)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }
}

