/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DrillRecipe;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.buuz135.industrial.recipe.data.EntityData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class LaserDrillFluidRecipe
extends DrillRecipe<SizedFluidIngredient> {
    public static final MapCodec<LaserDrillFluidRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)SizedFluidIngredient.FLAT_CODEC.fieldOf("output").forGetter(o -> (SizedFluidIngredient)o.output), (App)Ingredient.CODEC.fieldOf("catalyst").forGetter(o -> o.catalyst), (App)EntityData.CODEC.optionalFieldOf("entity_data").forGetter(o -> o.entityData), (App)LaserDrillRarity.CODEC.listOf().fieldOf("rarity").forGetter(o -> o.rarity)).apply((Applicative)in, LaserDrillFluidRecipe::new));

    public LaserDrillFluidRecipe(SizedFluidIngredient output, Ingredient catalyst, Optional<EntityData> entityData, List<LaserDrillRarity> rarity) {
        super(output, catalyst, entityData, rarity);
    }

    public LaserDrillFluidRecipe(SizedFluidIngredient output, int color, Optional<EntityData> entityData, LaserDrillRarity ... rarity) {
        super(output, color, entityData, rarity);
    }

    public LaserDrillFluidRecipe(SizedFluidIngredient output, int color, LaserDrillRarity ... rarity) {
        super(output, color, Optional.empty(), rarity);
    }

    public static void init(RecipeOutput output) {
        LaserDrillFluidRecipe.createRecipe(output, "lava", "minecraft", new LaserDrillFluidRecipe(new SizedFluidIngredient(FluidIngredient.of((Fluid[])new Fluid[]{Fluids.LAVA}), 100), 1, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList<TagKey<Biome>>(), new ArrayList<TagKey<Biome>>()), new LaserDrillRarity.DimensionRarity(List.of(BuiltinDimensionTypes.NETHER), new ArrayList<ResourceKey<DimensionType>>()), 5, 20, 8)));
        LaserDrillFluidRecipe.createRecipe(output, "ether", "minecraft", new LaserDrillFluidRecipe(new SizedFluidIngredient(FluidIngredient.of((Fluid[])new Fluid[]{(Fluid)ModuleCore.ETHER.getSourceFluid().get()}), 10), 10, Optional.of(EntityData.of(EntityType.WITHER)), new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(new ArrayList<TagKey<Biome>>(), new ArrayList<TagKey<Biome>>()), new LaserDrillRarity.DimensionRarity(new ArrayList<ResourceKey<DimensionType>>(), new ArrayList<ResourceKey<DimensionType>>()), -64, 256, 8)));
        if (ModList.get().isLoaded("pneumaticcraft")) {
            LaserDrillFluidRecipe.createRecipe(output, "oil", "pneumaticcraft", new LaserDrillFluidRecipe(new SizedFluidIngredient(FluidIngredient.of((Fluid[])new Fluid[]{(Fluid)ModFluids.OIL.get()}), 50), 15, new LaserDrillRarity(new LaserDrillRarity.BiomeRarity(LaserDrillRarity.BiomeRarity.OIL, new ArrayList<TagKey<Biome>>()), new LaserDrillRarity.DimensionRarity(new ArrayList<ResourceKey<DimensionType>>(), new ArrayList<ResourceKey<DimensionType>>()), 20, 60, 8)));
        }
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, String modIdCondition, LaserDrillFluidRecipe recipe) {
        ResourceLocation rl = LaserDrillFluidRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder, new ICondition[]{new ModLoadedCondition(modIdCondition)});
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("laser_drill_fluid/" + key));
    }

    @Override
    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    @Override
    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @Override
    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModuleCore.LASER_DRILL_FLUID_SERIALIZER.get();
    }

    @Override
    public RecipeType<?> getType() {
        return (RecipeType)ModuleCore.LASER_DRILL_FLUID_TYPE.get();
    }

    public static CompoundTag createNBT(String name, int amount) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("FluidName", name);
        nbt.putInt("Amount", amount);
        return nbt;
    }
}

