/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.filter;

import com.buuz135.industrial.item.MobImprisonmentToolItem;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.proxy.block.filter.AbstractFilter;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class ItemStackFilter
extends AbstractFilter<Entity> {
    public ItemStackFilter(int locX, int locY, int sizeX, int sizeY) {
        super(locX, locY, sizeX, sizeY);
    }

    @Override
    public boolean acceptsInput(ItemStack stack) {
        return true;
    }

    @Override
    public boolean matches(Entity entity) {
        boolean isEmpty = true;
        for (IFilter.GhostSlot stack : this.getFilter()) {
            if (stack.getStack().isEmpty()) continue;
            isEmpty = false;
        }
        if (isEmpty) {
            return false;
        }
        for (IFilter.GhostSlot stack : this.getFilter()) {
            if (entity instanceof ItemEntity && ItemStack.isSameItem((ItemStack)stack.getStack(), (ItemStack)((ItemEntity)entity).getItem())) {
                return true;
            }
            if (!(entity instanceof LivingEntity) || !stack.getStack().is(ModuleTool.MOB_IMPRISONMENT_TOOL) || !((MobImprisonmentToolItem)((Object)ModuleTool.MOB_IMPRISONMENT_TOOL.get())).containsEntity(stack.getStack()) || !BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString().equalsIgnoreCase(((MobImprisonmentToolItem)((Object)ModuleTool.MOB_IMPRISONMENT_TOOL.get())).getID(stack.getStack()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(ItemStack itemStack) {
        boolean isEmpty = true;
        for (IFilter.GhostSlot stack : this.getFilter()) {
            if (stack.getStack().isEmpty()) continue;
            isEmpty = false;
        }
        if (isEmpty) {
            return false;
        }
        for (IFilter.GhostSlot stack : this.getFilter()) {
            if (!ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)stack.getStack())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(FluidStack fluidStack) {
        boolean isEmpty = true;
        for (IFilter.GhostSlot stack : this.getFilter()) {
            if (stack.getStack().isEmpty()) continue;
            isEmpty = false;
        }
        if (isEmpty) {
            return false;
        }
        for (IFilter.GhostSlot stack : this.getFilter()) {
            FluidStack original = FluidUtil.getFluidContained((ItemStack)stack.getStack()).orElse(null);
            if (original == null || !FluidStack.isSameFluidSameComponents((FluidStack)original, (FluidStack)fluidStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFilter(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.getFilter().length) {
            this.getFilter()[slot].setStack(stack);
        }
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        for (int i = 0; i < this.getFilter().length; ++i) {
            if (this.getFilter()[i].getStack().isEmpty()) continue;
            compound.put(String.valueOf(i), this.getFilter()[i].getStack().saveOptional(provider));
        }
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        for (int i = 0; i < this.getFilter().length; ++i) {
            if (nbt.contains(String.valueOf(i))) {
                this.getFilter()[i].setStack(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound(String.valueOf(i))));
                continue;
            }
            this.getFilter()[i].setStack(ItemStack.EMPTY);
        }
    }
}

