/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.utils.apihandlers.plant.TreeCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinitySaw
extends ItemInfinity {
    public static LoadingCache<Pair<Level, BlockPos>, TreeCache> SAW_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Pair<Level, BlockPos>, TreeCache>(){

        public TreeCache load(Pair<Level, BlockPos> key) throws Exception {
            TreeCache cache = new TreeCache((Level)key.getLeft(), (BlockPos)key.getRight());
            cache.scanForTreeBlockSection();
            return cache;
        }
    });
    public static int POWER_CONSUMPTION = 10000;
    public static int FUEL_CONSUMPTION = 3;

    public ItemInfinitySaw(TitaniumTab group) {
        super("infinity_saw", group, new Item.Properties().stacksTo(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return Items.DIAMOND_AXE.supportsEnchantment(new ItemStack((ItemLike)Items.DIAMOND_AXE), enchantment);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState blockIn) {
        return Items.DIAMOND_AXE.isCorrectToolForDrops(stack, blockIn);
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof Player && BlockUtils.isLog(worldIn, pos)) {
            try {
                TreeCache cache = (TreeCache)SAW_CACHE.get((Object)Pair.of((Object)worldIn, (Object)pos));
                if (cache != null) {
                    ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                    InfinityTier currentTier = ItemInfinitySaw.getSelectedTier(stack);
                    int operations = this.getBlocksAmount(currentTier.getRadius());
                    for (int i = 0; i < operations; ++i) {
                        if (cache.getWoodCache().isEmpty() && cache.getLeavesCache().isEmpty()) {
                            SAW_CACHE.invalidate((Object)Pair.of((Object)worldIn, (Object)pos));
                            break;
                        }
                        if (!this.enoughFuel(stack)) break;
                        if (!cache.getLeavesCache().isEmpty()) {
                            itemStacks.addAll(cache.chop(cache.getLeavesCache(), false));
                        } else {
                            itemStacks.addAll(cache.chop(cache.getWoodCache(), false));
                        }
                        this.consumeFuel(stack);
                    }
                    itemStacks.forEach(itemStack -> ItemHandlerHelper.giveItemToPlayer((Player)((Player)entityLiving), (ItemStack)itemStack));
                    return false;
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private int getBlocksAmount(int radius) {
        return (radius * 2 + 1) * (radius * 2 + 1);
    }

    @Override
    public void registerRecipe(RecipeOutput consumer) {
        DissolutionChamberRecipe.createRecipe(consumer, "infinity_saw", new DissolutionChamberRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_PICKAXE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_AXE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_AXE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModuleCore.RANGE_ADDONS[11].get())}), Ingredient.of(IndustrialTags.Items.GEAR_GOLD), Ingredient.of(IndustrialTags.Items.GEAR_GOLD), Ingredient.of(IndustrialTags.Items.GEAR_GOLD)), new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2000), 400, Optional.of(new ItemStack((ItemLike)this)), Optional.empty()));
    }
}

