/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator;

import com.buuz135.industrial.block.IndustrialBlock;
import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.generator.tile.MycelialGeneratorTile;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.worlddata.MycelialDataManager;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class MycelialGeneratorBlock
extends IndustrialBlock<MycelialGeneratorTile> {
    private final IMycelialGeneratorType type;

    public MycelialGeneratorBlock(IMycelialGeneratorType type) {
        super("mycelial_" + type.getName(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), MycelialGeneratorTile.class, ModuleGenerator.TAB_GENERATOR);
        this.type = type;
    }

    public BlockEntityType.BlockEntitySupplier<MycelialGeneratorTile> getTileEntityFactory() {
        return (p_155268_, p_155269_) -> new MycelialGeneratorTile(ModuleGenerator.MYCELIAL_GENERATORS.stream().filter(registryObjectRegistryObjectPair -> ((MycelialGeneratorBlock)registryObjectRegistryObjectPair.getBlock()).type == this.type).findFirst().get(), this.type, p_155268_, p_155269_);
    }

    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public IMycelialGeneratorType getType() {
        return this.type;
    }

    @Override
    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        BlockEntity entity = worldIn.getBlockEntity(pos);
        if (entity instanceof MycelialGeneratorTile && placer != null) {
            ((MycelialGeneratorTile)entity).setOwner(placer.getUUID().toString());
        }
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity entity = worldIn.getBlockEntity(pos);
        if (entity instanceof MycelialGeneratorTile) {
            MycelialDataManager.removeGeneratorInfo(((MycelialGeneratorTile)entity).getOwner(), worldIn, pos, this.type);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public void registerRecipe(RecipeOutput consumer) {
        ShapedRecipeBuilder recipe = TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("BBB").pattern("BCB").pattern("RMR").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE);
        this.type.addIngredients(recipe).save(consumer);
    }
}

